/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.interaction;

import com.aliyun.odps.cupid.interaction.WebSocketClient;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.Session;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.annotations.OnWebSocketClose;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.annotations.OnWebSocketConnect;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.annotations.OnWebSocketError;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.annotations.OnWebSocketMessage;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.annotations.WebSocket;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxBinaryMessageSize=65536, maxIdleTime=3600000)
public class InteractionSocket {
    private static final Logger LOG = LoggerFactory.getLogger(InteractionSocket.class);
    private InputStream inputStream;
    private OutputStream outputStream;
    private ByteBuffer inputBuf;
    private ByteBuffer outputBuf;
    private FileOutputStream fileOutputStream;
    private volatile boolean closed;
    private WebSocketClient webSocketClient;
    private int mode;

    public InteractionSocket(WebSocketClient webSocketClient, int inputMode) {
        this.webSocketClient = webSocketClient;
        this.mode = inputMode;
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        LOG.info(this.webSocketClient.getSubProtocol() + " - Connection closed: " + statusCode + " - " + reason);
        if (this.confirmClose(statusCode, reason)) {
            this.webSocketClient.close();
        } else {
            LOG.info(this.webSocketClient.getSubProtocol() + " - Try to reconnect...");
            this.webSocketClient.connect(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        if (1 == this.mode) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {}
            }
        } else if (this.fileOutputStream != null) {
            try {
                this.fileOutputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.inputBuf != null) {
            ByteBuffer byteBuffer = this.inputBuf;
            synchronized (byteBuffer) {
                this.inputBuf.notifyAll();
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @OnWebSocketError
    public void onError(Session session, Throwable errors) {
        LOG.error(this.webSocketClient.getSubProtocol() + " - socket error", errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketConnect
    public void onConnect(Session session) {
        LOG.info(this.webSocketClient.getSubProtocol() + " - Got connect.");
        if (this.mode == 1 && this.inputBuf == null) {
            this.inputBuf = ByteBuffer.allocate(65536);
            this.inputBuf.limit(0);
            this.inputStream = new ByteBufferBackedInputStream(this.inputBuf);
        }
        if (this.outputBuf == null) {
            this.outputBuf = ByteBuffer.allocate(65536);
            this.outputStream = new ByteBufferBackedOutputStream(this.outputBuf, session);
        } else {
            ByteBuffer byteBuffer = this.outputBuf;
            synchronized (byteBuffer) {
                ((ByteBufferBackedOutputStream)this.outputStream).setSession(session);
                this.outputBuf.notify();
            }
        }
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketMessage
    public synchronized void onMessage(Session session, byte[] buf, int offset, int length) {
        if (this.mode == 1) {
            ByteBuffer byteBuffer = this.inputBuf;
            synchronized (byteBuffer) {
                this.inputBuf.clear();
                this.inputBuf.put(buf, offset, length);
                this.inputBuf.flip();
                while (this.inputBuf.hasRemaining()) {
                    this.inputBuf.notify();
                    if (this.closed) {
                        return;
                    }
                    try {
                        this.inputBuf.wait(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                this.inputBuf.limit(0);
            }
        }
        try {
            this.fileOutputStream.write(buf, offset, length);
        }
        catch (IOException e) {
            throw new RuntimeException("Write into inputStream failed!", e);
        }
    }

    public void setInput(FileDescriptor fd) {
        if (0 == this.mode) {
            if (this.fileOutputStream != null) {
                throw new RuntimeException("The fd was set and could't be overwritten!");
            }
        } else {
            if (1 == this.mode) {
                throw new RuntimeException("The mode cannot be changed! Now is inputStream mode and the fd cannot be set!");
            }
            throw new RuntimeException("Invalid mode!");
        }
        this.fileOutputStream = new FileOutputStream(fd);
    }

    private boolean confirmClose(int statusCode, String reason) {
        return statusCode == 1000 || "Shutdown".equalsIgnoreCase(reason);
    }

    public InputStream getInputStream() {
        if (1 == this.mode) {
            return this.inputStream;
        }
        if (0 == this.mode) {
            throw new RuntimeException("The mode cannot be changed! Now is fd mode, you cannot get inputStream!");
        }
        throw new RuntimeException("Invalid mode!");
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    class ByteBufferBackedOutputStream
    extends OutputStream {
        ByteBuffer buf;
        boolean closed;
        Session session;
        long lastFlushTime;

        ByteBufferBackedOutputStream(ByteBuffer buf, Session session) {
            this.buf = buf;
            this.closed = false;
            this.session = session;
            this.lastFlushTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            this.checkClose();
            ByteBuffer byteBuffer = this.buf;
            synchronized (byteBuffer) {
                this.buf.put((byte)b);
                this.buf.flip();
                this.buf.mark();
                this.sendData();
                this.buf.clear();
                this.lastFlushTime = System.currentTimeMillis();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.checkClose();
            ByteBuffer byteBuffer = this.buf;
            synchronized (byteBuffer) {
                this.buf.flip();
                this.buf.mark();
                if (this.buf.hasRemaining()) {
                    this.sendData();
                }
                this.buf.clear();
                this.buf.put(bytes, off, len);
                this.buf.flip();
                this.buf.mark();
                this.sendData();
                this.buf.clear();
                this.lastFlushTime = System.currentTimeMillis();
            }
        }

        private void sendData() {
            while (!this.closed) {
                try {
                    this.session.getRemote().sendBytes(this.buf);
                    return;
                }
                catch (Exception e) {
                    try {
                        this.buf.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        private void checkClose() throws IOException {
            if (this.closed) {
                throw new IOException(InteractionSocket.this.webSocketClient.getSubProtocol() + " - The stream is closed.");
            }
        }

        public void setSession(Session session) {
            this.session = session;
        }
    }

    class ByteBufferBackedInputStream
    extends InputStream {
        ByteBuffer buf;
        boolean closed;

        ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
            this.closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            this.checkClose();
            ByteBuffer byteBuffer = this.buf;
            synchronized (byteBuffer) {
                while (!this.buf.hasRemaining()) {
                    this.buf.notify();
                    if (this.closed) {
                        return -1;
                    }
                    try {
                        this.buf.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.buf.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            this.checkClose();
            ByteBuffer byteBuffer = this.buf;
            synchronized (byteBuffer) {
                while (!this.buf.hasRemaining()) {
                    this.buf.notify();
                    if (this.closed) {
                        return -1;
                    }
                    try {
                        this.buf.wait(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                len = Math.min(len, this.buf.remaining());
                this.buf.get(bytes, off, len);
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.buf != null) {
                ByteBuffer byteBuffer = this.buf;
                synchronized (byteBuffer) {
                    this.buf.notifyAll();
                }
            }
        }

        private void checkClose() throws IOException {
            if (this.closed) {
                throw new IOException(InteractionSocket.this.webSocketClient.getSubProtocol() + " - The stream is closed.");
            }
        }
    }
}

