/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.clusterkv;

import apsara.odps.cupid.protocol.CupidTaskServiceProto;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.basic.rpc.CupidTaskServiceRpcChannel;
import com.aliyun.odps.cupid.basic.rpc.CupidTaskServiceRpcController;
import com.aliyun.odps.cupid.com.google.protobuf.RpcCallback;
import java.util.HashMap;
import java.util.Map;

public class ClusterKvManager {
    private static volatile ClusterKvManager instance;

    private ClusterKvManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterKvManager getInstance() {
        if (instance != null) return instance;
        Class<ClusterKvManager> clazz = ClusterKvManager.class;
        synchronized (ClusterKvManager.class) {
            if (instance != null) return instance;
            instance = new ClusterKvManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void putOrUpdate(CupidSession cupidSession, String key, String value) throws Exception {
        CupidTaskServiceRpcController controller = new CupidTaskServiceRpcController();
        CupidTaskServiceRpcChannel channel = new CupidTaskServiceRpcChannel(cupidSession);
        CupidTaskServiceProto.CupidTaskService.Stub stub = CupidTaskServiceProto.CupidTaskService.newStub(channel);
        CupidTaskServiceProto.PutOrCreateClusterKvRequest.Builder request = CupidTaskServiceProto.PutOrCreateClusterKvRequest.newBuilder();
        request.setProjectName(cupidSession.odps().getDefaultProject());
        request.setKey(key);
        request.setValue(value);
        final CupidTaskServiceProto.PutOrCreateClusterKvResponse.Builder response = CupidTaskServiceProto.PutOrCreateClusterKvResponse.newBuilder();
        RpcCallback<CupidTaskServiceProto.PutOrCreateClusterKvResponse> callback = new RpcCallback<CupidTaskServiceProto.PutOrCreateClusterKvResponse>(){

            @Override
            public void run(CupidTaskServiceProto.PutOrCreateClusterKvResponse parameter) {
                response.mergeFrom(parameter);
            }
        };
        stub.putOrCreateClusterKv(controller, request.build(), callback);
        if (controller.failed()) {
            throw new Exception(controller.errorText());
        }
    }

    public void delete(CupidSession cupidSession, String key) throws Exception {
        CupidTaskServiceRpcController controller = new CupidTaskServiceRpcController();
        CupidTaskServiceRpcChannel channel = new CupidTaskServiceRpcChannel(cupidSession);
        CupidTaskServiceProto.CupidTaskService.Stub stub = CupidTaskServiceProto.CupidTaskService.newStub(channel);
        CupidTaskServiceProto.DeleteClusterKvRequest.Builder request = CupidTaskServiceProto.DeleteClusterKvRequest.newBuilder();
        request.setProjectName(cupidSession.odps().getDefaultProject());
        request.setKey(key);
        final CupidTaskServiceProto.DeleteClusterKvResponse.Builder response = CupidTaskServiceProto.DeleteClusterKvResponse.newBuilder();
        RpcCallback<CupidTaskServiceProto.DeleteClusterKvResponse> callback = new RpcCallback<CupidTaskServiceProto.DeleteClusterKvResponse>(){

            @Override
            public void run(CupidTaskServiceProto.DeleteClusterKvResponse parameter) {
                response.mergeFrom(parameter);
            }
        };
        stub.deleteClusterKv(controller, request.build(), callback);
        if (controller.failed()) {
            throw new Exception(controller.errorText());
        }
    }

    public String get(CupidSession cupidSession, String key) throws Exception {
        CupidTaskServiceRpcController controller = new CupidTaskServiceRpcController();
        CupidTaskServiceRpcChannel channel = new CupidTaskServiceRpcChannel(cupidSession);
        CupidTaskServiceProto.CupidTaskService.Stub stub = CupidTaskServiceProto.CupidTaskService.newStub(channel);
        CupidTaskServiceProto.GetClusterKvRequest.Builder request = CupidTaskServiceProto.GetClusterKvRequest.newBuilder();
        request.setProjectName(cupidSession.odps().getDefaultProject());
        request.setKey(key);
        final CupidTaskServiceProto.GetClusterKvResponse.Builder response = CupidTaskServiceProto.GetClusterKvResponse.newBuilder();
        RpcCallback<CupidTaskServiceProto.GetClusterKvResponse> callback = new RpcCallback<CupidTaskServiceProto.GetClusterKvResponse>(){

            @Override
            public void run(CupidTaskServiceProto.GetClusterKvResponse parameter) {
                response.mergeFrom(parameter);
            }
        };
        stub.getClusterKv(controller, request.build(), callback);
        if (controller.failed()) {
            throw new Exception(controller.errorText());
        }
        return response.getValue();
    }

    public Map<String, String> listByPrefix(CupidSession cupidSession) throws Exception {
        return this.listByPrefix(cupidSession, null);
    }

    public Map<String, String> listByPrefix(CupidSession cupidSession, String prefix) throws Exception {
        CupidTaskServiceRpcController controller = new CupidTaskServiceRpcController();
        CupidTaskServiceRpcChannel channel = new CupidTaskServiceRpcChannel(cupidSession);
        CupidTaskServiceProto.CupidTaskService.Stub stub = CupidTaskServiceProto.CupidTaskService.newStub(channel);
        CupidTaskServiceProto.ListByPrefixClusterKvRequest.Builder request = CupidTaskServiceProto.ListByPrefixClusterKvRequest.newBuilder();
        request.setProjectName(cupidSession.odps().getDefaultProject());
        if (prefix != null) {
            request.setPrefix(prefix);
        }
        final CupidTaskServiceProto.ListByPrefixClusterKvResponse.Builder response = CupidTaskServiceProto.ListByPrefixClusterKvResponse.newBuilder();
        RpcCallback<CupidTaskServiceProto.ListByPrefixClusterKvResponse> callback = new RpcCallback<CupidTaskServiceProto.ListByPrefixClusterKvResponse>(){

            @Override
            public void run(CupidTaskServiceProto.ListByPrefixClusterKvResponse parameter) {
                response.mergeFrom(parameter);
            }
        };
        stub.listByPrefixClusterKv(controller, request.build(), callback);
        if (controller.failed()) {
            throw new Exception(controller.errorText());
        }
        HashMap<String, String> clusterConf = new HashMap<String, String>();
        for (CupidTaskServiceProto.ClusterKv clusterKv : response.getClusterKvList()) {
            clusterConf.put(clusterKv.getKey(), clusterKv.getValue());
        }
        return clusterConf;
    }
}

