/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.output.InstanceRunner;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class WaitCommand
extends AbstractCommand {
    private static final String PMC_TASK_NAME = "console_pmc_task";
    public static final String[] HELP_TAGS = new String[]{"wait", "instance"};
    private static final Pattern PATTERN = Pattern.compile("\\s*WAIT\\s+(.*)", 34);
    private static final Pattern PATTERN_WITHOUT_ID = Pattern.compile("\\s*WAIT\\s*", 34);
    private final String id;
    private final Boolean triggerHooks;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: wait [<instanceID>] [-hooks]");
    }

    private WaitCommand(String id, boolean triggerHooks, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.id = id;
        this.triggerHooks = triggerHooks;
    }

    public static WaitCommand parse(String cmd, ExecutionContext ctx) {
        Matcher m = PATTERN_WITHOUT_ID.matcher(cmd = cmd.trim());
        if (m.matches() && ctx.isInteractiveQuery()) {
            return new WaitCommand(null, false, cmd, ctx);
        }
        m = PATTERN.matcher(cmd);
        if (m.matches()) {
            String argString = m.group(1).trim();
            Options options = WaitCommand.getOptions();
            String[] args = argString.trim().split("\\s+");
            DefaultParser parser = new DefaultParser();
            try {
                CommandLine commandLine = parser.parse(options, args);
                String[] unparsedArgs = commandLine.getArgs();
                if (unparsedArgs.length == 1) {
                    Boolean triggerHooks = commandLine.hasOption("hooks");
                    return new WaitCommand(unparsedArgs[0], triggerHooks, cmd, ctx);
                }
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static Options getOptions() {
        Option hooks = Option.builder().longOpt("hooks").argName("trigger hooks").hasArg(false).desc("trigger hooks when instance is terminated").build();
        Options options = new Options();
        options.addOption(hooks);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        ExecutionContext context = this.getContext();
        if (this.id != null) {
            Instance instance = odps.instances().get(this.id);
            InstanceRunner runner = new InstanceRunner(odps, instance, context);
            runner.waitForCompletion();
            try {
                Iterator queryResult = runner.getResult();
                DefaultOutputWriter writer = context.getOutputWriter();
                if (queryResult == null) return;
                while (queryResult.hasNext()) {
                    writer.writeResult((String)queryResult.next());
                }
                return;
            }
            finally {
                if (instance.getTaskNames().contains(PMC_TASK_NAME)) {
                    QueryUtil.printSubQueryLogview((Odps)odps, (Instance)instance, (String)PMC_TASK_NAME, (ExecutionContext)context);
                }
                if (this.triggerHooks.booleanValue()) {
                    OdpsHooks hooks = new OdpsHooks();
                    hooks.after(instance, odps);
                }
            }
        } else {
            SQLExecutor executor = ExecutionContext.getExecutor();
            if (executor == null) return;
            context.getOutputWriter().writeResult(executor.getLogView());
        }
    }
}

