/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jline.reader.UserInterruptException;

public class StopInstanceCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"kill", "stop", "instance"};
    String instanceId;
    boolean synchronizeFlag;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: kill [instanceID]");
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public StopInstanceCommand(String commandText, ExecutionContext context, String instanceId, boolean synchronizeFlag) {
        super(commandText, context);
        this.instanceId = instanceId;
        this.synchronizeFlag = synchronizeFlag;
    }

    static Options initOptions() {
        Options opts = new Options();
        Option synchronizeFlag = new Option("sync", true, "synchronizeFlag");
        synchronizeFlag.setRequired(false);
        opts.addOption(synchronizeFlag);
        return opts;
    }

    static CommandLine getCommandLine(String[] commandText) throws ODPSConsoleException {
        CommandLine cl;
        Options opts = StopInstanceCommand.initOptions();
        GnuParser clp = new GnuParser();
        try {
            cl = clp.parse(opts, commandText, false);
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Unknown exception from client - " + e.getMessage(), (Throwable)e);
        }
        return cl;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        Instance instance = odps.instances().get(this.instanceId);
        instance.stop();
        if (this.synchronizeFlag) {
            while (!instance.isTerminated()) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    throw new UserInterruptException(e.getMessage());
                }
            }
            this.synchronizeFlag = false;
            this.writeStatus(instance.getStatus().toString());
            return;
        }
        this.writeStatus(null);
    }

    private void writeStatus(String status) {
        this.getWriter().writeError("OK");
        if (status == null) {
            this.getWriter().writeError("please check instance status. [status " + this.instanceId + ";]");
        } else {
            this.getWriter().writeError("instance " + this.instanceId + " has been " + status + " ;");
        }
    }

    public static StopInstanceCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        if (commandString.toUpperCase().startsWith("KILL")) {
            String[] temp = commandString.trim().replaceAll("\\s+", " ").split(" ");
            CommandLine cl = StopInstanceCommand.getCommandLine(temp);
            if (2 == cl.getArgs().length) {
                return new StopInstanceCommand(commandString, sessionContext, temp[1], false);
            }
            if (1 != cl.getArgs().length) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. [invalid parameters]");
            }
            if (cl.hasOption("sync")) {
                return new StopInstanceCommand(commandString, sessionContext, cl.getOptionValue("sync"), true);
            }
        }
        return null;
    }
}

