/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.common.InstanceContext;
import com.aliyun.openservices.odps.console.common.JobDetailInfo;
import com.aliyun.openservices.odps.console.utils.ConnectionCreator;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.lang.WordUtils;

public class StatusOfInstanceCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"status", "instance"};
    private String instanceId;
    private boolean extended;
    private InstanceContext instanceContext;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: status [extended] <instanceID>");
    }

    public StatusOfInstanceCommand(String instanceId, String commandText, ExecutionContext context, boolean extended, InstanceContext instanceContext) {
        super(commandText, context);
        this.instanceId = instanceId;
        this.extended = extended;
        this.instanceContext = instanceContext;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        if (!this.extended) {
            Instance inst = odps.instances().get(this.instanceId);
            String instStatus = inst.getStatus().toString();
            instStatus = WordUtils.capitalizeFully((String)instStatus);
            this.getWriter().writeResult("Instance status = " + instStatus);
            Map taskStatus = inst.getTaskStatus();
            for (Instance.TaskStatus task : taskStatus.values()) {
                String taskName = task.getName();
                String status = task.getStatus().toString();
                status = WordUtils.capitalizeFully((String)status);
                this.getWriter().writeResult("Task = " + taskName + ", status = " + status);
            }
        } else {
            JobDetailInfo jobDetailInfo = new JobDetailInfo(this.instanceContext);
            jobDetailInfo.printJobDetails();
        }
    }

    public static StatusOfInstanceCommand parse(String command, ExecutionContext session) throws ODPSConsoleException, OdpsException {
        if (command.toUpperCase().matches("\\s*STATUS\\s+EXTENDED\\s+.*")) {
            String[] str = (command = command.trim()).split("\\s+");
            if (str.length != 3) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
            }
            InstanceContext instanceContext = new InstanceContext();
            if (instanceContext.getConn() == null) {
                ConnectionCreator tmpCC = new ConnectionCreator();
                instanceContext.setConn(tmpCC.create(session));
            }
            instanceContext.setSession(session);
            instanceContext.setProjectByName(session.getProjectName());
            instanceContext.setInstanceById(str[2]);
            StatusOfInstanceCommand comm = new StatusOfInstanceCommand(str[2], command, session, true, instanceContext);
            return comm;
        }
        if (command.toUpperCase().matches("\\s*STATUS\\s+.*")) {
            String[] str = (command = command.trim()).split("\\s+");
            if (str.length == 3) {
                return null;
            }
            if (str.length != 2) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
            }
            return new StatusOfInstanceCommand(str[1], command, session, false, null);
        }
        return null;
    }
}

