/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Table;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.ExportProjectUtil;
import java.io.PrintStream;

public class ExportTableCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"export", "table"};
    private Coordinate coordinate;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: export table [<project name>.[<schema name>]]<tablename>");
    }

    public ExportTableCommand(Coordinate coordinate, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.coordinate = coordinate;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        this.coordinate.interpretByCtx(this.getContext());
        Table table = this.getCurrentOdps().tables().get(this.coordinate.getProjectName(), this.coordinate.getSchemaName(), this.coordinate.getObjectName());
        this.getWriter().writeResult("DDL:" + ExportProjectUtil.getDdlFromMeta((Odps)this.getCurrentOdps(), (Table)table, (String)"-tp"));
    }

    public static ExportTableCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        String[] temp;
        if (commandString.toUpperCase().matches("\\s*EXPORT\\s+TABLE.*") && (temp = commandString.trim().split("\\s+")).length == 3) {
            Coordinate coordinate = Coordinate.getCoordinateABC((String)temp[2]);
            return new ExportTableCommand(coordinate, commandString, sessionContext);
        }
        return null;
    }
}

