/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.local.common.security;

import com.aliyun.odps.Odps;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.security.ApplicatitionType;
import com.aliyun.odps.local.common.security.DefaultSecurityManager;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.Policy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SecurityClient {
    private static String lineSeperator = System.getProperty("line.separator", "\n");
    private static volatile SecurityClient securityClient;
    private String policyFilePath;
    private boolean isSecurityEnabled;
    private boolean isJNIEnabled;
    private String userDefinePolicy;
    private SecurityManager oldSecurityManager;
    private Policy oldPolicy;
    private ApplicatitionType appType;
    private List<String> appCodeBase;
    private Map<String, String> replacement;
    private static Map<String, Object> visitedPath;
    private static Object obj;

    private SecurityClient() {
    }

    private static synchronized SecurityClient getInstance() {
        if (securityClient == null) {
            securityClient = new SecurityClient();
        }
        return securityClient;
    }

    public static void init(ApplicatitionType appType, List<String> appCodeBase, Map<String, String> replacement, boolean isSecurityEnabled, boolean isJNIEnabled, String userDefinePolicy) {
        SecurityClient.getInstance().appType = appType;
        SecurityClient.getInstance().appCodeBase = appCodeBase;
        SecurityClient.getInstance().isSecurityEnabled = isSecurityEnabled;
        if (!SecurityClient.getInstance().isSecurityEnabled) {
            return;
        }
        SecurityClient.getInstance().isJNIEnabled = isJNIEnabled;
        if (userDefinePolicy == null || userDefinePolicy.length() < "permission".length()) {
            userDefinePolicy = "";
        }
        if (userDefinePolicy.startsWith("\"") && userDefinePolicy.endsWith("\"")) {
            userDefinePolicy = userDefinePolicy.substring(1, userDefinePolicy.length() - 1);
        } else if (userDefinePolicy.startsWith("'") && userDefinePolicy.endsWith("'")) {
            userDefinePolicy = userDefinePolicy.substring(1, userDefinePolicy.length() - 1);
        }
        userDefinePolicy = userDefinePolicy.trim();
        if (!userDefinePolicy.isEmpty() && !userDefinePolicy.endsWith(";")) {
            userDefinePolicy = userDefinePolicy + ";";
        }
        if (SecurityClient.getInstance().isJNIEnabled) {
            userDefinePolicy = userDefinePolicy + "permission java.lang.RuntimePermission \"loadLibrary.*\";";
            try {
                if (WareHouse.getInstance().getOdps() != null && WareHouse.getInstance().getOdps().getDefaultProject() != null) {
                    SecurityClient.addJavaLibPath(WareHouse.getInstance().getResourceDir(WareHouse.getInstance().getOdps().getDefaultProject()).getAbsolutePath());
                }
            }
            catch (IOException e) {
                System.err.println("Add java.library.path failed! " + e.getMessage());
            }
        }
        if (WareHouse.getInstance() != null && WareHouse.getInstance().getWarehouseDir() != null) {
            userDefinePolicy = userDefinePolicy + "permission java.io.FilePermission  \"" + WareHouse.getInstance().getWarehouseDir().getAbsolutePath() + File.separator + "-\" , \"read,write,delete\";";
        }
        if (WareHouse.getInstance() != null && WareHouse.getInstance().getJobDirStr() != null) {
            userDefinePolicy = userDefinePolicy + "permission java.io.FilePermission  \"" + WareHouse.getInstance().getJobDirStr() + File.separator + "-\" , \"read,write,delete\";";
        }
        SecurityClient.getInstance().userDefinePolicy = userDefinePolicy;
        SecurityClient.getInstance().replacement = replacement;
        SecurityClient.copyPolicyFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyPolicyFile() {
        String policyFileName;
        switch (SecurityClient.getInstance().appType) {
            case MR: {
                policyFileName = "mr.policy";
                break;
            }
            case UDF: {
                policyFileName = "udf.policy";
                break;
            }
            default: {
                policyFileName = "mr.policy";
            }
        }
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(SecurityClient.class.getClassLoader().getResourceAsStream(policyFileName)));
            while ((line = br.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append(lineSeperator);
                }
                sb.append(line);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String policyContent = SecurityClient.handlePolicyTemplet(sb.toString());
        String tempPolicyFilePath = null;
        try {
            tempPolicyFilePath = WareHouse.getInstance().getJobDir().getJobDir() + File.separator + "temp." + policyFileName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tempPolicyFilePath == null) {
            tempPolicyFilePath = "temp." + policyFileName;
        }
        try (PrintWriter pw = null;){
            pw = new PrintWriter(tempPolicyFilePath);
            pw.write(policyContent);
            pw.flush();
        }
        SecurityClient.getInstance().policyFilePath = tempPolicyFilePath;
    }

    private static String handlePolicyTemplet(String policyTemplet) {
        if (SecurityClient.getInstance().replacement != null) {
            for (String key : SecurityClient.getInstance().replacement.keySet()) {
                policyTemplet = policyTemplet.replaceAll(key, SecurityClient.getInstance().replacement.get(key));
            }
        }
        policyTemplet = policyTemplet.replace("$USER_DEFINE$", SecurityClient.getInstance().userDefinePolicy);
        visitedPath.clear();
        StringBuffer frameWorkLibGrant = new StringBuffer();
        String frameWorkLibPath = ReflectionUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        frameWorkLibGrant.append(SecurityClient.grantAllPermission(frameWorkLibPath));
        frameWorkLibPath = Odps.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        frameWorkLibGrant.append(lineSeperator);
        frameWorkLibGrant.append(SecurityClient.grantAllPermission(frameWorkLibPath));
        frameWorkLibPath = SecurityClient.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        frameWorkLibGrant.append(lineSeperator);
        frameWorkLibGrant.append(SecurityClient.grantAllPermission(frameWorkLibPath));
        if (SecurityClient.getInstance().appCodeBase != null) {
            Iterator<String> iterator = SecurityClient.getInstance().appCodeBase.iterator();
            while (iterator.hasNext()) {
                String path;
                frameWorkLibPath = path = iterator.next();
                frameWorkLibGrant.append(lineSeperator);
                frameWorkLibGrant.append(SecurityClient.grantAllPermission(frameWorkLibPath));
            }
        }
        policyTemplet = policyTemplet.replace("$FRAMEWORK_GRANT$", frameWorkLibGrant);
        return policyTemplet;
    }

    private static String grantAllPermission(String path) {
        if (visitedPath.containsKey(path)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (path.endsWith(".jar")) {
            sb.append("grant codeBase \"file:");
            sb.append(path + "\"{");
            sb.append(lineSeperator);
            sb.append("permission java.security.AllPermission;");
            sb.append(lineSeperator);
            sb.append("};");
            sb.append(lineSeperator);
            visitedPath.put(path, obj);
            return sb.toString();
        }
        String string = path = path.endsWith(File.separator) ? path : path + File.separator;
        if (visitedPath.containsKey(path)) {
            return sb.toString();
        }
        sb.append("grant codeBase \"file:");
        sb.append(path + "-\"{");
        sb.append(lineSeperator);
        sb.append("permission java.security.AllPermission;");
        sb.append(lineSeperator);
        sb.append("};");
        sb.append(lineSeperator);
        visitedPath.put(path, obj);
        return sb.toString();
    }

    public static boolean isSecurityEnabled() {
        return SecurityClient.getInstance().isSecurityEnabled;
    }

    public static boolean isJNIEnabled() {
        return SecurityClient.getInstance().isJNIEnabled;
    }

    public static void open() {
        if (SecurityClient.getInstance().isSecurityEnabled) {
            SecurityClient.getInstance().oldPolicy = Policy.getPolicy();
            SecurityClient.getInstance().oldSecurityManager = System.getSecurityManager();
            try {
                Class<?> policyFileClass = Class.forName("sun.security.provider.PolicyFile");
                Constructor<?> constructor = policyFileClass.getConstructor(URL.class);
                Policy policy = (Policy)constructor.newInstance(new URL("file:" + SecurityClient.getInstance().policyFilePath));
                Policy.setPolicy(policy);
                Policy.getPolicy().refresh();
                System.setSecurityManager(new DefaultSecurityManager());
            }
            catch (Exception e) {
                System.err.println("Your JVM not support local sandbox figture! " + e.getMessage());
            }
        }
    }

    public static void close() {
        if (SecurityClient.getInstance().isSecurityEnabled) {
            System.setSecurityManager(SecurityClient.getInstance().oldSecurityManager);
            Policy.setPolicy(SecurityClient.getInstance().oldPolicy);
            Policy.getPolicy().refresh();
        }
    }

    private static void addJavaLibPath(String path) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] oldPaths = (String[])field.get(null);
            for (int i = 0; i < oldPaths.length; ++i) {
                if (!path.trim().equals(oldPaths[i])) continue;
                return;
            }
            String[] newPaths = new String[oldPaths.length + 1];
            System.arraycopy(oldPaths, 0, newPaths, 0, oldPaths.length);
            newPaths[oldPaths.length] = path;
            field.set(null, newPaths);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage());
        }
        catch (NoSuchFieldException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void clear() {
        System.clearProperty("odps.local.security.jni.enable");
        System.clearProperty("odps.local.user.define.policy");
        System.clearProperty("odps.local.security.enable");
    }

    public static void setIsSecurityEnabled(boolean flag) {
        System.setProperty("odps.local.security.enable", flag ? "true" : "false");
    }

    public static void setIsJNIEnabled(boolean flag) {
        System.setProperty("odps.local.security.enable", flag ? "true" : "false");
    }

    public static void setUserDefinePolicy(String userDefinePolicy) {
        if (userDefinePolicy != null) {
            System.setProperty("odps.local.user.define.policy", userDefinePolicy);
        } else {
            System.clearProperty("odps.local.user.define.policy");
        }
    }

    static {
        visitedPath = new HashMap<String, Object>();
        obj = new Object();
    }
}

