/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.auth;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.FileUtil;
import java.io.PrintStream;

public class PutPolicyCommand
extends AbstractCommand {
    private String policyPath;
    private String roleName = null;
    public static final String[] HELP_TAGS = new String[]{"put", "policy"};

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: put policy <policyFile>");
        stream.println("       put policy <policyFile> on role <roleName>");
    }

    public String getPolicyPath() {
        return this.policyPath;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public PutPolicyCommand(String policyPath, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.policyPath = policyPath;
    }

    public PutPolicyCommand(String policyPath, String roleName, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.policyPath = policyPath;
        this.roleName = roleName;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        SecurityManager sm = odps.projects().get().getSecurityManager();
        String policy = FileUtil.getStringFromFile((String)this.policyPath);
        if (this.roleName == null) {
            sm.putProjectPolicy(policy);
        } else {
            sm.putRolePolicy(this.roleName, policy);
        }
        this.getWriter().writeError("OK");
    }

    public static PutPolicyCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        if ((commandString = commandString.trim()).toUpperCase().matches("PUT\\s+POLICY\\s+.*")) {
            String[] splits = commandString.split("\\s+");
            if (splits.length == 3) {
                return new PutPolicyCommand(splits[2], commandString, sessionContext);
            }
            if (splits.length == 6 && splits[3].toUpperCase().equals("ON") && splits[4].toUpperCase().equals("ROLE")) {
                return new PutPolicyCommand(splits[2], splits[5], commandString, sessionContext);
            }
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        return null;
    }
}

