/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.auth;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import java.io.PrintStream;

public class GetPolicyCommand
extends AbstractCommand {
    private String roleName = null;
    public static final String[] HELP_TAGS = new String[]{"get", "policy"};

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: get policy");
        stream.println("       get policy on role <roleName>");
    }

    public String getRoleName() {
        return this.roleName;
    }

    public GetPolicyCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public GetPolicyCommand(String roleName, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.roleName = roleName;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        SecurityManager sm = odps.projects().get().getSecurityManager();
        String policy = "";
        policy = this.roleName == null ? sm.getProjectPolicy() : sm.getRolePolicy(this.roleName);
        DefaultOutputWriter outputWriter = this.getContext().getOutputWriter();
        outputWriter.writeResult(policy);
    }

    public static GetPolicyCommand parse(String commandString, ExecutionContext sessionContext) {
        if (commandString.trim().toUpperCase().matches("GET\\s+POLICY.*")) {
            String[] splits = commandString.split("\\s+");
            if (splits.length == 2) {
                return new GetPolicyCommand(commandString, sessionContext);
            }
            if (splits.length == 5 && splits[2].toUpperCase().equals("ON") && splits[3].toUpperCase().equals("ROLE")) {
                return new GetPolicyCommand(splits[4], commandString, sessionContext);
            }
        }
        return null;
    }
}

