/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Resource;
import com.aliyun.odps.Table;
import com.aliyun.odps.conf.Configured;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.data.VolumeInfo;
import com.aliyun.odps.mapred.EventListener;
import com.aliyun.odps.mapred.JobRunner;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.bridge.BridgeRunningJob;
import com.aliyun.odps.mapred.bridge.ErrorCode;
import com.aliyun.odps.mapred.bridge.MetaExplorer;
import com.aliyun.odps.mapred.bridge.MetaExplorerImpl;
import com.aliyun.odps.mapred.bridge.utils.Validator;
import com.aliyun.odps.mapred.bridge.utils.ValidatorFactory;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BridgeJobRunner
extends Configured
implements JobRunner,
EventListener {
    protected static final Log LOG = LogFactory.getLog(BridgeJobRunner.class);
    private static final String TEMP_RESOURCE_PREFIX = "file:";
    protected BridgeJobConf job;
    protected String jobId;
    protected boolean isClean;
    protected String taskName;
    protected Map<String, String> aliasToTempResource = new HashMap<String, String>();
    protected MetaExplorer metaExplorer;

    private ByteArrayOutputStream createJarArchive() throws OdpsException {
        try {
            ByteArrayOutputStream archiveOut = new ByteArrayOutputStream();
            JarOutputStream out = new JarOutputStream((OutputStream)archiveOut, new Manifest());
            ByteArrayOutputStream jobOut = new ByteArrayOutputStream();
            this.job.writeXml(jobOut);
            JarEntry jobconfEntry = new JarEntry("jobconf.xml");
            out.putNextEntry(jobconfEntry);
            out.write(jobOut.toByteArray());
            out.close();
            return archiveOut;
        }
        catch (IOException ex) {
            throw new OdpsException(ErrorCode.UNEXPECTED.toString(), (Throwable)ex);
        }
    }

    private void applyFrameworkResources() throws OdpsException {
        String padding = "-" + this.jobId;
        HashSet<String> added = new HashSet<String>();
        this.applyFrameworkResource(this.findJarFromClass(Odps.class), "odps-sdk-core.jar", padding, added);
        this.applyFrameworkResource(this.findJarFromClass(Mapper.class), "odps-sdk-mapred.jar", padding, added);
        this.applyFrameworkResource(this.findJarFromClass(BridgeJobRunner.class), "odps-mapred-bridge.jar", padding, added);
    }

    private String findJarFromClass(Class<?> clz) throws OdpsException {
        String jarFilePath;
        block4: {
            try {
                URL jarUrl = clz.getProtectionDomain().getCodeSource().getLocation();
                String protocol = jarUrl.getProtocol();
                if (protocol.equals("jar")) {
                    JarURLConnection connection = (JarURLConnection)jarUrl.openConnection();
                    jarFilePath = new File(connection.getJarFileURL().toURI()).getAbsolutePath();
                    break block4;
                }
                if (protocol.equals("file")) {
                    jarFilePath = new File(jarUrl.toURI()).getAbsolutePath();
                    break block4;
                }
                throw new IOException("Unsupported protocol: " + protocol);
            }
            catch (Exception e) {
                throw new OdpsException("Get jar file path failed!", (Throwable)e);
            }
        }
        return jarFilePath;
    }

    private void applyFrameworkResource(String jarFilePath, String alias, String padding, Set<String> added) throws OdpsException {
        if (added.contains(jarFilePath)) {
            return;
        }
        int trycount = 0;
        while (true) {
            try {
                this.aliasToTempResource.put(alias, this.metaExplorer.addFileResourceWithRetry(jarFilePath, Resource.Type.JAR, padding, true));
                added.add(jarFilePath);
                return;
            }
            catch (Exception ex) {
                if (++trycount >= 3) {
                    throw new OdpsException(ex);
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setUp() throws OdpsException {
        if (this.job.get("stream.temp.resource.alias") != null) {
            String aliasJson = this.job.get("stream.temp.resource.alias");
            try {
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                this.aliasToTempResource.putAll((Map)gson.fromJson(aliasJson, new TypeToken<Map<String, String>>(){}.getType()));
            }
            catch (JsonParseException e) {
                throw new OdpsException("parse stream temp resource alias json failed!", (Throwable)e);
            }
        }
        boolean isEstimateReduceNum = this.job.getPartitionerClass() != null && this.job.get("odps.stage.reducer.num") == null;
        long inputSize = 0L;
        TableInfo[] infos = InputUtils.getTables((JobConf)this.job);
        if (infos != null && infos.length > 1) {
            this.job.setMapperInnerOutputEnable(false);
        }
        String project = this.metaExplorer.getDefaultProject();
        boolean changed = false;
        if (infos != null) {
            for (int i = 0; i < infos.length; ++i) {
                Column[] columns;
                VolumeInfo[] info = infos[i];
                if (info.getProjectName() == null) {
                    changed = true;
                    info.setProjectName(project);
                }
                Table tbl = this.metaExplorer.getTable(info.getProjectName(), info.getTableName());
                List schema = tbl.getSchema().getColumns();
                String[] stringArray = this.getInputColumnsFromCommandSettings(this.job, (TableInfo)info);
                if (stringArray.length == 0 && info.getCols() == null) {
                    changed = true;
                    columns = schema.toArray(new Column[schema.size()]);
                    this.job.setInputSchema((TableInfo)info, columns);
                    info.setCols(SchemaUtils.getNames((Column[])columns));
                } else {
                    void var11_23;
                    if (stringArray.length == 0) {
                        String[] stringArray2 = info.getCols();
                    }
                    columns = new Column[((void)var11_23).length];
                    block5: for (int k = 0; k < ((void)var11_23).length; ++k) {
                        void colName = var11_23[k];
                        for (Column c : schema) {
                            if (!c.getName().equalsIgnoreCase((String)colName)) continue;
                            columns[k] = c;
                            continue block5;
                        }
                    }
                    this.job.setInputSchema((TableInfo)info, columns);
                }
                if (!isEstimateReduceNum) continue;
                PartitionSpec part = info.getPartitionSpec();
                if (!part.isEmpty()) {
                    inputSize += tbl.getPartition(part).getSize();
                    continue;
                }
                inputSize += tbl.getSize();
            }
        }
        if (changed) {
            InputUtils.setTables((TableInfo[])infos, (JobConf)this.job);
        }
        if (isEstimateReduceNum) {
            this.job.setNumReduceTasks(this.estimateReduceNum(inputSize, this.job));
        }
        changed = false;
        VolumeInfo[] volumeInfos = InputUtils.getVolumes((JobConf)this.job);
        if (volumeInfos != null) {
            for (VolumeInfo volumeInfo : volumeInfos) {
                if (volumeInfo.getProjectName() != null) continue;
                changed = true;
                volumeInfo.setProjectName(project);
            }
        }
        if (changed) {
            InputUtils.setVolumes((VolumeInfo[])volumeInfos, (JobConf)this.job);
        }
        changed = false;
        volumeInfos = OutputUtils.getVolumes((JobConf)this.job);
        if (volumeInfos != null) {
            for (VolumeInfo volumeInfo : volumeInfos) {
                if (volumeInfo.getProjectName() != null) continue;
                changed = true;
                volumeInfo.setProjectName(project);
            }
        }
        if (changed) {
            OutputUtils.setVolumes((VolumeInfo[])volumeInfos, (JobConf)this.job);
        }
        if ((infos = OutputUtils.getTables((JobConf)this.job)) == null) {
            this.job.setOutputSchema(new Column[]{new Column("nil", OdpsType.STRING)}, "__default__");
        } else {
            for (VolumeInfo volumeInfo : infos) {
                if (volumeInfo.getProjectName() == null) {
                    volumeInfo.setProjectName(project);
                }
                List schema = this.metaExplorer.getTable(volumeInfo.getProjectName(), volumeInfo.getTableName()).getSchema().getColumns();
                Column[] schemaArray = schema.toArray(new Column[schema.size()]);
                volumeInfo.setCols(SchemaUtils.getNames((Column[])schemaArray));
                this.job.setOutputSchema(schemaArray, volumeInfo.getLabel());
            }
            OutputUtils.setTables((TableInfo[])infos, (JobConf)this.job);
        }
        this.processTempResources();
        ByteArrayOutputStream jarOut = null;
        try {
            jarOut = this.createJarArchive();
            jarOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String resName = this.metaExplorer.addTempResourceWithRetry(new ByteArrayInputStream(jarOut.toByteArray()), this.jobId + ".jar", Resource.Type.JAR);
        this.aliasToTempResource.put("jobconf.jar", resName);
        if (this.job.getBoolean("odps.mapred.upload.framework.resources.enable", true)) {
            this.applyFrameworkResources();
        }
        ArrayList<String> totalRes = new ArrayList<String>();
        String[] stringArray = this.job.getResources();
        if (stringArray != null) {
            Collections.addAll(totalRes, stringArray);
        }
        totalRes.addAll(this.aliasToTempResource.keySet());
        this.job.setResources(StringUtils.join(totalRes, (String)","));
        this.job.setFunctionResources(StringUtils.join(this.aliasToTempResource.values(), (String)","));
    }

    private String[] getInputColumnsFromCommandSettings(BridgeJobConf job, TableInfo info) {
        String[] columns = new String[]{};
        String fullTableName = info.getProjectName() + "." + info.getTableName();
        String colsSetting = job.get("odps.mapred.input.columns." + fullTableName);
        if (colsSetting != null) {
            columns = colsSetting.split(",");
        }
        return columns;
    }

    private int estimateReduceNum(long inputSize, BridgeJobConf job) {
        long splitSize = job.getSplitSize() * 1024L * 1024L;
        int numMapTasks = 1;
        numMapTasks = inputSize > 0L ? (int)(inputSize / splitSize) + 1 : job.getNumMapTasks();
        return numMapTasks / 3 + 1;
    }

    private void processTempResources() throws OdpsException {
        String[] res = this.job.getResources();
        if (res == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String r : res) {
            if (r.toLowerCase().startsWith(TEMP_RESOURCE_PREFIX)) {
                URL url;
                Resource.Type type = r.endsWith(".jar") ? Resource.Type.JAR : Resource.Type.FILE;
                try {
                    url = new URL(r);
                }
                catch (MalformedURLException e) {
                    throw new OdpsException((Exception)e);
                }
                this.aliasToTempResource.put(FilenameUtils.getName((String)url.getPath()), this.metaExplorer.addFileResourceWithRetry(url.getPath(), type, "_" + this.jobId, true));
                continue;
            }
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(r);
        }
        this.job.setResources(sb.toString());
    }

    protected void tearDown() throws OdpsException {
        for (String resource : this.aliasToTempResource.values()) {
            this.metaExplorer.deleteResource(resource);
        }
        this.isClean = true;
    }

    protected abstract Instance submitInternal() throws OdpsException;

    public RunningJob submit() throws OdpsException {
        this.job = new BridgeJobConf(this.getConf());
        this.metaExplorer = this.getMetaExplorer();
        this.jobId = System.currentTimeMillis() + RandomStringUtils.randomNumeric((int)8);
        this.taskName = "MRonSQL_" + this.jobId;
        Validator validator = ValidatorFactory.getValidator(this.job, this.metaExplorer);
        validator.validate();
        this.setUp();
        Instance instance = this.submitInternal();
        BridgeRunningJob runningJob = new BridgeRunningJob(instance, this.taskName, this);
        if (SessionState.get().isCostMode()) {
            runningJob.setIsCostMode(true);
        }
        return runningJob;
    }

    protected MetaExplorer getMetaExplorer() {
        return new MetaExplorerImpl(SessionState.get().getOdps());
    }

    public void onComplete() {
        try {
            if (!this.isClean) {
                this.tearDown();
            }
        }
        catch (OdpsException odpsException) {
            // empty catch block
        }
    }
}

