/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.job;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.util.CostResultParser;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.graph.utils.LogUtils;
import com.aliyun.odps.mapred.JobStatus;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.utils.StringUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class NetworkRunningJob
implements RunningJob {
    public static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected Task task;
    protected Instance instance;
    protected JobStatus state = JobStatus.PREP;
    protected Counters counters = new Counters();
    protected boolean stopped = false;
    private long timeMark = 0L;
    private boolean hasPrintSummary = false;
    private boolean hasPrintResult = false;
    protected String diagnostics = "";
    private boolean isCostMode = false;

    public NetworkRunningJob(Task task, Instance instance) {
        this.task = task;
        this.instance = instance;
    }

    public String getInstanceID() {
        return this.instance.getId();
    }

    public boolean isComplete() {
        if (this.isFinished()) {
            return true;
        }
        this.updateStatus();
        return this.isFinished();
    }

    public boolean isSuccessful() {
        if (this.isFinished()) {
            return this.state == JobStatus.SUCCEEDED;
        }
        this.updateStatus();
        return this.state == JobStatus.SUCCEEDED;
    }

    public void waitForCompletion() {
        int sleeptime = 1000;
        while (!this.isComplete()) {
            try {
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            sleeptime = sleeptime + 500 > 4000 ? 4000 : sleeptime + 500;
        }
    }

    public JobStatus getJobStatus() {
        if (this.isFinished()) {
            return this.state;
        }
        this.updateStatus();
        return this.state;
    }

    public void killJob() {
        this.stopped = true;
        try {
            this.instance.stop();
        }
        catch (OdpsException ex) {
            throw new RuntimeException("Kill job Failed", ex);
        }
    }

    public Counters getCounters() {
        return this.counters;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    protected boolean isFinished() {
        return this.state == JobStatus.FAILED || this.state == JobStatus.SUCCEEDED || this.state == JobStatus.KILLED;
    }

    protected void updateStatus() {
        int maxRetryTimes = 3;
        int retry_times = 0;
        while (true) {
            try {
                Instance.Status instanceStatus = this.instance.getStatus();
                if (instanceStatus == Instance.Status.RUNNING || instanceStatus == Instance.Status.SUSPENDED) {
                    this.state = JobStatus.RUNNING;
                } else if (instanceStatus == Instance.Status.TERMINATED) {
                    Instance.TaskStatus taskStatus = (Instance.TaskStatus)this.instance.getTaskStatus().get(this.task.getName());
                    switch (taskStatus.getStatus()) {
                        case WAITING: 
                        case RUNNING: 
                        case FAILED: {
                            this.state = JobStatus.FAILED;
                            break;
                        }
                        case SUCCESS: {
                            this.state = JobStatus.SUCCEEDED;
                            break;
                        }
                        case CANCELLED: {
                            this.state = JobStatus.KILLED;
                            break;
                        }
                        default: {
                            throw new OdpsException("Got Unknown task status: " + taskStatus.getStatus());
                        }
                    }
                } else {
                    throw new OdpsException("Got unknown instance status '" + instanceStatus + "'");
                }
                if (!this.needPrintProcess() && !this.isFinished()) break;
                this.printProgress(instanceStatus);
            }
            catch (Exception ex) {
                if (++retry_times > maxRetryTimes) {
                    throw new RuntimeException(ex);
                }
                System.err.println("Update status failed, retry counter: " + retry_times + ", Exception: " + ex.getMessage());
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        if (this.isFinished()) {
            maxRetryTimes = 3;
            retry_times = 0;
            while (true) {
                try {
                    this.printSummaryAndCollectCounters();
                    this.printResult();
                }
                catch (Exception ex) {
                    if (++retry_times > maxRetryTimes) {
                        throw new RuntimeException(ex);
                    }
                    System.err.println("Get summary or result failed, retry counter: " + retry_times + ", Exception: " + ex.getMessage());
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }

    private boolean needPrintProcess() {
        long interval;
        long now = System.currentTimeMillis();
        if (now - this.timeMark > (interval = 30000L)) {
            this.timeMark = now;
            return true;
        }
        return false;
    }

    private void printProgress(Instance.Status instanceStatus) throws OdpsException {
        try {
            System.out.println(DATEFORMAT.format(new Date()) + " " + instanceStatus.name() + "\t" + LogUtils.assembleProgress(this.instance.getTaskSummary(this.task.getName())));
        }
        catch (Exception e) {
            throw new OdpsException("printProgress enconter error: " + StringUtils.stringifyException((Throwable)e));
        }
    }

    private void printSummaryAndCollectCounters() throws IOException {
        if (!this.hasPrintSummary && this.isSuccessful()) {
            try {
                Instance.TaskSummary taskSummary = this.instance.getTaskSummary(this.task.getName());
                LogUtils.fillCountersAndShowSummary(taskSummary, this.counters);
                this.hasPrintSummary = true;
            }
            catch (Exception ex) {
                throw new IOException("Get summary encounter error: " + ex.getMessage());
            }
        }
    }

    private void printResult() throws IOException {
        if (!this.hasPrintResult) {
            try {
                Map m = this.instance.getTaskResults();
                String result = (String)m.get(this.task.getName());
                if (this.state == JobStatus.SUCCEEDED) {
                    if (!StringUtils.isNullOrEmpty((String)result)) {
                        if (this.isCostMode) {
                            result = CostResultParser.parse((String)result, (String)"Graph");
                        }
                        System.err.println(result);
                    }
                    System.err.println("OK");
                } else {
                    System.err.println("FAILED: " + result);
                }
                this.hasPrintResult = true;
            }
            catch (Exception ex) {
                throw new IOException("Get result encounter error: " + ex.getMessage());
            }
        }
    }

    public float mapProgress() throws IOException {
        return 0.0f;
    }

    public float reduceProgress() throws IOException {
        return 0.0f;
    }

    public boolean isCostMode() {
        return this.isCostMode;
    }

    public void setIsCostMode(boolean isCostMode) {
        this.isCostMode = isCostMode;
    }
}

