/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.aggregators;

import com.aliyun.odps.graph.Aggregator;
import com.aliyun.odps.graph.WorkerContext;
import com.aliyun.odps.graph.aggregators.DoubleAvgValue;
import com.aliyun.odps.io.DoubleWritable;
import java.io.IOException;

public class DoubleAvgAggregator
extends Aggregator<DoubleAvgValue> {
    @Override
    public DoubleAvgValue createInitialValue(WorkerContext context) throws IOException {
        return new DoubleAvgValue();
    }

    @Override
    public void aggregate(DoubleAvgValue value, Object lw) {
        value.sum.set(value.sum.get() + ((DoubleWritable)lw).get());
        value.count.set(value.count.get() + 1L);
    }

    @Override
    public void merge(DoubleAvgValue value, DoubleAvgValue partial) {
        value.sum.set(value.sum.get() + partial.sum.get());
        value.count.set(value.count.get() + partial.count.get());
    }

    @Override
    public boolean terminate(WorkerContext context, DoubleAvgValue value) throws IOException {
        if (value.count.get() > 0L) {
            value.avg.set(value.sum.get() / (double)value.count.get());
        }
        return false;
    }
}

