/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.XFlows;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import com.aliyun.openservices.odps.console.xflow.PAICommand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WaitXFlowCommand
extends AbstractCommand {
    private static final Pattern PATTERN = Pattern.compile("\\s*WAIT\\s+(.*)", 34);
    private final String id;

    private WaitXFlowCommand(String id, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.id = id;
    }

    public static WaitXFlowCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        Matcher m = PATTERN.matcher(cmd);
        if (m.matches()) {
            String id = m.group(1);
            Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)ctx);
            XFlows xFlows = odps.xFlows();
            boolean isXFlowInstance = xFlows.isXFlowInstance(odps.instances().get(id));
            if (isXFlowInstance) {
                return new WaitXFlowCommand(id, cmd, ctx);
            }
            return null;
        }
        return null;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        PAICommand.waitForCompletion(this.getCurrentOdps().instances().get(this.id), this.getCurrentOdps(), this.getContext(), null);
    }
}

