/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Instance;
import com.aliyun.odps.InstanceFilter;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.XFlows;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.utils.GsonObjectBuilder;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.PluginUtil;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import com.aliyun.openservices.odps.console.xflow.AlinkAdapter;
import com.aliyun.openservices.odps.console.xflow.XFlowProgressHelper;
import com.aliyun.openservices.odps.console.xflow.XFlowProgressHelperRegistry;
import com.aliyun.openservices.odps.console.xflow.XFlowStageProgressHelper;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringEscapeUtils;
import org.jline.reader.UserInterruptException;

public class PAICommand
extends AbstractCommand {
    private static final String TEMP_RESOURCE_PREFIX = "file:";
    private static List<String> printResultList = new ArrayList<String>();
    private static List<String> printUrlList = new ArrayList<String>();
    private static List<String> printUrlHosts = new ArrayList<String>();
    private static final int MAX_RETRY_TIMES = 10;
    private static final int RESUBMIT_INTERVAL_MS = 120000;
    public static final String[] HELP_TAGS = new String[]{"pai"};
    public static final Pattern regex;

    private static Options initOptions() {
        Options opts = new Options();
        Option name = new Option("name", true, "model name");
        name.setRequired(true);
        Option project = new Option("project", true, "model project");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"use value for given property");
        Option property = OptionBuilder.create((String)"D");
        Option costFlag = new Option("cost", false, "cost mode");
        Option jobName = new Option("jobname", true, "user customized jobname");
        Option alinkVersion = new Option("alink_version", true, "alink version");
        opts.addOption(name);
        opts.addOption(project);
        opts.addOption(property);
        opts.addOption(costFlag);
        opts.addOption(jobName);
        opts.addOption(alinkVersion);
        return opts;
    }

    public static CommandLine getCommandLine(String commandText) throws ODPSConsoleException {
        CommandLine cl;
        AntlrObject antlr = new AntlrObject(commandText);
        String[] parts = antlr.getTokenStringArray();
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < parts.length; ++i) {
            String curr = parts[i];
            String[] keyValue = curr.split("=", 2);
            if (keyValue.length == 2) {
                String value = keyValue[1];
                if (keyValue[1].isEmpty() && i + 1 < parts.length) {
                    value = parts[++i];
                }
                if (value.length() >= 2 && (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'"))) {
                    value = value.substring(1, value.length() - 1);
                }
                args.add(keyValue[0] + "=" + StringEscapeUtils.unescapeJava((String)value));
                continue;
            }
            args.add(parts[i]);
        }
        if (args.size() < 2) {
            PAICommand.printUsage(System.err);
            throw new ODPSConsoleException("Invalid parameters - Generic options must be specified.");
        }
        Options opts = PAICommand.initOptions();
        GnuParser clp = new GnuParser();
        try {
            cl = clp.parse(opts, args.toArray(new String[0]), false);
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Unknown exception from client - " + e.getMessage(), (Throwable)e);
        }
        if (!cl.hasOption("name")) {
            throw new ODPSConsoleException("Invalid parameters - model name must be specified, using '-t' option.");
        }
        if (cl.getArgList().size() > 1) {
            throw new ODPSConsoleException("Invalid parameters - should use -D options.");
        }
        return cl;
    }

    public static void printUsage(PrintStream stream) {
        stream.println("PAI \u2013name <algo_name> [-cost] [-jobname <jobname>] -project <algo_src_project> -D<key>=<value> \u2026");
    }

    public PAICommand(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        super(commandString, sessionContext);
    }

    public static HashMap<String, String> getUserConfig(CommandLine cl) {
        HashMap<String, String> userConfig = new HashMap<String, String>();
        String jobName = cl.getOptionValue("jobname");
        HashMap<String, String> settings = new HashMap<String, String>(SetCommand.setMap);
        if (jobName != null) {
            settings.put("odps.task.workflow.custom_job_name", jobName);
        }
        if (!settings.isEmpty()) {
            userConfig.put("settings", new GsonBuilder().disableHtmlEscaping().create().toJson(settings));
        }
        return userConfig;
    }

    private XFlows.XFlowInstance CreateXflowInstance(Odps odps, CommandLine cl, StringBuilder urlBuilder) throws OdpsException, ODPSConsoleException {
        String algoName = cl.getOptionValue("name");
        String projectName = cl.getOptionValue("project");
        Properties properties = cl.getOptionProperties("D");
        String runningProject = odps.getDefaultProject();
        PAICommand.replaceProperty(properties, runningProject);
        XFlows.XFlowInstance xFlowInstance = new XFlows.XFlowInstance();
        xFlowInstance.setXflowName(algoName);
        if (projectName == null) {
            xFlowInstance.setProject("algo_public");
        } else {
            xFlowInstance.setProject(projectName);
        }
        String guid = UUID.randomUUID().toString();
        if (printUrlList.contains(algoName.toUpperCase())) {
            String token = properties.getProperty("token");
            String string = properties.getProperty("host");
            String defaultToken = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            defaultToken = defaultToken + "xflowinstance";
            defaultToken = defaultToken + guid.replaceAll("-", "");
            String defaultHost = printUrlHosts.get(printUrlList.indexOf(algoName.toUpperCase()));
            urlBuilder.append("http://");
            if (token == null) {
                urlBuilder.append(defaultToken);
            } else {
                urlBuilder.append(token);
            }
            if (string == null) {
                urlBuilder.append("." + defaultHost);
            } else {
                urlBuilder.append("." + string);
            }
            if (token == null) {
                xFlowInstance.setParameter("token", defaultToken);
            }
            if (string == null) {
                xFlowInstance.setParameter("host", defaultHost);
            }
        }
        for (Map.Entry entry : properties.entrySet()) {
            String value = entry.getValue().toString();
            if (value.toLowerCase().startsWith(TEMP_RESOURCE_PREFIX)) {
                try {
                    value = new URL(URLDecoder.decode(value, "utf-8")).getPath();
                }
                catch (IOException e) {
                    throw new ODPSConsoleException("Invalid temp fileName:" + e.getMessage(), (Throwable)e);
                }
                value = odps.resources().createTempResource(runningProject, value).getName();
            }
            xFlowInstance.setParameter(entry.getKey().toString(), value);
        }
        xFlowInstance.setGuid(guid);
        Integer priority = this.getContext().getPaiPriority();
        xFlowInstance.setPriority(priority.intValue());
        HashMap<String, String> hashMap = PAICommand.getUserConfig(cl);
        for (Map.Entry<String, String> property : hashMap.entrySet()) {
            xFlowInstance.setProperty(property.getKey(), property.getValue());
        }
        return xFlowInstance;
    }

    private void WriteEstimateResult(String estimateResult) {
        DefaultOutputWriter outputWriter = this.getContext().getOutputWriter();
        Map cost = (Map)GsonObjectBuilder.get().fromJson(estimateResult, Map.class);
        Map kvs = (Map)((Map)cost.get("Cost")).get("PAI");
        String outputStr = "";
        for (Map.Entry entry : kvs.entrySet()) {
            if ("Input".equalsIgnoreCase((String)entry.getKey())) {
                if (entry.getValue().toString().isEmpty()) {
                    outputWriter.writeError("Estimate Failed, empty Input returned.");
                    return;
                }
                outputStr = outputStr + String.format("%s:%s Bytes\n", entry.getKey(), entry.getValue());
                continue;
            }
            if (!"WorkerNumber".equalsIgnoreCase((String)entry.getKey())) continue;
            if (entry.getValue().toString().isEmpty()) {
                outputWriter.writeError("Estimate Failed, empty WorkerNumber returned.");
                return;
            }
            outputStr = outputStr + String.format("%s:%s", entry.getKey(), entry.getValue());
        }
        outputWriter.writeResult(outputStr);
    }

    private void runInCostMode(CommandLine cl) throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        StringBuilder urlBuilder = new StringBuilder();
        XFlows.XFlowInstance xFlowInstance = this.CreateXflowInstance(odps, cl, urlBuilder);
        xFlowInstance.setRunningMode("estimate");
        XFlows xFlows = odps.xFlows();
        Instance xInstance = xFlows.execute(xFlowInstance);
        System.err.println("ID = " + xInstance.getId());
        Map results = xInstance.getTaskResults();
        if (!results.containsKey("EstimateResult")) {
            throw new OdpsException("Estimate Failed : This algorithm doesn't support cost estimation.");
        }
        String resultStr = (String)results.get("EstimateResult");
        this.WriteEstimateResult(resultStr);
    }

    private void runNormally(CommandLine cl) throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        StringBuilder urlBuilder = new StringBuilder();
        XFlows.XFlowInstance xFlowInstance = null;
        AlinkAdapter alinkAdapter = new AlinkAdapter(this.getContext(), odps, cl);
        if (alinkAdapter.needTransform()) {
            System.err.println("Begin create alink xflow instance");
            xFlowInstance = alinkAdapter.createAlinkXflowInstance();
        } else {
            xFlowInstance = this.CreateXflowInstance(odps, cl, urlBuilder);
        }
        Instance xInstance = this.runWithRetry(xFlowInstance, odps);
        System.err.println("ID = " + xInstance.getId());
        PAICommand.waitForCompletion(xInstance, odps, this.getContext(), urlBuilder.toString());
    }

    private Instance runWithRetry(XFlows.XFlowInstance xFlowInstance, Odps odps) throws OdpsException {
        try {
            Instance xInstance = odps.xFlows().execute(xFlowInstance);
            return xInstance;
        }
        catch (OdpsException oe) {
            if (!this.needRetry(oe)) {
                throw oe;
            }
            Instance instance = null;
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
                instance = this.SeekInstanceByGuid(odps, xFlowInstance.getGuid());
            }
            catch (InterruptedException ie) {
                throw new UserInterruptException(ie.getMessage());
            }
            catch (Exception e) {
                throw new OdpsException("\u65e0\u6cd5\u83b7\u53d6ID\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002[" + e.getMessage() + "]", (Throwable)e);
            }
            if (instance != null) {
                return instance;
            }
            this.getWriter().writeError("Create PAI instance failed, will retry after " + String.valueOf(120) + "s");
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException ie) {
                throw new UserInterruptException(ie.getMessage());
            }
            return odps.xFlows().execute(xFlowInstance);
        }
    }

    private boolean needRetry(OdpsException e) {
        if (e.getCause() != null && e.getCause() instanceof IOException) {
            return true;
        }
        String[] errorCodes = new String[]{"ODPS-1230153"};
        String errorMsg = e.getMessage();
        for (String ec : errorCodes) {
            if (errorMsg.indexOf(ec) < 0) continue;
            this.getWriter().writeDebug(e.getMessage() + ", reconnecting");
            return true;
        }
        return false;
    }

    private Instance SeekInstanceByGuid(Odps odps, String guid) throws Exception {
        Odps newOdps = odps.clone();
        newOdps.getRestClient().setRetryTimes(0);
        String resource = ResourceBuilder.buildProjectResource((String)newOdps.getDefaultProject());
        Response response = newOdps.getRestClient().request(resource, "GET", null, null, null);
        String date = response.getHeader("Date");
        if (date == null) {
            date = DateUtils.formatRfc822Date((Date)new Date());
        }
        Date sDate = DateUtils.parseRfc822Date((String)date);
        Date fromDate = new Date(sDate.getTime() - 300000L);
        Date toDate = new Date(sDate.getTime() + 10000L);
        InstanceFilter filter = new InstanceFilter();
        filter.setFromTime(fromDate);
        filter.setEndTime(toDate);
        Iterator iterator = newOdps.instances().iterator(filter);
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            try {
                XFlows.XFlowInstance xinstance = newOdps.xFlows().getXFlowInstance(instance);
                if (!guid.equals(xinstance.getGuid())) continue;
                return instance;
            }
            catch (OdpsException e) {
            }
        }
        return null;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        CommandLine cl = PAICommand.getCommandLine(this.getCommandText());
        boolean hasCostOption = cl.hasOption("cost");
        if (hasCostOption) {
            this.runInCostMode(cl);
        } else {
            this.runNormally(cl);
        }
    }

    public static void waitForInstanceTerminate(XFlowProgressHelper progressHelper, Set<String> logviewHasPrintSet, Instance xInstance, Odps odps, ExecutionContext context) throws OdpsException, ODPSConsoleException {
        int retryTimes = 0;
        XFlows xFlows = odps.xFlows();
        int interval = progressHelper.getInterval();
        boolean terminatedFlag = false;
        block8: while (true) {
            try {
                while (true) {
                    for (XFlows.XResult xResult : xFlows.getXResults(xInstance).values()) {
                        if ("SubWorkflow".equalsIgnoreCase(xResult.getNodeType())) {
                            PAICommand.waitForInstanceTerminate(progressHelper, logviewHasPrintSet, odps.instances().get(xResult.getInstanceId()), odps, context);
                            continue;
                        }
                        if ("Local".equalsIgnoreCase(xResult.getNodeType())) continue;
                        Instance i = odps.instances().get(odps.getDefaultProject(), xResult.getInstanceId());
                        String ID = i.getId();
                        if (!logviewHasPrintSet.contains(ID)) {
                            logviewHasPrintSet.add(ID);
                            System.err.println("Sub Instance ID = " + ID);
                            System.err.println(ODPSConsoleUtils.generateLogView((Odps)odps, (Instance)i, (ExecutionContext)context));
                        }
                        for (String task : i.getTaskNames()) {
                            String summary;
                            JsonObject jsonObject;
                            Instance.TaskSummary taskSummary;
                            String instTask = ID + "." + task;
                            if (logviewHasPrintSet.contains(instTask) || (taskSummary = i.getTaskSummary(task)) == null || (jsonObject = (JsonObject)new JsonParser().parse(summary = taskSummary.getJsonSummary())) == null) continue;
                            String sigmaLogView = null;
                            if (jsonObject.has("SigmaJobLogView")) {
                                sigmaLogView = jsonObject.get("SigmaJobLogView").getAsString();
                            }
                            String sigmaJobName = null;
                            if (jsonObject.has("SigmaJobName")) {
                                sigmaJobName = jsonObject.get("SigmaJobName").getAsString();
                            }
                            if (StringUtils.isNullOrEmpty(sigmaJobName)) continue;
                            System.err.println("Sigma Job Name = " + sigmaJobName);
                            if (StringUtils.isNullOrEmpty((String)sigmaLogView)) continue;
                            System.err.println(sigmaLogView);
                            logviewHasPrintSet.add(instTask);
                        }
                        if (!progressHelper.needProgressMessage(i)) continue;
                        System.err.println(progressHelper.getProgressMessage(i));
                    }
                    if (xInstance.isTerminated()) {
                        if (terminatedFlag) break block8;
                        terminatedFlag = true;
                    }
                    Thread.sleep(interval);
                    retryTimes = 0;
                }
            }
            catch (InterruptedException e) {
                throw new UserInterruptException(e.getMessage());
            }
            catch (OdpsException e) {
                ++retryTimes;
                try {
                    Thread.sleep(2 * interval);
                }
                catch (InterruptedException e1) {
                    throw new UserInterruptException(e.getMessage());
                }
                if (retryTimes > 10) {
                    throw e;
                }
                System.err.println(String.format("retry %d times.", retryTimes));
                continue;
            }
            catch (ReloadException e) {
                ++retryTimes;
                try {
                    Thread.sleep(2 * interval);
                }
                catch (InterruptedException e1) {
                    throw new UserInterruptException(e.getMessage());
                }
                if (retryTimes > 10) {
                    throw e;
                }
                System.err.println(String.format("retry %d times.", retryTimes));
                continue;
            }
            break;
        }
    }

    public static void waitForCompletion(Instance xInstance, Odps odps, ExecutionContext context, String url) throws OdpsException, ODPSConsoleException {
        XFlows xFlows = odps.xFlows();
        String algoName = xFlows.getXFlowInstance(xInstance).getXflowName();
        XFlowProgressHelper progressHelper = XFlowProgressHelperRegistry.getProgressHelper(algoName.toUpperCase());
        if (progressHelper == null) {
            progressHelper = new XFlowStageProgressHelper();
        }
        progressHelper.setConfig(url);
        HashSet<String> logviewHasPrintSet = new HashSet<String>();
        try {
            PAICommand.waitForInstanceTerminate(progressHelper, logviewHasPrintSet, xInstance, odps, context);
        }
        catch (UserInterruptException e) {
            context.getOutputWriter().writeError("Instance running background.");
            context.getOutputWriter().writeError("Use 'kill " + xInstance.getId() + "' to stop this instance.");
            context.getOutputWriter().writeError("Use 'wait " + xInstance.getId() + "' to get details of this instance.");
            throw e;
        }
        if (xInstance.isSuccessful()) {
            if (printResultList.contains(algoName.toUpperCase())) {
                for (XFlows.XResult result : xFlows.getXResults(xInstance).values()) {
                    if (StringUtils.isNullOrEmpty((String)result.getResult())) continue;
                    context.getOutputWriter().writeResult(result.getInstanceId() + ":" + result.getResult());
                }
            }
            System.err.println("OK");
            return;
        }
        PAICommand.checkFailedXInstance(odps, xInstance);
    }

    private static void checkFailedXInstance(Odps odps, Instance xInstance) throws OdpsException, ODPSConsoleException {
        System.err.println("Instance " + xInstance.getId() + " Failed.");
        for (XFlows.XResult xResult : odps.xFlows().getXResults(xInstance).values()) {
            Instance i;
            if ("SubWorkflow".equalsIgnoreCase(xResult.getNodeType())) {
                PAICommand.checkFailedXInstance(odps, odps.instances().get(xResult.getInstanceId()));
                continue;
            }
            if ("Local".equalsIgnoreCase(xResult.getNodeType()) || (i = odps.instances().get(xResult.getInstanceId())).isSuccessful()) continue;
            throw new OdpsException("Failed " + i.getId() + ":" + xResult.getResult());
        }
        for (Map.Entry entry : xInstance.getTaskStatus().entrySet()) {
            if (((Instance.TaskStatus)entry.getValue()).getStatus() == Instance.TaskStatus.Status.SUCCESS) continue;
            String result = (String)xInstance.getTaskResults().get(entry.getKey());
            throw new OdpsException("Failed Task " + (String)entry.getKey() + ":" + result);
        }
        throw new OdpsException("Instance " + xInstance.getId() + " Failed");
    }

    private static void replaceProperty(Properties properties, String project) {
        String modelName;
        String outputTableName;
        String inputTableName = properties.getProperty("inputTableName");
        if (!StringUtils.isNullOrEmpty((String)inputTableName) && !inputTableName.contains(".")) {
            inputTableName = project + "." + inputTableName;
            properties.setProperty("inputTableName", inputTableName);
        }
        if (!StringUtils.isNullOrEmpty((String)(outputTableName = properties.getProperty("outputTableName"))) && !outputTableName.contains(".")) {
            outputTableName = project + "." + outputTableName;
            properties.setProperty("outputTableName", outputTableName);
        }
        if (!StringUtils.isNullOrEmpty((String)(modelName = properties.getProperty("modelName"))) && !modelName.contains("/")) {
            modelName = project + "/offlinemodels/" + modelName;
            properties.setProperty("modelName", modelName);
        }
    }

    public static PAICommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        if (regex.matcher(commandString).matches()) {
            return new PAICommand(commandString, sessionContext);
        }
        return null;
    }

    static {
        try {
            Properties properties = PluginUtil.getPluginProperty(PAICommand.class);
            String cmd = properties.getProperty("print_result_list");
            if (!StringUtils.isNullOrEmpty((String)cmd)) {
                printResultList = Arrays.asList(cmd.split(","));
            }
            if (!StringUtils.isNullOrEmpty((String)(cmd = properties.getProperty("poll_url_list")))) {
                printUrlList = Arrays.asList(cmd.split(","));
            }
            if (!StringUtils.isNullOrEmpty((String)(cmd = properties.getProperty("poll_url_hosts")))) {
                printUrlHosts = Arrays.asList(cmd.split(","));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        regex = Pattern.compile("\\s*PAI($|\\s.*)", 34);
    }
}

