/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ml.OnlineModel;
import com.aliyun.odps.ml.OnlineModels;
import com.aliyun.odps.ml.OnlineStatus;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jline.reader.UserInterruptException;

public class DropOnlineModelCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"drop", "delete", "online", "model", "onlinemodel"};
    private String modelName;
    private boolean ifExists;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: drop onlinemodel [if exists] <onlinemodel_name>");
    }

    public DropOnlineModelCommand(String modelName, String commandString, ExecutionContext sessionContext) {
        super(commandString, sessionContext);
        this.modelName = modelName;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        OnlineModels onlinemodels = new OnlineModels(odps.getRestClient());
        if (this.isIfExists() && !onlinemodels.exists(this.modelName)) {
            System.out.println("OK");
            return;
        }
        onlinemodels.delete(this.modelName);
        OnlineModel model = onlinemodels.get(this.modelName);
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (model.getStatus() == OnlineStatus.DELETING) {
            System.err.println(sim.format(new Date()) + "\tDeleting");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new UserInterruptException("interrupted while thread sleep");
            }
            try {
                model.reload();
            }
            catch (NoSuchObjectException e) {
                // empty catch block
                break;
            }
        }
        System.out.println("OK");
    }

    public static DropOnlineModelCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        boolean ifExists = false;
        if (commandString.toUpperCase().matches("\\s*DROP\\s+ONLINEMODEL\\s+.*")) {
            String[] temp;
            String line = commandString.trim().replaceAll("\\s+", " ");
            if ((line = line.substring("DROP ONLINEMODEL ".length()).trim()).toUpperCase().startsWith("IF EXISTS ")) {
                ifExists = true;
                line = line.substring("IF EXISTS ".length()).trim();
            }
            if ((temp = line.split(" ")).length == 1) {
                DropOnlineModelCommand command = new DropOnlineModelCommand(temp[0], commandString, sessionContext);
                command.setIfExists(ifExists);
                return command;
            }
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        return null;
    }

    private boolean isIfExists() {
        return this.ifExists;
    }

    private void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }
}

