/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.upsert;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.ship.history.SessionHistory;
import com.aliyun.odps.ship.history.SessionHistoryManager;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.streams.UpsertStream;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class UpsertRecordWriter
implements RecordWriter {
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private UpsertStream.Listener listener;
    private SessionHistory sessionHistory;
    private UpsertStream stream;

    public UpsertRecordWriter(TableTunnel.UpsertSession upsertSession) throws IOException, TunnelException {
        String sessionId = upsertSession.getId();
        this.sessionHistory = SessionHistoryManager.createSessionHistory(sessionId);
        this.listener = new UpsertStream.Listener(){

            public void onFlush(UpsertStream.FlushResult result) {
            }

            public boolean onFlushFail(String error, int retry) {
                try {
                    UpsertRecordWriter.this.sessionHistory.log(String.format("flush failed %s, retry times: %d", error, retry));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                UpsertRecordWriter.this.print(String.format("flush failed %s, retry times: %d", error, retry));
                return false;
            }
        };
        this.stream = upsertSession.buildUpsertStream().setListener(this.listener).build();
    }

    public void write(Record record) throws IOException {
        try {
            this.stream.upsert(record);
        }
        catch (TunnelException e) {
            this.sessionHistory.log("UpsertStream upsert failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        try {
            this.stream.flush();
            this.stream.close();
        }
        catch (TunnelException e) {
            this.sessionHistory.log("UpsertStream commit failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void print(String msg) {
        Instant instant = Instant.now();
        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
        String processStr = this.dateTimeFormatter.format(zonedDateTime) + "\t";
        System.err.println(processStr + msg);
    }
}

