/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.upsert;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ship.common.BlockInfo;
import com.aliyun.odps.ship.common.Constants;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.common.SessionStatus;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.ship.history.SessionHistory;
import com.aliyun.odps.ship.history.SessionHistoryManager;
import com.aliyun.odps.ship.upload.BlockInfoBuilder;
import com.aliyun.odps.ship.upload.BlockRecordReader;
import com.aliyun.odps.ship.upload.BlockUploader;
import com.aliyun.odps.ship.upload.TunnelUpdateSession;
import com.aliyun.odps.tunnel.TunnelException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jline.reader.UserInterruptException;

public class DshipUpdate {
    protected TunnelUpdateSession tunnelUpdateSession;
    protected String sessionId;
    protected SessionHistory sessionHistory;
    private boolean resume;
    private File uploadFile;
    private long totalUploadBytes;
    protected ArrayList<BlockInfo> blockIndex = new ArrayList();
    private long blockSize = Constants.DEFAULT_BLOCK_SIZE * 1024L * 1024L;
    private long startTime = System.currentTimeMillis();
    private final String[] recordDelimiterArray = new String[]{"\r\n", "\n"};
    private final int checkRDBlockSize = Constants.MAX_RECORD_SIZE / 20;
    protected boolean isCsv = false;

    public DshipUpdate(TunnelUpdateSession tunnelUpdateSession) throws OdpsException, IOException, ParseException {
        this.tunnelUpdateSession = tunnelUpdateSession;
        this.sessionId = tunnelUpdateSession.getSessionId();
        switch (tunnelUpdateSession.getCommandType()) {
            case upsert: {
                this.resume = DshipContext.INSTANCE.get("resume-upsert-id") != null;
                DshipContext.INSTANCE.put("resume-upsert-id", this.sessionId);
                break;
            }
            default: {
                this.resume = DshipContext.INSTANCE.get("resume-upload-id") != null;
                DshipContext.INSTANCE.put("resume-upload-id", this.sessionId);
            }
        }
        this.sessionHistory = SessionHistoryManager.createSessionHistory(this.sessionId);
        this.uploadFile = new File(DshipContext.INSTANCE.get("resume-path"));
        this.totalUploadBytes = 0L;
        if (DshipContext.INSTANCE.get("csv-format").equals("true")) {
            this.isCsv = true;
        }
        if (DshipContext.INSTANCE.get("block-size") != null) {
            this.blockSize = Long.valueOf(DshipContext.INSTANCE.get("block-size")) * 1024L * 1024L;
        }
        this.checkRecordDelimiter();
        this.sessionHistory.saveContext();
        this.buildIndex(this.uploadFile);
    }

    private void checkRecordDelimiter() throws TunnelException, IOException {
        if (DshipContext.INSTANCE.get("record-delimiter") == null) {
            String fileRecordDelimiter = this.getRecordDelimiter(this.uploadFile, this.checkRDBlockSize, this.recordDelimiterArray);
            DshipContext.INSTANCE.put("record-delimiter", fileRecordDelimiter == null ? Constants.DEFAULT_RECORD_DELIMITER : fileRecordDelimiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRecordDelimiter(File file, int checkSize, String[] delimiterArray) throws TunnelException, IOException {
        String recordDelimiter;
        block7: {
            recordDelimiter = null;
            byte[] buf = new byte[checkSize];
            if (file.isDirectory()) {
                boolean hasFile = false;
                File[] fileList = file.listFiles();
                for (File fileName : fileList) {
                    if (!fileName.isFile() || 0L >= FileUtils.sizeOf((File)fileName)) continue;
                    file = fileName;
                    hasFile = true;
                    break;
                }
                if (!hasFile) {
                    return recordDelimiter;
                }
            }
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                int len = is.read(buf, 0, checkSize);
                if (len == -1) break block7;
                for (String delimiter : delimiterArray) {
                    int res = BlockRecordReader.indexOf(buf, 0, len, delimiter.getBytes());
                    if (res == -1) continue;
                    recordDelimiter = delimiter;
                    break;
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return recordDelimiter;
    }

    public void upload() throws TunnelException, IOException, ParseException {
        System.err.println("Start upload:" + this.uploadFile.getPath());
        if (this.isCsv) {
            System.err.println("Using CSV format.");
        }
        System.err.println("Using " + StringEscapeUtils.escapeJava((String)DshipContext.INSTANCE.get("record-delimiter")) + " to split records");
        System.err.println("Upload in strict schema mode: " + DshipContext.INSTANCE.get("strict-schema"));
        if (!this.resume) {
            System.err.println("Total bytes:" + this.totalUploadBytes + "\t Split input to " + this.blockIndex.size() + " blocks");
        } else {
            System.err.println("Resume " + this.blockIndex.size() + " blocks");
        }
        this.sessionHistory.log("start upload:" + this.uploadFile.getPath());
        String scan = DshipContext.INSTANCE.get("scan");
        if (this.isScan(scan)) {
            this.tunnelUpdateSession.setScan(true);
            this.uploadBlock();
        }
        if (this.isUpload(scan)) {
            this.tunnelUpdateSession.setScan(false);
            this.uploadBlock();
            List<BlockInfo> finishBlockList = this.sessionHistory.loadFinishBlockList();
            ArrayList<Long> finishBlockIdList = new ArrayList<Long>();
            for (BlockInfo block : finishBlockList) {
                finishBlockIdList.add(block.getBlockId());
            }
            this.tunnelUpdateSession.complete(finishBlockIdList);
            long gap = (System.currentTimeMillis() - this.startTime) / 1000L;
            if (gap > 0L) {
                long avgSpeed = this.totalUploadBytes / gap;
                System.err.println("upload complete, average speed is " + Util.toReadableBytes(avgSpeed) + "/s");
            }
        }
        this.sessionHistory.log("upload complete:" + this.uploadFile.getPath());
        DshipContext.INSTANCE.put("status", SessionStatus.success.toString());
        this.sessionHistory.saveContext();
        System.err.println("OK");
    }

    public String getTunnelSessionId() {
        return this.tunnelUpdateSession.getSessionId();
    }

    private void uploadBlock() throws IOException, TunnelException {
        int threads = Integer.parseInt(DshipContext.INSTANCE.get("threads"));
        ThreadPoolExecutor executors = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10240));
        ArrayList<Callable<Long>> callList = new ArrayList<Callable<Long>>();
        for (BlockInfo block : this.blockIndex) {
            BlockUploader updater = new BlockUploader(block, this.tunnelUpdateSession, this.sessionHistory, this.isCsv);
            Callable<Long> call = () -> {
                updater.upload();
                return 0L;
            };
            callList.add(call);
        }
        try {
            List futures = executors.invokeAll(callList);
            ArrayList<String> failedBlock = new ArrayList<String>();
            for (int i = 0; i < futures.size(); ++i) {
                try {
                    futures.get(i).get();
                    continue;
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    failedBlock.add(String.valueOf(i));
                }
            }
            if (!failedBlock.isEmpty()) {
                throw new TunnelException("Block ID:" + StringUtils.join(failedBlock, (String)",") + " Failed.");
            }
        }
        catch (InterruptedException e) {
            throw new UserInterruptException(e.getMessage());
        }
        finally {
            executors.shutdownNow();
        }
    }

    private void buildIndex(File file) throws IOException, TunnelException, ParseException {
        if (!this.resume) {
            BlockInfoBuilder blockIndexBuilder = new BlockInfoBuilder();
            blockIndexBuilder.setBlockSize(this.isCsv ? -1L : this.blockSize);
            this.blockIndex = blockIndexBuilder.buildBlockIndex(file);
            this.totalUploadBytes = blockIndexBuilder.getFileSize(file);
            this.sessionHistory.saveBlockIndex(this.blockIndex);
        } else {
            this.blockIndex = this.sessionHistory.loadBlockIndex();
        }
    }

    private boolean isScan(String scan) throws ParseException {
        if ("true".equalsIgnoreCase(scan) || "only".equalsIgnoreCase(scan)) {
            return true;
        }
        if ("false".equalsIgnoreCase(scan)) {
            return false;
        }
        throw new ParseException("Unrecognized command, '-scan='" + scan);
    }

    private boolean isUpload(String scan) throws ParseException {
        if ("true".equalsIgnoreCase(scan) || "false".equalsIgnoreCase(scan)) {
            return true;
        }
        if ("only".equalsIgnoreCase(scan)) {
            return false;
        }
        throw new ParseException("Unrecognized command, '-scan='" + scan);
    }
}

