/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.download;

import com.aliyun.odps.Column;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.common.DshipStopWatch;
import com.aliyun.odps.ship.common.OptionsBuilder;
import com.aliyun.odps.ship.common.RecordConverter;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.ship.download.CsvRecordWriter;
import com.aliyun.odps.ship.download.DshipRecordReader;
import com.aliyun.odps.ship.download.RecordWriter;
import com.aliyun.odps.ship.download.TextRecordWriter;
import com.aliyun.odps.ship.download.TunnelDownloadSession;
import com.aliyun.odps.ship.history.SessionHistory;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class FileDownloader {
    private final String path;
    private final Long start;
    private final Long end;
    private final Long id;
    SessionHistory sh;
    TunnelDownloadSession ds;
    TableSchema schema;
    File file;
    private long writtenBytes = 0L;
    private long currTime;
    private long preTime;
    private DshipStopWatch localIOStopWatch;
    private DshipStopWatch tunnelIOStopWatch;
    private RecordWriter writer;
    SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean isCsv = false;
    private boolean printIOElapsedTime = false;
    private PartitionSpec partitionSpec;
    private boolean withPt = false;

    public FileDownloader(String path, Long id, Long start, Long end, TunnelDownloadSession ds, SessionHistory sh) throws FileNotFoundException, IOException {
        this(path, id, start, end, ds, sh, false, null);
    }

    public FileDownloader(String path, Long id, Long start, Long end, TunnelDownloadSession ds, SessionHistory sh, boolean isCsv, PartitionSpec partitionSpec) throws FileNotFoundException, IOException {
        OptionsBuilder.checkParameters("download");
        this.path = path;
        this.file = new File(path);
        if (!this.file.getAbsoluteFile().getParentFile().exists()) {
            this.file.getAbsoluteFile().getParentFile().mkdirs();
        }
        this.id = id;
        this.start = start;
        this.end = end;
        this.ds = ds;
        this.schema = ds.getSchema();
        this.sh = sh;
        this.isCsv = isCsv;
        this.partitionSpec = partitionSpec;
        this.withPt = Boolean.parseBoolean(DshipContext.INSTANCE.get("with-partition"));
        this.printIOElapsedTime = Boolean.valueOf(DshipContext.INSTANCE.get("time"));
        this.localIOStopWatch = new DshipStopWatch("local I/O", this.printIOElapsedTime);
        this.tunnelIOStopWatch = new DshipStopWatch("tunnel I/O", this.printIOElapsedTime);
        if (sh != null) {
            String msg = String.format("file [%d]: [%s, %s), %s", id, Util.toReadableNumber(start), Util.toReadableNumber(end), path);
            sh.log(msg);
            System.err.println(this.sim.format(new Date()) + "  -  " + msg);
        }
    }

    public void download() throws IOException, TunnelException {
        Record r;
        if (this.sh != null) {
            String msg = String.format("file [" + this.id + "] start", new Object[0]);
            this.sh.log(msg);
            System.err.println(this.sim.format(new Date()) + "  -  " + msg);
        }
        String fd = DshipContext.INSTANCE.get("field-delimiter");
        String rd = DshipContext.INSTANCE.get("record-delimiter");
        String ni = DshipContext.INSTANCE.get("null-indicator");
        String dfp = DshipContext.INSTANCE.get("date-format-pattern");
        String tz = DshipContext.INSTANCE.get("time-zone");
        String charset = DshipContext.INSTANCE.get("charset");
        boolean exponential = false;
        String e = DshipContext.INSTANCE.get("exponential");
        if (e != null && e.equalsIgnoreCase("true")) {
            exponential = true;
        }
        this.writer = this.isCsv ? new CsvRecordWriter(this.file, charset) : new TextRecordWriter(this.file, fd, rd);
        RecordConverter converter = new RecordConverter(this.schema, ni, dfp, tz, charset, exponential, true);
        if ("true".equalsIgnoreCase(DshipContext.INSTANCE.get("header"))) {
            this.writeHeader(this.writer, this.schema);
        }
        this.preTime = System.currentTimeMillis();
        DshipRecordReader recordReader = this.ds.getRecordReader(this.start, this.end);
        long count = 0L;
        while ((r = this.readAndTime(recordReader)) != null) {
            this.writeAndTime(this.writer, converter.format(r));
            ++count;
            this.currTime = System.currentTimeMillis();
            if (this.currTime - this.preTime > 5000L) {
                this.printProgress(count);
                this.preTime = this.currTime;
            }
            ODPSConsoleUtils.checkThreadInterrupted();
        }
        this.writer.close();
        this.writtenBytes = this.writer.getWrittedBytes();
        if (this.sh != null) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(String.format("file [%d] OK. total: %s", this.id, Util.toReadableBytes(this.writtenBytes)));
            messageBuilder.append(this.localIOStopWatch.getFormattedSummary());
            messageBuilder.append(this.tunnelIOStopWatch.getFormattedSummary());
            System.err.println(this.sim.format(new Date()) + "  -  " + messageBuilder.toString());
            this.sh.log(messageBuilder.toString());
        }
    }

    private void printProgress(long count) throws IOException {
        if (this.end - this.start == 0L) {
            return;
        }
        long speed = 0L;
        if (this.writer.getWrittedBytes() - this.writtenBytes > 0L && this.currTime - this.preTime > 0L) {
            speed = (this.writer.getWrittedBytes() - this.writtenBytes) / (this.currTime - this.preTime) * 1000L;
        }
        this.writtenBytes = this.writer.getWrittedBytes();
        long percentage = count * 100L / (this.end - this.start);
        int threads = Integer.parseInt(DshipContext.INSTANCE.get("threads"));
        StringBuilder msgBuilder = new StringBuilder();
        if (threads > 1) {
            long threadId = Thread.currentThread().getId() % (long)threads;
            msgBuilder.append(String.format("Thread %d: ", threadId));
        }
        msgBuilder.append(String.format("[%d] %d%%, %s records downloaded, %s/s, ", this.id, percentage, Util.toReadableNumber(count), Util.toReadableBytes(speed)));
        msgBuilder.append(this.localIOStopWatch.getFormattedSummary());
        msgBuilder.append(this.tunnelIOStopWatch.getFormattedSummary());
        System.err.println(this.sim.format(new Date()) + "  -  " + msgBuilder.toString());
    }

    private void writeHeader(RecordWriter writer, TableSchema schema) throws IOException {
        String charset;
        int i;
        boolean withPt = Boolean.parseBoolean(DshipContext.INSTANCE.get("with-partition"));
        byte[][] headers = new byte[schema.getColumns().size()][];
        if (withPt) {
            headers = new byte[schema.getColumns().size() + schema.getPartitionColumns().size()][];
        }
        for (i = 0; i < schema.getColumns().size(); ++i) {
            charset = DshipContext.INSTANCE.get("charset");
            headers[i] = schema.getColumn(i).getName().getBytes(Util.isIgnoreCharset(charset) ? "utf8" : charset);
        }
        if (withPt) {
            for (i = 0; i < schema.getPartitionColumns().size(); ++i) {
                charset = DshipContext.INSTANCE.get("charset");
                headers[schema.getColumns().size() + i] = schema.getPartitionColumn(i).getName().getBytes(Util.isIgnoreCharset(charset) ? "utf8" : charset);
            }
        }
        this.writeAndTime(writer, headers);
    }

    private Record readAndTime(DshipRecordReader recordReader) throws TunnelException, IOException {
        this.tunnelIOStopWatch.resume();
        try {
            Record record = recordReader.next();
            return record;
        }
        finally {
            this.tunnelIOStopWatch.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndTime(RecordWriter writer, byte[][] record) throws IOException {
        TableSchema schema = this.ds.getSchema();
        ArrayList<byte[]> ptVals = new ArrayList<byte[]>(schema.getPartitionColumns().size());
        if (this.withPt) {
            String charset = DshipContext.INSTANCE.get("charset");
            for (Column c : schema.getPartitionColumns()) {
                if (charset == null || charset.equalsIgnoreCase("ignore")) {
                    ptVals.add(this.partitionSpec.get(c.getName()).getBytes());
                    continue;
                }
                ptVals.add(this.partitionSpec.get(c.getName()).getBytes(charset));
            }
        }
        this.localIOStopWatch.resume();
        try {
            writer.write(record, ptVals);
        }
        finally {
            this.localIOStopWatch.suspend();
        }
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }
}

