/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.common;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.ship.common.CommandType;
import com.aliyun.odps.ship.common.Constants;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.FileUtil;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.UnhandledException;

public class OptionsBuilder {
    private static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\u([0-9a-fA-F]{4})");

    public static void buildUploadOption(String[] args) throws ParseException, IOException, ODPSConsoleException {
        DshipContext.INSTANCE.clear();
        CommandType commond = CommandType.upload;
        GnuParser parser = new GnuParser();
        Options opts = OptionsBuilder.getUploadOptions();
        CommandLine line = parser.parse(opts, args);
        OptionsBuilder.initContext();
        OptionsBuilder.loadConfig();
        OptionsBuilder.processOptions(line);
        OptionsBuilder.processArgs(line.getArgs(), commond);
        OptionsBuilder.checkParameters(commond.name());
        if (!line.hasOption("record-delimiter")) {
            DshipContext.INSTANCE.put("record-delimiter", null);
        }
        OptionsBuilder.setContextValue("command", OptionsBuilder.buildCommand(args));
        OptionsBuilder.setContextValue("command-type", commond.name());
    }

    public static void buildDownloadOption(String[] args) throws ParseException, IOException, ODPSConsoleException, OdpsException {
        DshipContext.INSTANCE.clear();
        CommandType commond = CommandType.download;
        GnuParser parser = new GnuParser();
        Options opts = OptionsBuilder.getDownloadOptions();
        CommandLine line = parser.parse(opts, args);
        OptionsBuilder.initContext();
        OptionsBuilder.loadConfig();
        OptionsBuilder.processOptions(line);
        OptionsBuilder.processArgs(line.getArgs(), commond);
        OptionsBuilder.setContextValue("command", OptionsBuilder.buildCommand(args));
        OptionsBuilder.setContextValue("command-type", commond.name());
        OptionsBuilder.checkParameters(commond.name());
    }

    public static void buildUpsertOption(String[] args) throws ParseException, IOException, ODPSConsoleException, OdpsException {
        DshipContext.INSTANCE.clear();
        CommandType commond = CommandType.upsert;
        GnuParser parser = new GnuParser();
        Options opts = OptionsBuilder.getUpsertOptions();
        CommandLine line = parser.parse(opts, args);
        OptionsBuilder.initContext();
        OptionsBuilder.loadConfig();
        OptionsBuilder.processOptions(line);
        OptionsBuilder.processArgs(line.getArgs(), commond);
        OptionsBuilder.checkParameters(commond.name());
        if (!line.hasOption("record-delimiter")) {
            DshipContext.INSTANCE.put("record-delimiter", null);
        }
        OptionsBuilder.setContextValue("command", OptionsBuilder.buildCommand(args));
        OptionsBuilder.setContextValue("command-type", commond.name());
    }

    private static String buildCommand(String[] args) {
        StringBuilder cl = new StringBuilder();
        for (String a : args) {
            cl.append(a + " ");
        }
        return cl.toString();
    }

    public static void buildResumeOption(String[] args) throws ParseException {
        String[] remains;
        DshipContext.INSTANCE.clear();
        GnuParser parser = new GnuParser();
        Options opts = OptionsBuilder.getResumeOptions();
        CommandLine line = parser.parse(opts, args);
        if (line.hasOption("force")) {
            DshipContext.INSTANCE.put("resume-force", "true");
        }
        if ((remains = line.getArgs()).length == 2) {
            DshipContext.INSTANCE.put("session-id", remains[1]);
        } else if (remains.length > 2) {
            throw new IllegalArgumentException("Unknown command\nType 'tunnel help resume' for usage.");
        }
    }

    public static void buildShowOption(String[] args) throws ParseException {
        DshipContext.INSTANCE.clear();
        GnuParser parser = new GnuParser();
        Options opts = OptionsBuilder.getShowOptions();
        CommandLine line = parser.parse(opts, args);
        String[] remains = line.getArgs();
        if (remains.length == 3) {
            DshipContext.INSTANCE.put("show-command", OptionsBuilder.getShowCmd(remains[1]));
            DshipContext.INSTANCE.put("session-id", remains[2]);
        } else if (remains.length == 2) {
            DshipContext.INSTANCE.put("show-command", OptionsBuilder.getShowCmd(remains[1]));
        } else {
            throw new IllegalArgumentException("Unknown command\nType 'tunnel help show' for usage.");
        }
        DshipContext.INSTANCE.put("number", line.getOptionValue("number"));
        OptionsBuilder.checkShowCommandParameters();
    }

    private static String getShowCmd(String cmd) {
        if (cmd.equals("h")) {
            return "history";
        }
        if (cmd.equals("l")) {
            return "log";
        }
        if (cmd.equals("b")) {
            return "bad";
        }
        return cmd;
    }

    public static void buildPurgeOption(String[] args) throws ParseException {
        DshipContext.INSTANCE.clear();
        GnuParser parser = new GnuParser();
        Options opts = OptionsBuilder.getPurgeOptions();
        CommandLine line = parser.parse(opts, args);
        String[] remains = line.getArgs();
        if (remains.length == 1) {
            DshipContext.INSTANCE.put("purge-number", "3");
        } else if (remains.length == 2) {
            try {
                Integer.valueOf(remains[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal number\nType 'tunnel help purge' for usage.");
            }
            DshipContext.INSTANCE.put("purge-number", remains[1]);
        } else if (remains.length > 2) {
            throw new IllegalArgumentException("Unknown command\nType 'tunnel help purge' for usage.");
        }
    }

    public static void buildHelpOption(String[] args) throws ParseException {
        DshipContext.INSTANCE.clear();
        GnuParser parser = new GnuParser();
        Options opts = OptionsBuilder.getGlobalOptions();
        CommandLine line = parser.parse(opts, args);
        String[] remains = line.getArgs();
        if (remains.length > 2) {
            throw new IllegalArgumentException("Unknown command: too many subcommands.\nType 'tunnel help' for usage.");
        }
        if (remains.length > 1) {
            try {
                CommandType.fromString(remains[1]);
                DshipContext.INSTANCE.put("help-subcommand", remains[1]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown command: " + remains[1] + "\nType 'tunnel help' for usage.");
            }
        }
    }

    private static void checkDelimiters(String type) {
        String rd;
        String fd = DshipContext.INSTANCE.get("field-delimiter");
        if (fd == null || fd.length() == 0) {
            String msg = "Field delimiter is null.";
            if ("download".equals(type)) {
                System.err.println("WARNING: " + msg);
            } else {
                throw new IllegalArgumentException(msg);
            }
        }
        if ((rd = DshipContext.INSTANCE.get("record-delimiter")) == null || rd.length() == 0) {
            String msg = "Record delimiter is null.";
            if ("download".equals(type)) {
                System.err.println("WARNING: " + msg);
            } else {
                throw new IllegalArgumentException(msg);
            }
        }
        if (fd.contains(rd)) {
            throw new IllegalArgumentException("Field delimiter can not include record delimiter.\nType 'tunnel help " + type + "' for usage.");
        }
    }

    public static void checkParameters(String type) {
        String dfp;
        int threads;
        OptionsBuilder.checkDelimiters(type);
        String project = DshipContext.INSTANCE.get("table-project");
        if (project != null && project.trim().isEmpty()) {
            throw new IllegalArgumentException("Project is empty.\nType 'tunnel help " + type + "' for usage.");
        }
        boolean isc = false;
        String c = DshipContext.INSTANCE.get("charset");
        try {
            isc = Charset.isSupported(c);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        boolean bl = isc = isc || "ignore".equals(c);
        if (c == null || c.isEmpty() || !isc) {
            throw new IllegalArgumentException("Unsupported encoding: '" + c + "'\nType 'tunnel help " + type + "' for usage.");
        }
        String sct = DshipContext.INSTANCE.get("session-create-time");
        if (sct == null) {
            throw new IllegalArgumentException("ERROR: create time is null.");
        }
        String cp = DshipContext.INSTANCE.get("compress");
        if (cp == null) {
            throw new IllegalArgumentException("ERROR: compress info is null.");
        }
        try {
            threads = Integer.parseInt(DshipContext.INSTANCE.get("threads"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("threads " + DshipContext.INSTANCE.get("threads") + " Invalid.");
        }
        if (threads <= 0) {
            throw new IllegalArgumentException("threads argument must > 0.");
        }
        if (threads > 1 && "true".equalsIgnoreCase(DshipContext.INSTANCE.get("header"))) {
            throw new IllegalArgumentException("Do not support write header in multi-threads.");
        }
        String table = DshipContext.INSTANCE.get("table");
        if ("download".equals(type)) {
            String exponential;
            if (StringUtils.isNullOrEmpty((String)table) && StringUtils.isNullOrEmpty((String)DshipContext.INSTANCE.get("instance-id"))) {
                throw new IllegalArgumentException("Table or instanceId is null.\nType 'tunnel help " + type + "' for usage.");
            }
            String limit = DshipContext.INSTANCE.get("limit");
            if (limit != null) {
                try {
                    if (Long.valueOf(limit) <= 0L) {
                        throw new IllegalArgumentException("limit argument must > 0.");
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("limit " + limit + " Invalid.");
                }
            }
            if ((exponential = DshipContext.INSTANCE.get("exponential")) != null && !exponential.equalsIgnoreCase("true") && !exponential.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("Invalid parameter :  exponential format in double expected 'true' or 'false', found '" + exponential + "'\nType 'tunnel help " + type + "' for usage.");
            }
            String columnNames = DshipContext.INSTANCE.get("columns-name");
            String columnIndexes = DshipContext.INSTANCE.get("columns-index");
            if (columnNames != null && columnIndexes != null) {
                throw new IllegalArgumentException(String.format("Invalid parameter, these two params cannot be used together: %s and %s ", "columns-index", "columns-name"));
            }
            if (columnIndexes != null) {
                for (String index : columnIndexes.split(",")) {
                    if (org.apache.commons.lang.StringUtils.isNumeric((String)index.trim())) continue;
                    throw new IllegalArgumentException("Invalid parameter, columns indexes expected numeric, found " + columnIndexes);
                }
            }
        }
        if ("upload".equals(type) || "upsert".equals(type)) {
            String path;
            File sFile;
            String mbr;
            String scan;
            if (StringUtils.isNullOrEmpty((String)table)) {
                throw new IllegalArgumentException("Table is null.\nType 'tunnel help " + type + "' for usage.");
            }
            if ("upload".equals(type) && ((scan = DshipContext.INSTANCE.get("scan")) == null || !scan.equals("true") && !scan.equals("false") && !scan.equals("only"))) {
                throw new IllegalArgumentException("-scan, expected:(true|false|only), actual: '" + scan + "'\nType 'tunnel help " + type + "' for usage.");
            }
            String dbr = DshipContext.INSTANCE.get("discard-bad-records");
            if (dbr == null || !dbr.equals("true") && !dbr.equals("false")) {
                throw new IllegalArgumentException("Invalid parameter : discard bad records expected 'true' or 'false', found '" + dbr + "'\nType 'tunnel help " + type + "' for usage.");
            }
            String ss = DshipContext.INSTANCE.get("strict-schema");
            if (ss == null || !ss.equals("true") && !ss.equals("false")) {
                throw new IllegalArgumentException("Invalid parameter : strict schema expected 'true' or 'false', found '" + ss + "'\nType 'tunnel help " + type + "' for usage.");
            }
            String bs = DshipContext.INSTANCE.get("block-size");
            if (bs != null) {
                try {
                    Long.valueOf(bs);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal number 'block-size', please check config file.");
                }
            }
            if ((mbr = DshipContext.INSTANCE.get("max-bad-records")) != null) {
                try {
                    Long.valueOf(mbr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal number 'max-bad-records', please check config file.");
                }
            }
            if (!(sFile = new File(path = DshipContext.INSTANCE.get("resume-path"))).exists()) {
                throw new IllegalArgumentException("Upload File not found: '" + path + "'\nType 'tunnel help " + type + "' for usage.");
            }
        }
        if ((dfp = DshipContext.INSTANCE.get("date-format-pattern")) != null) {
            try {
                DateTimeFormatter.ofPattern(dfp);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported date format pattern '" + dfp + "'");
            }
        }
    }

    private static void checkShowCommandParameters() {
        String cmd = DshipContext.INSTANCE.get("show-command");
        String number = DshipContext.INSTANCE.get("number");
        String sid = DshipContext.INSTANCE.get("session-id");
        if (!(cmd.equals("log") || cmd.equals("bad") || cmd.equals("history"))) {
            throw new IllegalArgumentException("Unknown command\nType 'tunnel help show' for usage.");
        }
        if ((cmd.equals("log") || cmd.equals("bad")) && number != null) {
            throw new IllegalArgumentException("Unknown command\nType 'tunnel help show' for usage.");
        }
        if (cmd.equals("history") && sid != null) {
            throw new IllegalArgumentException("Unknown command\nType 'tunnel help show' for usage.");
        }
        if (number != null) {
            try {
                Integer.valueOf(number);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal number\nType 'tunnel help show' for usage.");
            }
        }
    }

    private static void initContext() {
        OptionsBuilder.setContextValue("charset", "ignore");
        OptionsBuilder.setContextValue("field-delimiter", ",");
        OptionsBuilder.setContextValue("record-delimiter", Constants.DEFAULT_RECORD_DELIMITER);
        OptionsBuilder.setContextValue("discard-bad-records", "false");
        OptionsBuilder.setContextValue("strict-schema", "true");
        OptionsBuilder.setContextValue("null-indicator", "");
        OptionsBuilder.setContextValue("scan", "true");
        OptionsBuilder.setContextValue("header", "false");
        OptionsBuilder.setContextValue("resume-block-id", "1");
        OptionsBuilder.setContextValue("session-create-time", String.valueOf(System.currentTimeMillis()));
        OptionsBuilder.setContextValue("compress", "true");
        OptionsBuilder.setContextValue("threads", String.valueOf(1));
        OptionsBuilder.setContextValue("csv-format", "false");
        OptionsBuilder.setContextValue("time", "false");
        OptionsBuilder.setContextValue("overwrite", "false");
    }

    private static void processOptions(CommandLine line) {
        Option[] ops;
        for (Option op : ops = line.getOptions()) {
            String v = OptionsBuilder.removeQuote(op.getValue());
            if ("field-delimiter".equals(op.getLongOpt()) || "record-delimiter".equals(op.getLongOpt())) {
                OptionsBuilder.setContextValue(op.getLongOpt(), OptionsBuilder.processDelimiter(v));
                continue;
            }
            OptionsBuilder.setContextValue(op.getLongOpt(), v);
        }
    }

    private static String processDelimiter(String delimiter) {
        if (delimiter != null) {
            Matcher matcher = UNICODE_PATTERN.matcher(delimiter = delimiter.replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t"));
            if (matcher.find()) {
                try {
                    delimiter = StringEscapeUtils.unescapeJava((String)delimiter);
                }
                catch (UnhandledException e) {
                    System.err.println("WARNING: can not recognize delimiter " + delimiter);
                }
            }
            return delimiter;
        }
        return null;
    }

    private static String removeQuote(String in) {
        if (in == null || in.length() < 2) {
            return in;
        }
        if (in.startsWith("\"") && in.endsWith("\"") || in.startsWith("'") && in.endsWith("'")) {
            return in.substring(1, in.length() - 1);
        }
        return in;
    }

    private static void processInstanceArgs(String instanceDesc) throws IllegalArgumentException {
        String[] instanceDescSplit = instanceDesc.substring("instance://".length()).split("/");
        if (instanceDescSplit.length == 2) {
            OptionsBuilder.setContextValue("table-project", instanceDescSplit[0]);
            OptionsBuilder.setContextValue("instance-id", instanceDescSplit[1]);
        } else if (instanceDescSplit.length == 1) {
            OptionsBuilder.setContextValue("instance-id", instanceDescSplit[0]);
        } else {
            throw new IllegalArgumentException("Unrecognized command for download instance result\nType 'tunnel help download' for usage.");
        }
    }

    private static void processArgs(String[] remains, CommandType type) throws ODPSConsoleException {
        String path;
        if (remains.length == 3) {
            path = type == CommandType.download ? remains[2] : remains[1];
            String desc = type == CommandType.download ? remains[1] : remains[2];
            String project = null;
            String schema = null;
            String partition = null;
            if (type == CommandType.download && desc.startsWith("instance://")) {
                OptionsBuilder.processInstanceArgs(desc);
            } else {
                String[] descSplit = desc.split("/");
                Coordinate coordinate = Coordinate.getCoordinateABC((String)descSplit[0]);
                coordinate.interpretByCtx(DshipContext.INSTANCE.getExecutionContext());
                project = coordinate.getProjectName();
                schema = coordinate.getSchemaName();
                String table = coordinate.getObjectName();
                if (descSplit.length == 2) {
                    partition = new PartitionSpec(descSplit[1]).toString();
                } else if (descSplit.length > 2) {
                    throw new IllegalArgumentException("Invalid table identifier: " + desc);
                }
                Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)DshipContext.INSTANCE.getExecutionContext());
                odps.setCurrentSchema(schema);
                OptionsBuilder.setContextValue("table-project", project);
                OptionsBuilder.setContextValue("schema", schema);
                if (odps.tables().get(project, schema, table).isVirtualView()) {
                    if (partition != null) {
                        throw new IllegalArgumentException("Invalid view identifier: " + desc);
                    }
                    if (type != CommandType.download) {
                        throw new IllegalArgumentException("Invalid operation: upload to a view");
                    }
                    try {
                        String tableCoordinate = project + "." + schema + "." + table;
                        if (DshipContext.INSTANCE.getExecutionContext().isProjectMode()) {
                            tableCoordinate = project + "." + table;
                        }
                        String query = String.format("SELECT * FROM %s;", tableCoordinate);
                        HashMap<String, String> hints = new HashMap<String, String>();
                        hints.put("odps.default.schema", DshipContext.INSTANCE.get("schema"));
                        hints.put("odps.namespace.schema", String.valueOf(DshipContext.INSTANCE.getExecutionContext().isOdpsNamespaceSchema()));
                        if (SetCommand.setMap.containsKey("odps.sql.allow.namespace.schema")) {
                            hints.put("odps.sql.allow.namespace.schema", String.valueOf(DshipContext.INSTANCE.getExecutionContext().isOdpsNamespaceSchema()));
                        }
                        hints.put("odps.namespace.schema", String.valueOf(DshipContext.INSTANCE.getExecutionContext().isOdpsNamespaceSchema()));
                        Instance instance = SQLTask.run((Odps)odps, (String)odps.getDefaultProject(), (String)query, hints, null);
                        instance.waitForSuccess();
                        OptionsBuilder.processInstanceArgs("instance://" + instance.getId());
                    }
                    catch (OdpsException e) {
                        throw new ODPSConsoleException("Read from view failed", (Throwable)e);
                    }
                } else {
                    OptionsBuilder.setContextValue("table", table);
                    OptionsBuilder.setContextValue("partition-spec", partition);
                }
            }
        } else {
            throw new IllegalArgumentException("Unrecognized command\nType 'tunnel help " + type.name() + "' for usage.");
        }
        OptionsBuilder.setContextValue("resume-path", FileUtil.expandUserHomeInPath((String)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConfig() throws IOException, ODPSConsoleException {
        String cf = DshipContext.INSTANCE.getExecutionContext().getConfigFile();
        if (cf == null) {
            return;
        }
        File file = new File(cf);
        if (!file.exists()) {
            return;
        }
        FileInputStream cfIns = new FileInputStream(file);
        Properties properties = new Properties();
        try {
            properties.load(cfIns);
            for (Object key : properties.keySet()) {
                String k = key.toString();
                String v = (String)properties.get(key);
                OptionsBuilder.setContextValue(k.toLowerCase(), v);
            }
        }
        finally {
            try {
                cfIns.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void setContextValue(String key, String value) {
        if (value != null) {
            if (!(key.equals("field-delimiter") || key.equals("record-delimiter") || key.equals("partition-spec"))) {
                value = value.trim();
            }
            DshipContext.INSTANCE.put(key, value);
        }
    }

    public static Options getGlobalOptions() {
        Options opts = new Options();
        OptionBuilder.withLongOpt((String)"quota_name");
        OptionBuilder.withDescription((String)"quota name");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"qn"));
        OptionBuilder.withLongOpt((String)"tunnel_endpoint");
        OptionBuilder.withDescription((String)"tunnel endpoint");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"te"));
        OptionBuilder.withLongOpt((String)"charset");
        OptionBuilder.withDescription((String)"specify file charset, default ignore. set ignore to download raw data");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"field-delimiter");
        OptionBuilder.withDescription((String)("specify field delimiter, support unicode, eg \\u0001. default " + Util.toHumanReadableString(",")));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"fd"));
        OptionBuilder.withLongOpt((String)"record-delimiter");
        OptionBuilder.withDescription((String)("specify record delimiter, support unicode, eg \\u0001. default " + Util.toHumanReadableString(Constants.DEFAULT_RECORD_DELIMITER)));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"rd"));
        OptionBuilder.withLongOpt((String)"date-format-pattern");
        OptionBuilder.withDescription((String)"specify date format pattern, default yyyy-MM-dd HH:mm:ss");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"dfp"));
        OptionBuilder.withLongOpt((String)"null-indicator");
        OptionBuilder.withDescription((String)("specify null indicator string, default " + Util.toHumanReadableString("")));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"ni"));
        OptionBuilder.withLongOpt((String)"time-zone");
        OptionBuilder.withDescription((String)("time zone, default local timezone: " + Calendar.getInstance().getTimeZone().getID()));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"tz"));
        OptionBuilder.withLongOpt((String)"compress");
        OptionBuilder.withDescription((String)"compress, default true");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"cp"));
        OptionBuilder.withLongOpt((String)"header");
        OptionBuilder.withDescription((String)"if local file should have table header, default false");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"session-dir");
        OptionBuilder.withDescription((String)("set session dir, default " + Constants.DEFAULT_SESSION_DIR));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"sd"));
        OptionBuilder.withLongOpt((String)"csv-format");
        OptionBuilder.withDescription((String)"use csv format (true|false), default false. When uploading in csv format, file splitting not supported.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"cf"));
        OptionBuilder.withLongOpt((String)"time");
        OptionBuilder.withDescription((String)"keep track of upload/download elapsed time or not. Default false");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"time"));
        return opts;
    }

    public static Options getUploadOptions() {
        Options opts = OptionsBuilder.getGlobalOptions();
        OptionBuilder.withLongOpt((String)"discard-bad-records");
        OptionBuilder.withDescription((String)"specify discard bad records action(true|false), default false");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"dbr"));
        OptionBuilder.withLongOpt((String)"scan");
        OptionBuilder.withDescription((String)"specify scan file action(true|false|only), default true");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"block-size");
        OptionBuilder.withDescription((String)("block size in MiB, default " + Constants.DEFAULT_BLOCK_SIZE));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"bs"));
        OptionBuilder.withLongOpt((String)"max-bad-records");
        OptionBuilder.withDescription((String)("max bad records, default " + Constants.DEFAULT_BAD_RECORDS));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"mbr"));
        OptionBuilder.withLongOpt((String)"auto-create-partition");
        OptionBuilder.withDescription((String)"auto create target partition if not exists, default false");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"acp"));
        OptionBuilder.withLongOpt((String)"strict-schema");
        OptionBuilder.withDescription((String)"specify strict schema mode. If false, extra data will be abandoned and insufficient field will be filled with null. Default true");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"ss"));
        OptionBuilder.withLongOpt((String)"threads");
        OptionBuilder.withDescription((String)"number of threads, default 1");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"t"));
        opts.addOption(Option.builder((String)"ow").longOpt("overwrite").hasArg().argName("true | false").desc("overwrite specified table or partition, default: false").build());
        return opts;
    }

    public static Options getDownloadOptions() {
        Options opts = OptionsBuilder.getGlobalOptions();
        OptionBuilder.withLongOpt((String)"limit");
        OptionBuilder.withDescription((String)"specify the number of records to download");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"exponential");
        OptionBuilder.withDescription((String)"When download double values, use exponential express if necessary. Otherwise at most 20 digits will be reserved. Default false");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.withLongOpt((String)"columns-index");
        OptionBuilder.withDescription((String)"specify the columns index(starts from 0) to download, use comma to split each index");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"ci"));
        OptionBuilder.withLongOpt((String)"columns-name");
        OptionBuilder.withDescription((String)"specify the columns name to download, use comma to split each name");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"cn"));
        OptionBuilder.withLongOpt((String)"with-partition");
        OptionBuilder.withDescription((String)"(true|false)download with partition values in result");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"wp"));
        OptionBuilder.withLongOpt((String)"threads");
        OptionBuilder.withDescription((String)"number of threads, default 1");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"t"));
        return opts;
    }

    public static Options getUpsertOptions() {
        Options opts = OptionsBuilder.getGlobalOptions();
        opts.addOption(Option.builder((String)"dbr").longOpt("discard-bad-records").hasArg().argName("ARG").desc("specify discard bad records action(true|false), default false").build());
        opts.addOption(Option.builder((String)"bs").longOpt("block-size").hasArg().argName("ARG").desc("block size in MiB, default " + Constants.DEFAULT_BLOCK_SIZE).build());
        opts.addOption(Option.builder((String)"mbr").longOpt("max-bad-records").hasArg().argName("ARG").desc("max bad records, default " + Constants.DEFAULT_BAD_RECORDS).build());
        opts.addOption(Option.builder((String)"acp").longOpt("auto-create-partition").hasArg().argName("ARG").desc("auto create target partition if not exists, default false").build());
        opts.addOption(Option.builder((String)"ss").longOpt("strict-schema").hasArg().argName("ARG").desc("specify strict schema mode. If false, extra data will be abandoned and insufficient field will be filled with null. Default true").build());
        return opts;
    }

    public static Options getResumeOptions() {
        Options opts = new Options();
        OptionBuilder.withLongOpt((String)"force");
        OptionBuilder.withDescription((String)"force resume");
        opts.addOption(OptionBuilder.create((String)"f"));
        return opts;
    }

    public static Options getShowOptions() {
        Options opts = new Options();
        OptionBuilder.withLongOpt((String)"number");
        OptionBuilder.withDescription((String)"lines");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ARG");
        opts.addOption(OptionBuilder.create((String)"n"));
        return opts;
    }

    public static Options getConfigOptions() {
        return OptionsBuilder.getGlobalOptions();
    }

    public static Options getPurgeOptions() {
        return new Options();
    }
}

