/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BlockInfo {
    private Long blockId;
    private File file;
    private Long startPos;
    private Long length;

    public BlockInfo() {
    }

    public BlockInfo(Long blockId, File file, Long startPos, Long length) {
        this.blockId = blockId;
        this.file = file;
        this.startPos = startPos;
        this.length = length;
    }

    public void parse(String blockInfo) {
        String[] splits = blockInfo.split(":");
        if (splits.length < 4) {
            throw new IllegalArgumentException("BlockInfo's format should be <blockId>:<startPos>:<length>:<filePath>. now is " + blockInfo);
        }
        this.blockId = Long.valueOf(splits[0]);
        this.startPos = Long.valueOf(splits[1]);
        this.length = Long.valueOf(splits[2]);
        this.file = new File(this.getFilePath(blockInfo));
    }

    public Long getBlockId() {
        return this.blockId;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getFileInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public Long getStartPos() {
        return this.startPos;
    }

    public Long getLength() {
        return this.length;
    }

    public String toString() {
        return "" + this.blockId + ":" + this.startPos + ":" + this.length + ":" + this.file.getPath();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BlockInfo blockInfo = (BlockInfo)obj;
        return this.blockId.equals(blockInfo.getBlockId()) && this.file.getPath().equals(blockInfo.getFile().getPath()) && this.startPos.equals(blockInfo.getStartPos()) && this.length.equals(blockInfo.getLength());
    }

    private String getFilePath(String blockInfo) {
        String sep = ":";
        int fromIndex = 0;
        int occurs = 0;
        int index = 0;
        while ((index = blockInfo.indexOf(sep, fromIndex)) != -1 && index != blockInfo.length() - 1) {
            if (++occurs == 3) {
                return blockInfo.substring(index + 1);
            }
            fromIndex = index + 1;
        }
        throw new IllegalArgumentException("BlockInfo's format should be <blockId>:<startPos>:<length>:<filePath>. now is " + blockInfo);
    }
}

