/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres;

import com.alibaba.hologres.IncompatibleResult;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.aliyun.ververica20220718.Client;
import com.aliyun.ververica20220718.models.Deployment;
import com.aliyun.ververica20220718.models.GetJobHeaders;
import com.aliyun.ververica20220718.models.GetJobResponse;
import com.aliyun.ververica20220718.models.Job;
import com.aliyun.ververica20220718.models.ListDeploymentsHeaders;
import com.aliyun.ververica20220718.models.ListDeploymentsRequest;
import com.aliyun.ververica20220718.models.ListDeploymentsResponse;
import com.aliyun.ververica20220718.models.ListJobsHeaders;
import com.aliyun.ververica20220718.models.ListJobsRequest;
import com.aliyun.ververica20220718.models.ListJobsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FindIncompatibleFlinkJobs {
    static List<IncompatibleResult> incompatibleResults = new ArrayList<IncompatibleResult>();
    public static HashMap<String, String> REGION = new HashMap<String, String>(){
        {
            this.put("\u5317\u4eac", "ververica.cn-beijing.aliyuncs.com");
            this.put("\u4e0a\u6d77", "ververica.cn-shanghai.aliyuncs.com");
            this.put("\u676d\u5dde", "ververica.cn-hangzhou.aliyuncs.com");
            this.put("\u6df1\u5733", "ververica.cn-shenzhen.aliyuncs.com");
            this.put("\u5f20\u5bb6\u53e3", "ververica.cn-zhangjiakou.aliyuncs.com");
            this.put("\u9999\u6e2f", "ververica.cn-hongkong.aliyuncs.com");
            this.put("\u65b0\u52a0\u5761", "ververica.ap-southeast-1.aliyuncs.com");
            this.put("\u5fb7\u56fd", "ververica.eu-central-1.aliyuncs.com");
            this.put("\u82f1\u56fd", "ververica.eu-west-1.aliyuncs.com");
            this.put("\u5370\u5ea6\u5c3c\u897f\u4e9a", "ververica.ap-southeast-5.aliyuncs.com");
            this.put("\u9a6c\u6765\u897f\u4e9a", "ververica.ap-southeast-3.aliyuncs.com");
            this.put("\u7f8e\u56fd", "ververica.us-west-1.aliyuncs.com");
            this.put("\u4e0a\u6d77\u91d1\u878d\u4e91", "ververica.cn-shanghai-finance-1.aliyuncs.com");
            this.put("cn-beijing", "ververica.cn-beijing.aliyuncs.com");
            this.put("cn-shanghai", "ververica.cn-shanghai.aliyuncs.com");
            this.put("cn-hangzhou", "ververica.cn-hangzhou.aliyuncs.com");
            this.put("cn-shenzhen", "ververica.cn-shenzhen.aliyuncs.com");
            this.put("cn-zhangjiakou", "ververica.cn-zhangjiakou.aliyuncs.com");
            this.put("cn-hongkong", "ververica.cn-hongkong.aliyuncs.com");
            this.put("ap-northeast-1", "ververica.ap-southeast-1.aliyuncs.com");
            this.put("eu-central-1", "ververica.eu-central-1.aliyuncs.com");
            this.put("eu-west-1", "ververica.eu-west-1.aliyuncs.com");
            this.put("ap-southeast-5", "ververica.ap-southeast-5.aliyuncs.com");
            this.put("ap-southeast-3", "ververica.ap-southeast-3.aliyuncs.com");
            this.put("us-west-1", "ververica.us-west-1.aliyuncs.com");
            this.put("cn-shanghai-finance-1", "ververica.cn-shanghai-finance-1.aliyuncs.com");
        }
    };

    public static void main(String[] args) throws Exception {
        String endpoint = REGION.get(args[0]);
        if (endpoint == null) {
            System.out.println("Invalid region");
            return;
        }
        String[] extractedResults = FindIncompatibleFlinkJobs.extractWorkspaceAndNamespace(args[1]);
        if (extractedResults == null) {
            System.out.println("Invalid url");
            return;
        }
        String workspaceId = extractedResults[0];
        String namespace = extractedResults[1];
        Config config = new Config();
        config.setEndpoint(endpoint);
        config.setAccessKeyId(args[2]);
        config.setAccessKeySecret(args[3]);
        boolean binlog = "binlog".equals(args[4]);
        Client client = new Client(config);
        for (int pageIndex = 1; pageIndex <= 20; ++pageIndex) {
            ListDeploymentsRequest listDeploymentsRequest = new ListDeploymentsRequest();
            listDeploymentsRequest.setPageIndex(pageIndex);
            listDeploymentsRequest.setPageSize(100);
            ListDeploymentsHeaders listDeploymentsHeaders = new ListDeploymentsHeaders();
            listDeploymentsHeaders.setWorkspace(workspaceId);
            ListDeploymentsResponse listDeploymentsResponse = client.listDeploymentsWithOptions(namespace, listDeploymentsRequest, listDeploymentsHeaders, new RuntimeOptions());
            for (Deployment deployment : listDeploymentsResponse.getBody().getData()) {
                String deploymentName = deployment.getName();
                String deploymentVersion = deployment.getEngineVersion();
                if (deployment.getJobSummary().getRunning() != 1) {
                    System.out.println(deploymentName + " not a running job, skip");
                    continue;
                }
                if (!"sqlScript".equalsIgnoreCase(deployment.getArtifact().getKind())) {
                    System.out.println(deploymentName + " not sql job, skip");
                    continue;
                }
                if (deploymentVersion.compareTo("vvr-8.0.5-flink-1.17") >= 0) {
                    System.out.println(deploymentName + " check binlog/rpc: version is " + deploymentVersion + ", skip");
                    continue;
                }
                if (!binlog && deploymentVersion.compareTo("vvr-6.0.7-flink-1.15") >= 0) {
                    System.out.println(deploymentName + " check rpc: version is " + deploymentVersion + ", skip");
                    continue;
                }
                ListJobsRequest listJobsRequest = new ListJobsRequest();
                listJobsRequest.setDeploymentId(deployment.getDeploymentId());
                listJobsRequest.setPageIndex(1);
                listJobsRequest.setPageSize(100);
                ListJobsHeaders listJobsHeaders = new ListJobsHeaders();
                listJobsHeaders.setWorkspace(workspaceId);
                ListJobsResponse listJobsResponse = client.listJobsWithOptions(namespace, listJobsRequest, listJobsHeaders, new RuntimeOptions());
                for (int i = 0; i < listJobsResponse.getBody().getData().size(); ++i) {
                    Job job = listJobsResponse.getBody().getData().get(i);
                    if (!"RUNNING".equalsIgnoreCase(job.getStatus().getCurrentJobStatus())) continue;
                    GetJobHeaders getJobHeaders = new GetJobHeaders();
                    getJobHeaders.setWorkspace(workspaceId);
                    GetJobResponse getJobResponse = client.getJobWithOptions(namespace, job.jobId, getJobHeaders, new RuntimeOptions());
                    String sql = getJobResponse.getBody().getData().getArtifact().getSqlArtifact().sqlScript;
                    if (binlog) {
                        FindIncompatibleFlinkJobs.checkBinlog(sql, deploymentName, deploymentVersion);
                        continue;
                    }
                    FindIncompatibleFlinkJobs.checkRpc(sql, deploymentName, deploymentVersion);
                }
            }
        }
        if (binlog) {
            System.out.println("\n\n--------------------\u4ee5\u4e0b\u662f\u7248\u672c\u8fd8\u5c0f\u4e8e8.0.5\uff0c\u4e5f\u6ca1\u6709\u8bbe\u7f6esdkmode = jdbc\u7684hologres binlog \u6e90\u8868--------------------");
        } else {
            System.out.println("\n\n--------------------\u4ee5\u4e0b\u662f\u7248\u672c\u8fd8\u5c0f\u4e8e6.0.7\uff0c\u4e5f\u6ca1\u6709\u8bbe\u7f6esdkmode = jdbc\u7684hologres rpc \u7ef4\u8868/\u7ed3\u679c\u8868----------------");
        }
        System.out.println("-------------------------------------------------------------------------------------------------------------");
        System.out.println("deploymentName                       version                              tableName");
        for (IncompatibleResult badResult : incompatibleResults) {
            System.out.println(badResult.deploymentName + " " + badResult.deploymentVersion + " " + badResult.tableName);
        }
    }

    public static void checkBinlog(String sql, String deploymentName, String deploymentVersion) {
        if (sql.toLowerCase().contains("binlog")) {
            Set<Map<String, String>> allHologresTables = FindIncompatibleFlinkJobs.extractParameters(sql);
            for (Map<String, String> table : allHologresTables) {
                String tableName = table.get("tablename");
                if (table.get("binlog") == null) {
                    System.out.println(tableName + " in " + deploymentName + " not a hologres binlog table, skip");
                    continue;
                }
                if ("jdbc".equalsIgnoreCase(table.get("sdkmode"))) {
                    System.out.println(tableName + " in " + deploymentName + " is a hologres binlog table and have set sdkMode = jdbc, skip");
                    continue;
                }
                incompatibleResults.add(new IncompatibleResult(deploymentName, deploymentVersion, tableName));
            }
        } else {
            System.out.println(deploymentName + " not a hologres job, skip");
        }
    }

    public static void checkRpc(String sql, String deploymentName, String deploymentVersion) {
        if (sql.toLowerCase().contains("rpc")) {
            Set<Map<String, String>> allHologresTables = FindIncompatibleFlinkJobs.extractParameters(sql);
            for (Map<String, String> table : allHologresTables) {
                String tableName = table.get("tablename");
                if (table.get("userpcmode") == null && !"rpc".equals(table.get("sdkmode"))) {
                    System.out.println(tableName + " in " + deploymentName + " not a hologres rpc table, skip");
                    continue;
                }
                incompatibleResults.add(new IncompatibleResult(deploymentName, deploymentVersion, tableName));
            }
        } else {
            System.out.println(deploymentName + " not a hologres job, skip");
        }
    }

    public static String[] extractWorkspaceAndNamespace(String url) {
        String pattern = ".*/workspaces/([^/]+)/namespaces/([^/]+)/.*";
        Pattern compiledPattern = Pattern.compile(pattern);
        Matcher matcher = compiledPattern.matcher(url);
        if (matcher.find()) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        return null;
    }

    public static Set<Map<String, String>> extractParameters(String input) {
        HashSet<Map<String, String>> allHologresTables = new HashSet<Map<String, String>>();
        String withBlockRegex = "(?i)with\\s*\\((.*?)\\)";
        Pattern withBlockPattern = Pattern.compile(withBlockRegex, 34);
        Matcher withBlockMatcher = withBlockPattern.matcher(input);
        while (withBlockMatcher.find()) {
            String withBlockContent = withBlockMatcher.group(1);
            String kvRegex = "'(.*?)'\\s*=\\s*'([^']*)'";
            Pattern kvPattern = Pattern.compile(kvRegex, 2);
            Matcher kvMatcher = kvPattern.matcher(withBlockContent);
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (kvMatcher.find()) {
                String key = kvMatcher.group(1).toLowerCase();
                String value = kvMatcher.group(2);
                parameters.put(key, value);
            }
            if (!"hologres".equalsIgnoreCase((String)parameters.get("connector"))) continue;
            allHologresTables.add(parameters);
        }
        String optionsBlockRegex = "(?i)OPTIONS\\s*\\((.*?)\\)";
        Pattern optionsBlockPattern = Pattern.compile(optionsBlockRegex, 34);
        Matcher optionsBlockMatcher = optionsBlockPattern.matcher(input);
        while (optionsBlockMatcher.find()) {
            String optionsBlockContent = optionsBlockMatcher.group(1);
            String kvRegex = "'(.*?)'\\s*=\\s*'([^']*)'";
            Pattern kvPattern = Pattern.compile(kvRegex, 2);
            Matcher kvMatcher = kvPattern.matcher(optionsBlockContent);
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (kvMatcher.find()) {
                String key = kvMatcher.group(1).toLowerCase();
                String value = kvMatcher.group(2);
                parameters.put(key, value);
            }
            allHologresTables.add(parameters);
        }
        return allHologresTables;
    }
}

