/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.hive.utils;

import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.hive.conf.HoloClientParam;
import com.alibaba.hologres.org.postgresql.PGProperty;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUtils {
    private static final Logger logger = LoggerFactory.getLogger(JDBCUtils.class);

    public static boolean couldDirectConnect(HoloClientParam param) {
        String url = param.getUrl();
        Properties info = new Properties();
        PGProperty.USER.set(info, param.getUsername());
        PGProperty.PASSWORD.set(info, param.getPassword());
        PGProperty.APPLICATION_NAME.set(info, "hologres-connector-hive_copy");
        String directUrl = JDBCUtils.getJdbcDirectConnectionUrl(param);
        try {
            Connection ignored = DriverManager.getConnection(directUrl, info);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (Exception e) {
            logger.warn("could not connect directly to holo.");
            return false;
        }
        return true;
    }

    public static String getJdbcDirectConnectionUrl(HoloClientParam param) {
        String endpoint = null;
        String url = JDBCUtils.getJdbcUrlWithRandomFrontendId(param);
        logger.info("try connect directly to holo with url {}", (Object)url);
        try (Connection conn = JDBCUtils.createConnection(param);
             Statement stat = conn.createStatement();
             ResultSet rs = stat.executeQuery("select inet_server_addr(), inet_server_port()");){
            if (rs.next()) {
                endpoint = rs.getString(1) + ":" + rs.getString(2);
            }
            if (Objects.isNull(endpoint)) {
                throw new RuntimeException("Failed to query \"select inet_server_addr(), inet_server_port()\".");
            }
        }
        catch (SQLException t) {
            throw new RuntimeException(t);
        }
        return JDBCUtils.replaceJdbcUrlEndpoint(param.getUrl(), endpoint);
    }

    public static String formatUrlWithHologres(String oldUrl) {
        String url = oldUrl;
        if (oldUrl != null && oldUrl.startsWith("jdbc:postgresql:")) {
            url = "jdbc:hologres:" + oldUrl.substring("jdbc:postgresql:".length());
        }
        return url;
    }

    private static String getJdbcUrlWithRandomFrontendId(HoloClientParam param) {
        String url = param.getUrl();
        if (param.getHologresFrontendsNumber() > 0) {
            url = url + (url.contains("?") ? "&" : "?") + "options=fe=" + (Math.abs(new Random().nextInt()) % param.getHologresFrontendsNumber() + 1);
        }
        return url;
    }

    private static String replaceJdbcUrlEndpoint(String originalUrl, String newEndpoint) {
        String replacement = "//" + newEndpoint + "/";
        return originalUrl.replaceFirst("//\\S+/", replacement);
    }

    public static int getConnectionsNumberOfThisJob(HoloClientParam param, String appName) {
        int number = -1;
        try (Connection conn = JDBCUtils.createConnection(param);
             Statement stat = conn.createStatement();){
            String sql = String.format("select count(*) from pg_stat_activity where application_name='%s';", appName);
            try (ResultSet rs = stat.executeQuery(sql);){
                if (rs.next()) {
                    number = rs.getInt(1);
                }
                if (number == -1) {
                    throw new RuntimeException("Failed to query " + sql);
                }
            }
        }
        catch (SQLException t) {
            throw new RuntimeException(t);
        }
        return number;
    }

    public static Connection createConnection(HoloClientParam param) {
        try {
            Class.forName("com.alibaba.hologres.org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            return DriverManager.getConnection(param.getUrl(), param.getUsername(), param.getPassword());
        }
        catch (SQLException e) {
            JDBCUtils.logErrorAndExceptionInConsole(String.format("Failed getting connection to %s because:", param.getUrl()), e);
            throw new RuntimeException(String.format("Failed getting connection to %s because %s", param.getUrl(), ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFrontendsNumber(Connection conn) {
        try (Statement statement = conn.createStatement();){
            int maxConnections = 128;
            try (ResultSet rs = statement.executeQuery("show max_connections;");){
                if (rs.next()) {
                    maxConnections = rs.getInt(1);
                }
            }
            int instanceMaxConnections = 0;
            try (ResultSet rs = statement.executeQuery("select instance_max_connections();");){
                if (rs.next()) {
                    instanceMaxConnections = rs.getInt(1);
                }
            }
            int n = instanceMaxConnections / maxConnections;
            return n;
        }
        catch (SQLException e) {
            if (e.getMessage().contains("function instance_max_connections() does not exist")) {
                logger.warn("Failed to get hologres frontends number.", e);
                return 0;
            }
            JDBCUtils.logErrorAndExceptionInConsole("Failed to get hologres frontends number.", e);
            throw new RuntimeException("Failed to get hologres frontends number.", e);
        }
    }

    public static String getSimpleSelectFromStatement(String table, Column[] selectFields) {
        String selectExpressions = Arrays.stream(selectFields).map(a -> JDBCUtils.quoteIdentifier(a.getName())).collect(Collectors.joining(", "));
        return "SELECT " + selectExpressions + " FROM " + table;
    }

    public static String quoteIdentifier(String identifier) {
        return "\"" + identifier + "\"";
    }

    public static void logErrorAndExceptionInConsole(String error, Exception e) {
        System.out.println(LocalDateTime.now() + " [ERROR] " + error);
        e.printStackTrace(System.out);
    }
}

