/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.hive.output;

import com.alibaba.hologres.client.impl.util.ConnectionUtil;
import com.alibaba.hologres.client.model.HoloVersion;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.hive.HoloClientProvider;
import com.alibaba.hologres.hive.conf.HoloClientParam;
import com.alibaba.hologres.hive.output.HoloRecordCopyWriter;
import com.alibaba.hologres.hive.output.HoloRecordWriter;
import com.alibaba.hologres.hive.utils.JDBCUtils;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoloOutputFormat
implements OutputFormat<NullWritable, MapWritable>,
HiveOutputFormat<NullWritable, MapWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoloOutputFormat.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Path path, Class<? extends Writable> aClass, boolean b, Properties properties, Progressable progressable) throws IOException {
        TaskAttemptContext taskAttemptContext = ShimLoader.getHadoopShims().newTaskAttemptContext((Configuration)jobConf, null);
        HoloClientParam param = new HoloClientParam((Configuration)jobConf);
        HoloClientProvider clientProvider = new HoloClientProvider(param);
        try {
            boolean supportBulkLoad;
            HoloVersion holoVersion;
            TableSchema schema = clientProvider.getTableSchema();
            try {
                holoVersion = clientProvider.createOrGetClient().sql(ConnectionUtil::getHoloVersion).get();
            }
            catch (Exception e) {
                JDBCUtils.logErrorAndExceptionInConsole("Failed to get holo version", e);
                throw new IOException("Failed to get holo version", e);
            }
            boolean supportCopy = holoVersion.compareTo(new HoloVersion(1, 3, 24)) > 0;
            boolean bl = supportBulkLoad = holoVersion.compareTo(new HoloVersion(2, 1, 0)) > 0 && schema.getPrimaryKeys().length == 0;
            if (!supportCopy) {
                LOGGER.warn("The hologres instance version is {}, but only instances greater than 1.3.24 support copy write mode", (Object)holoVersion);
            }
            if (param.isCopyWriteMode() && supportCopy) {
                try {
                    param.setHologresFrontendsNumber(clientProvider.createOrGetClient().sql(JDBCUtils::getFrontendsNumber).get());
                }
                catch (Exception e) {
                    JDBCUtils.logErrorAndExceptionInConsole("Failed to get frontend number", e);
                    throw new IOException("Failed to get frontend number", e);
                }
                if (param.isDirectConnect()) {
                    param.setDirectConnect(JDBCUtils.couldDirectConnect(param));
                }
                if (supportBulkLoad) {
                    param.setBulkLoad(true);
                }
                HoloRecordCopyWriter holoRecordCopyWriter = new HoloRecordCopyWriter(param, schema, taskAttemptContext);
                return holoRecordCopyWriter;
            }
            HoloRecordWriter holoRecordWriter = new HoloRecordWriter(param, taskAttemptContext);
            return holoRecordWriter;
        }
        finally {
            clientProvider.closeClient();
        }
    }

    public RecordWriter<NullWritable, MapWritable> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String s2, Progressable progressable) throws IOException {
        throw new UnsupportedOperationException("Write operations are not allowed.");
    }

    public void checkOutputSpecs(FileSystem fileSystem, JobConf jobConf) throws IOException {
    }
}

