/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.hive.input;

import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.hive.conf.HoloClientParam;
import com.alibaba.hologres.hive.input.HoloInputSplit;
import com.alibaba.hologres.hive.utils.JDBCUtils;
import com.alibaba.hologres.org.postgresql.jdbc.PgConnection;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoloRecordReader
implements RecordReader<LongWritable, MapWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoloRecordReader.class);
    TableSchema schema;
    private transient PgConnection conn;
    private transient PreparedStatement statement;
    private transient ResultSet resultSet;
    private int pos = 0;
    private HoloInputSplit inputSplit;

    public HoloRecordReader(TaskAttemptContext context, HoloInputSplit inputSplit) throws IOException {
        this.inputSplit = inputSplit;
        this.schema = inputSplit.getSchema();
        Configuration conf = context.getConfiguration();
        try {
            HoloClientParam param = new HoloClientParam(conf);
            String queryTemplate = JDBCUtils.getSimpleSelectFromStatement(this.schema.getTableName(), this.schema.getColumnSchema());
            String query = String.format("%s WHERE hg_shard_id >= %s and hg_shard_id < %s", queryTemplate, inputSplit.getStartShard(), inputSplit.getEndShard());
            String filterStr = conf.get("hive.io.filter.text");
            if (filterStr != null && !filterStr.isEmpty()) {
                query = query + " and " + filterStr;
            }
            LOGGER.info("the bulk read query: {}", (Object)query);
            this.conn = JDBCUtils.createConnection(param).unwrap(PgConnection.class);
            this.conn.setAutoCommit(false);
            this.statement = this.conn.prepareStatement(query, 1003, 1007);
            this.statement.setFetchSize(param.getScanFetchSize());
            this.statement.setQueryTimeout(param.getScanTimeoutSeconds());
            this.resultSet = this.statement.executeQuery();
        }
        catch (SQLException e) {
            this.close();
            JDBCUtils.logErrorAndExceptionInConsole("Error while create record reader.", e);
            throw new IOException(e);
        }
    }

    public boolean next(LongWritable key, MapWritable value) throws IOException {
        try {
            if (this.resultSet.next()) {
                Column[] keys = this.schema.getColumnSchema();
                for (int i = 0; i < keys.length; ++i) {
                    value.put((Writable)new Text(keys[i].getName()), this.processValue(this.resultSet.getObject(i + 1)));
                }
                LOGGER.info("HoloRecordReader has more records to read.");
                key.set((long)this.pos);
                ++this.pos;
                return true;
            }
            LOGGER.info("HoloRecordReader has no more records to read.");
            return false;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while reading the next record from Hologres.", e);
            return false;
        }
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public MapWritable createValue() {
        return new MapWritable();
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    private Writable processValue(Object value) {
        if (value == null) {
            return NullWritable.get();
        }
        return new Text(value.toString());
    }

    public void close() throws IOException {
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (SQLException e) {
                JDBCUtils.logErrorAndExceptionInConsole("Error while close record reader.", e);
                throw new RuntimeException(e);
            }
        }
    }

    public float getProgress() throws IOException {
        if (this.inputSplit == null) {
            return 0.0f;
        }
        return this.inputSplit.getLength() > 0L ? (float)this.pos / (float)this.inputSplit.getLength() : 1.0f;
    }
}

