/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.com.google.common.graph;

import com.alibaba.hologres.com.google.common.annotations.Beta;
import com.alibaba.hologres.com.google.common.base.Objects;
import com.alibaba.hologres.com.google.common.base.Preconditions;
import com.alibaba.hologres.com.google.common.collect.Iterators;
import com.alibaba.hologres.com.google.common.collect.UnmodifiableIterator;
import com.alibaba.hologres.com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.alibaba.hologres.com.google.common.graph.Graph;
import com.alibaba.hologres.com.google.common.graph.Network;
import com.alibaba.hologres.com.google.errorprone.annotations.Immutable;
import javax.annotation.CheckForNull;

@Immutable(containerOf={"N"})
@ElementTypesAreNonnullByDefault
@Beta
public abstract class EndpointPair<N>
implements Iterable<N> {
    private final N nodeU;
    private final N nodeV;

    private EndpointPair(N nodeU, N nodeV) {
        this.nodeU = Preconditions.checkNotNull(nodeU);
        this.nodeV = Preconditions.checkNotNull(nodeV);
    }

    public static <N> EndpointPair<N> ordered(N source, N target) {
        return new Ordered(source, target);
    }

    public static <N> EndpointPair<N> unordered(N nodeU, N nodeV) {
        return new Unordered(nodeV, nodeU);
    }

    static <N> EndpointPair<N> of(Graph<?> graph, N nodeU, N nodeV) {
        return graph.isDirected() ? EndpointPair.ordered(nodeU, nodeV) : EndpointPair.unordered(nodeU, nodeV);
    }

    static <N> EndpointPair<N> of(Network<?, ?> network, N nodeU, N nodeV) {
        return network.isDirected() ? EndpointPair.ordered(nodeU, nodeV) : EndpointPair.unordered(nodeU, nodeV);
    }

    public abstract N source();

    public abstract N target();

    public final N nodeU() {
        return this.nodeU;
    }

    public final N nodeV() {
        return this.nodeV;
    }

    public final N adjacentNode(N node) {
        if (node.equals(this.nodeU)) {
            return this.nodeV;
        }
        if (node.equals(this.nodeV)) {
            return this.nodeU;
        }
        String string = String.valueOf(this);
        String string2 = String.valueOf(node);
        throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length()).append("EndpointPair ").append(string).append(" does not contain node ").append(string2).toString());
    }

    public abstract boolean isOrdered();

    @Override
    public final UnmodifiableIterator<N> iterator() {
        return Iterators.forArray(this.nodeU, this.nodeV);
    }

    public abstract boolean equals(@CheckForNull Object var1);

    public abstract int hashCode();

    private static final class Unordered<N>
    extends EndpointPair<N> {
        private Unordered(N nodeU, N nodeV) {
            super(nodeU, nodeV);
        }

        @Override
        public N source() {
            throw new UnsupportedOperationException("Cannot call source()/target() on a EndpointPair from an undirected graph. Consider calling adjacentNode(node) if you already have a node, or nodeU()/nodeV() if you don't.");
        }

        @Override
        public N target() {
            throw new UnsupportedOperationException("Cannot call source()/target() on a EndpointPair from an undirected graph. Consider calling adjacentNode(node) if you already have a node, or nodeU()/nodeV() if you don't.");
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        public boolean equals(@CheckForNull Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EndpointPair)) {
                return false;
            }
            EndpointPair other = (EndpointPair)obj;
            if (this.isOrdered() != other.isOrdered()) {
                return false;
            }
            if (this.nodeU().equals(other.nodeU())) {
                return this.nodeV().equals(other.nodeV());
            }
            return this.nodeU().equals(other.nodeV()) && this.nodeV().equals(other.nodeU());
        }

        @Override
        public int hashCode() {
            return this.nodeU().hashCode() + this.nodeV().hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.nodeU());
            String string2 = String.valueOf(this.nodeV());
            return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append("[").append(string).append(", ").append(string2).append("]").toString();
        }
    }

    private static final class Ordered<N>
    extends EndpointPair<N> {
        private Ordered(N source, N target) {
            super(source, target);
        }

        @Override
        public N source() {
            return this.nodeU();
        }

        @Override
        public N target() {
            return this.nodeV();
        }

        @Override
        public boolean isOrdered() {
            return true;
        }

        @Override
        public boolean equals(@CheckForNull Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EndpointPair)) {
                return false;
            }
            EndpointPair other = (EndpointPair)obj;
            if (this.isOrdered() != other.isOrdered()) {
                return false;
            }
            return this.source().equals(other.source()) && this.target().equals(other.target());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.source(), this.target());
        }

        public String toString() {
            String string = String.valueOf(this.source());
            String string2 = String.valueOf(this.target());
            return new StringBuilder(6 + String.valueOf(string).length() + String.valueOf(string2).length()).append("<").append(string).append(" -> ").append(string2).append(">").toString();
        }
    }
}

