/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.utils;

import com.alibaba.hologres.client.exception.ExceptionCode;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;

public class RecordChecker {
    public static void check(Record record) throws HoloClientException {
        TableSchema schema = record.getSchema();
        for (int i = 0; i < schema.getColumnSchema().length; ++i) {
            RecordChecker.checkObject(schema, schema.getColumn(i), record.getObject(i));
        }
    }

    private static void throwConstraintViolationException(TableSchema schema, Column column, Object value, String msg, Exception e) throws HoloClientException {
        StringBuilder sb = new StringBuilder();
        sb.append("invalid value [").append(value).append("]");
        if (value != null) {
            sb.append("(").append(value.getClass().getName()).append(")");
        }
        sb.append(" for column ").append(column.getName()).append(" of table ").append(schema.getTableName());
        if (msg != null) {
            sb.append(", reason=").append(msg);
        }
        HoloClientException ret = null;
        ret = e != null ? new HoloClientException(ExceptionCode.CONSTRAINT_VIOLATION, sb.toString(), e) : new HoloClientException(ExceptionCode.CONSTRAINT_VIOLATION, sb.toString());
        throw ret;
    }

    private static void checkObject(TableSchema schema, Column column, Object value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
        } else if (value instanceof Short) {
            RecordChecker.checkShort(schema, column, (Short)value);
        } else if (value instanceof Integer) {
            RecordChecker.checkInteger(schema, column, (Integer)value);
        } else if (value instanceof Long) {
            RecordChecker.checkLong(schema, column, (Long)value);
        } else if (value instanceof BigDecimal) {
            RecordChecker.checkBigDecimal(schema, column, (BigDecimal)value);
        } else if (value instanceof Float) {
            RecordChecker.checkFloat(schema, column, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            RecordChecker.checkDouble(schema, column, (Double)value);
        } else if (value instanceof Boolean) {
            RecordChecker.checkBoolean(schema, column, (Boolean)value);
        } else if (value instanceof Timestamp) {
            RecordChecker.checkTimeStamp(schema, column, (Timestamp)value);
        } else if (value instanceof Date) {
            RecordChecker.checkDate(schema, column, (Date)value);
        } else if (value instanceof String[]) {
            RecordChecker.checkStringArray(schema, column, (String[])value);
        } else if (value instanceof int[]) {
            RecordChecker.checkIntegerArray(schema, column, (int[])value);
        } else if (value instanceof long[]) {
            RecordChecker.checkLongArray(schema, column, (long[])value);
        } else if (value instanceof float[]) {
            RecordChecker.checkFloatArray(schema, column, (float[])value);
        } else if (value instanceof double[]) {
            RecordChecker.checkDoubleArray(schema, column, (double[])value);
        } else if (value instanceof boolean[]) {
            RecordChecker.checkBooleanArray(schema, column, (boolean[])value);
        } else if (value instanceof byte[]) {
            switch (column.getType()) {
                case 1111: {
                    if ("roaringbitmap".equals(column.getTypeName())) {
                        RecordChecker.checkRoaringbitmap(schema, column, (byte[])value);
                        break;
                    }
                }
                case -2: {
                    RecordChecker.checkBytea(schema, column, (byte[])value);
                }
            }
        } else if (value instanceof String) {
            switch (column.getType()) {
                case 1111: {
                    if ("json".equals(column.getTypeName())) {
                        RecordChecker.checkJson(schema, column, (String)value);
                        break;
                    }
                    if ("jsonb".equals(column.getTypeName())) {
                        RecordChecker.checkJsonb(schema, column, (String)value);
                        break;
                    }
                }
                default: {
                    RecordChecker.checkString(schema, column, value.toString());
                    break;
                }
            }
        } else {
            RecordChecker.checkString(schema, column, value.toString());
        }
    }

    private static void checkNull(TableSchema schema, Column column) throws HoloClientException {
        if (!column.getAllowNull().booleanValue() && column.getDefaultValue() == null) {
            RecordChecker.throwConstraintViolationException(schema, column, null, "not allow null value", null);
        }
    }

    private static void checkShort(TableSchema schema, Column column, short value) throws HoloClientException {
        switch (column.getType()) {
            case -5: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setShort method", null);
            }
        }
    }

    private static void checkInteger(TableSchema schema, Column column, int value) throws HoloClientException {
        switch (column.getType()) {
            case -5: 
            case 4: {
                break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setInteger method", null);
            }
        }
    }

    private static void checkLong(TableSchema schema, Column column, long value) throws HoloClientException {
        switch (column.getType()) {
            case -5: {
                break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setLong method", null);
            }
        }
    }

    private static void checkBigDecimal(TableSchema schema, Column column, BigDecimal value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
            return;
        }
        switch (column.getType()) {
            case 2: {
                if (column.getPrecision() <= 0 || column.getPrecision() < column.getScale() || value.precision() - value.scale() <= column.getPrecision() - column.getScale()) break;
                RecordChecker.throwConstraintViolationException(schema, column, value, "A field with precision " + column.getPrecision() + ", scale " + column.getScale() + " must round to an absolute value less than 10^" + (column.getPrecision() - column.getScale()), null);
                break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setBigDecimal method", null);
            }
        }
    }

    private static void checkBoolean(TableSchema schema, Column column, boolean value) throws HoloClientException {
        switch (column.getType()) {
            case 16: {
                break;
            }
            case -7: {
                if ("bool".equals(column.getTypeName())) break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setBoolean method", null);
            }
        }
    }

    private static void checkFloat(TableSchema schema, Column column, float value) throws HoloClientException {
        switch (column.getType()) {
            case 7: {
                break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, Float.valueOf(value), "unsupported type " + column.getTypeName() + " for setFloat method", null);
            }
        }
    }

    private static void checkDouble(TableSchema schema, Column column, double value) throws HoloClientException {
        switch (column.getType()) {
            case 8: {
                break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setDouble method", null);
            }
        }
    }

    private static void checkDate(TableSchema schema, Column column, Date value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
        }
        switch (column.getType()) {
            case 91: {
                break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setDate method", null);
            }
        }
    }

    private static void checkTimeStamp(TableSchema schema, Column column, Timestamp value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
        }
        switch (column.getType()) {
            case 93: 
            case 2014: {
                break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setTimeStamp method", null);
            }
        }
    }

    private static void checkString(TableSchema schema, Column column, String value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
        }
        if (value.contains("\u0000")) {
            RecordChecker.throwConstraintViolationException(schema, column, value.replaceAll("\u0000", "\\\\u0000"), "invalid byte sequence for encoding \"UTF8\": 0x00", null);
        }
        switch (column.getType()) {
            case 1: 
            case 12: {
                if (column.getPrecision() <= 0) break;
                int precision = column.getPrecision();
                if (value.length() <= precision) break;
                RecordChecker.throwConstraintViolationException(schema, column, value, "value too long for type character varying(" + precision + ")", null);
                break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setString method", null);
            }
        }
    }

    private static void checkJson(TableSchema schema, Column column, String value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
        }
        if (value.contains("\u0000")) {
            RecordChecker.throwConstraintViolationException(schema, column, value.replaceAll("\u0000", "\\\\u0000"), "invalid byte sequence for encoding \"UTF8\": 0x00", null);
        }
        if (value.contains("\\u0000")) {
            RecordChecker.throwConstraintViolationException(schema, column, value, "invalid byte sequence for encoding \"UTF8\": 0x00", null);
        }
        switch (column.getType()) {
            case 1111: {
                if ("json".equals(column.getTypeName())) break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setJson method", null);
            }
        }
    }

    private static void checkJsonb(TableSchema schema, Column column, String value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
        }
        if (value.contains("\u0000")) {
            RecordChecker.throwConstraintViolationException(schema, column, value.replaceAll("\u0000", "\\\\u0000"), "invalid byte sequence for encoding \"UTF8\": 0x00", null);
        }
        if (value.contains("\\u0000")) {
            RecordChecker.throwConstraintViolationException(schema, column, value, "invalid byte sequence for encoding \"UTF8\": 0x00", null);
        }
        switch (column.getType()) {
            case 1111: {
                if ("jsonb".equals(column.getTypeName())) break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setJsonb method", null);
            }
        }
    }

    private static void checkBytea(TableSchema schema, Column column, byte[] value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
        }
        switch (column.getType()) {
            case -2: {
                break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setBytea method", null);
            }
        }
    }

    private static void checkRoaringbitmap(TableSchema schema, Column column, byte[] value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
        }
        switch (column.getType()) {
            case 1111: {
                if ("roaringbitmap".equals(column.getTypeName())) break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setRoaringbitmap method", null);
            }
        }
    }

    private static void checkStringArray(TableSchema schema, Column column, String[] value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
            return;
        }
        for (String str : value) {
            if (str == null) {
                RecordChecker.throwConstraintViolationException(schema, column, Arrays.toString(value), "Not support null value in array", null);
                continue;
            }
            if (!str.contains("\u0000")) continue;
            RecordChecker.throwConstraintViolationException(schema, column, Arrays.toString(value).replaceAll("\u0000", "\\\\u0000"), "invalid byte sequence for encoding \"UTF8\": 0x00", null);
        }
        switch (column.getType()) {
            case 2003: {
                if ("_text".equals(column.getTypeName())) break;
                if ("_varchar".equals(column.getTypeName())) {
                    if (column.getPrecision() <= 0) break;
                    int precision = column.getPrecision();
                    for (String str : value) {
                        if (str.length() <= precision) continue;
                        RecordChecker.throwConstraintViolationException(schema, column, Arrays.toString(value), "value too long for type character varying(" + precision + ")", null);
                    }
                    break;
                }
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setStringArray method", null);
            }
        }
    }

    private static void checkBooleanArray(TableSchema schema, Column column, boolean[] value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
            return;
        }
        switch (column.getType()) {
            case 2003: {
                if ("_bool".equals(column.getTypeName())) break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setBooleanArray method", null);
            }
        }
    }

    private static void checkFloatArray(TableSchema schema, Column column, float[] value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
            return;
        }
        switch (column.getType()) {
            case 2003: {
                if ("_float4".equals(column.getTypeName())) break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setFloatArray method", null);
            }
        }
    }

    private static void checkDoubleArray(TableSchema schema, Column column, double[] value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
            return;
        }
        switch (column.getType()) {
            case 2003: {
                if ("_float8".equals(column.getTypeName())) break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setDoubleArray method", null);
            }
        }
    }

    private static void checkIntegerArray(TableSchema schema, Column column, int[] value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
            return;
        }
        switch (column.getType()) {
            case 2003: {
                if ("_int4".equals(column.getTypeName())) break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setIntegerArray method", null);
            }
        }
    }

    private static void checkLongArray(TableSchema schema, Column column, long[] value) throws HoloClientException {
        if (value == null) {
            RecordChecker.checkNull(schema, column);
            return;
        }
        switch (column.getType()) {
            case 2003: {
                if ("_int8".equals(column.getTypeName())) break;
            }
            default: {
                RecordChecker.throwConstraintViolationException(schema, column, value, "unsupported type " + column.getTypeName() + " for setLongArray method", null);
            }
        }
    }
}

