/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.model;

import com.alibaba.hologres.client.exception.InvalidIdentifierException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class TableName
implements Serializable {
    public static final String DEFAULT_SCHEMA_NAME = "public";
    private static final byte[] LOCK = new byte[0];
    private static Map<String, TableName> tableCache2 = new HashMap<String, TableName>();
    String schemaName;
    String tableName;
    String fullName;
    static final Pattern IDENTIFIER_PATTERN = Pattern.compile("^[^\"\\s\\d\\-;][^\"\\s\\-;]*$");
    public static final char QUOTE = '\"';
    public static final char SPLIT = '.';

    private TableName(String schemaName, String tableName, String fullName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public static TableName valueOf(String schemaName, String tableName) throws InvalidIdentifierException {
        if (schemaName == null || schemaName.length() < 1) {
            schemaName = DEFAULT_SCHEMA_NAME;
        }
        return TableName.valueOf(schemaName + "." + tableName);
    }

    public static String parseIdentifier(String identifier) {
        List<String> ret = TableName.parseMultiIdentifier(identifier);
        if (ret == null) {
            return null;
        }
        if (ret.size() == 1) {
            return ret.get(0);
        }
        throw new InvalidIdentifierException(identifier);
    }

    public static List<String> parseMultiIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        boolean isQuoteState = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < identifier.length(); ++i) {
            int c = identifier.charAt(i);
            if (isQuoteState) {
                if (c == 34) {
                    if (i < identifier.length() - 1) {
                        if (identifier.charAt(i + 1) == '\"') {
                            sb.append('\"');
                        } else if (identifier.charAt(i + 1) == '.') {
                            isQuoteState = false;
                            ret.add(sb.toString());
                            sb.setLength(0);
                        } else {
                            throw new InvalidIdentifierException(identifier);
                        }
                        ++i;
                        continue;
                    }
                    ret.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            char lowerC = (char)(c >= 65 && c <= 90 ? c + 32 : c);
            if (sb.length() == 0) {
                if (c == 34) {
                    isQuoteState = true;
                    continue;
                }
                if (c == 46) {
                    throw new InvalidIdentifierException(identifier);
                }
                sb.append(lowerC);
                continue;
            }
            if (c == 34) {
                throw new InvalidIdentifierException(identifier);
            }
            if (c == 46) {
                String text = sb.toString();
                sb.setLength(0);
                if (IDENTIFIER_PATTERN.matcher(text).find()) {
                    ret.add(text);
                    continue;
                }
                throw new InvalidIdentifierException(identifier);
            }
            sb.append(lowerC);
        }
        if (sb.length() > 0) {
            if (isQuoteState) {
                throw new InvalidIdentifierException(identifier);
            }
            String text = sb.toString();
            sb.setLength(0);
            if (IDENTIFIER_PATTERN.matcher(text).find()) {
                ret.add(text);
            } else {
                throw new InvalidIdentifierException(identifier);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TableName valueOf(String name) throws InvalidIdentifierException {
        TableName tableName = tableCache2.get(name);
        if (tableName != null) return tableName;
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            char c;
            int i;
            String parsedTableName;
            String parsedSchemaName;
            tableName = tableCache2.get(name);
            if (tableName != null) return tableName;
            List<String> schemaAndTableName = TableName.parseMultiIdentifier(name);
            if (schemaAndTableName.size() == 1) {
                parsedSchemaName = DEFAULT_SCHEMA_NAME;
                parsedTableName = schemaAndTableName.get(0);
            } else {
                if (schemaAndTableName.size() != 2) throw new InvalidIdentifierException(name);
                parsedSchemaName = schemaAndTableName.get(0);
                parsedTableName = schemaAndTableName.get(1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\"");
            for (i = 0; i < parsedSchemaName.length(); ++i) {
                c = parsedSchemaName.charAt(i);
                if (c == '\"') {
                    sb.append(c);
                }
                sb.append(c);
            }
            sb.append("\".\"");
            for (i = 0; i < parsedTableName.length(); ++i) {
                c = parsedTableName.charAt(i);
                if (c == '\"') {
                    sb.append(c);
                }
                sb.append(c);
            }
            sb.append("\"");
            String parsedFullName = sb.toString();
            HashMap<String, TableName> temp = new HashMap<String, TableName>(tableCache2);
            tableName = tableCache2.get(parsedFullName);
            if (tableName == null) {
                tableName = new TableName(parsedSchemaName, parsedTableName, parsedFullName);
                temp.put(parsedFullName, tableName);
            }
            temp.put(name, tableName);
            tableCache2 = temp;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tableName;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableName tableName1 = (TableName)o;
        return Objects.equals(this.schemaName, tableName1.schemaName) && Objects.equals(this.tableName, tableName1.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public String toString() {
        return this.fullName;
    }
}

