/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.util;

import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.HoloVersion;
import com.alibaba.hologres.client.model.Partition;
import com.alibaba.hologres.client.model.TableName;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.client.utils.IdentifierUtil;
import com.alibaba.hologres.org.postgresql.PGProperty;
import com.alibaba.hologres.org.postgresql.jdbc.PgConnection;
import com.alibaba.hologres.org.postgresql.util.PSQLState;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUtil.class);
    static Pattern holoVersionPattern = Pattern.compile("release-([^ )]*)");
    static Pattern hgVersionPattern = Pattern.compile("Hologres ([^ -]*)");
    private static String optionProperty = "options=";
    private static String fixedOption = "type=fixed%20";
    private static final HoloVersion CHECK_TABLE_META_SUPPORTED_MIN_VERSION = new HoloVersion(1, 1, 50);

    public static void refreshMeta(Connection conn, int timeout) throws SQLException {
        try (Statement stat = conn.createStatement();){
            stat.execute("select hologres.hg_internal_refresh_meta(" + timeout + ")");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static CheckMetaResult checkMeta(Connection conn, HoloVersion version, String fullName, int timeout) throws SQLException {
        block55: {
            if (version.compareTo(CHECK_TABLE_META_SUPPORTED_MIN_VERSION) < 0) break block55;
            try {
                Throwable throwable = null;
                try (Statement stat = conn.createStatement();){
                    CheckMetaResult checkMetaResult;
                    Object object;
                    ResultSet rs;
                    block53: {
                        block54: {
                            block47: {
                                CheckMetaResult checkMetaResult2;
                                block51: {
                                    block52: {
                                        block48: {
                                            CheckMetaResult checkMetaResult3;
                                            block49: {
                                                block50: {
                                                    stat.setQueryTimeout(timeout);
                                                    rs = stat.executeQuery("select hologres.hg_internal_check_table_meta('" + fullName + "')");
                                                    object = null;
                                                    if (!rs.next()) break block47;
                                                    String msg = rs.getString(1);
                                                    boolean ok = "Check meta succeeded".equals(msg);
                                                    if (!ok) break block48;
                                                    checkMetaResult3 = new CheckMetaResult(ok, msg);
                                                    if (rs == null) break block49;
                                                    if (object == null) break block50;
                                                    try {
                                                        rs.close();
                                                    }
                                                    catch (Throwable throwable2) {
                                                        ((Throwable)object).addSuppressed(throwable2);
                                                    }
                                                    break block49;
                                                }
                                                rs.close();
                                            }
                                            return checkMetaResult3;
                                        }
                                        ConnectionUtil.refreshMeta(conn, timeout);
                                        checkMetaResult2 = new CheckMetaResult(true, null);
                                        if (rs == null) break block51;
                                        if (object == null) break block52;
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable3) {
                                            ((Throwable)object).addSuppressed(throwable3);
                                        }
                                        break block51;
                                    }
                                    rs.close();
                                }
                                return checkMetaResult2;
                            }
                            checkMetaResult = new CheckMetaResult(false, "hologres.hg_internal_check_table_meta return 0 rows");
                            if (rs == null) break block53;
                            if (object == null) break block54;
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                ((Throwable)object).addSuppressed(throwable4);
                            }
                            break block53;
                        }
                        rs.close();
                    }
                    return checkMetaResult;
                    {
                        catch (Throwable throwable5) {
                            try {
                                try {
                                    object = throwable5;
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    if (rs != null) {
                                        if (object != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (Throwable throwable7) {
                                                ((Throwable)object).addSuppressed(throwable7);
                                            }
                                        } else {
                                            rs.close();
                                        }
                                    }
                                    throw throwable6;
                                }
                            }
                            catch (SQLException e) {
                                if (PSQLState.UNDEFINED_TABLE.getState().equals(e.getSQLState())) {
                                    ConnectionUtil.refreshMeta(conn, timeout);
                                    object = new CheckMetaResult(true, null);
                                    return object;
                                }
                                try {
                                    throw e;
                                }
                                catch (Throwable throwable8) {
                                    throwable = throwable8;
                                    throw throwable8;
                                }
                            }
                        }
                    }
                }
            }
            catch (SQLException e) {
                if (PSQLState.QUERY_CANCELED.getState().equals(e.getSQLState())) {
                    return new CheckMetaResult(false, "table is lock by other query which request a AccessExclusiveLock");
                }
                if (e.getMessage().contains("Failed to get table") && e.getMessage().contains("from StoreMaster")) {
                    return new CheckMetaResult(false, "Failed to get table from StoreMaster, maybe still in replay after a truncate");
                }
                throw e;
            }
        }
        ConnectionUtil.refreshMeta(conn, timeout);
        return new CheckMetaResult(true, null);
    }

    public static HoloVersion getHoloVersion(Connection conn) throws SQLException {
        Throwable throwable = null;
        try (Statement stmt = conn.createStatement();){
            String hgverStr = ConnectionUtil.parseSingleCell(stmt.executeQuery("select hg_version()"));
            HoloVersion holoVersion = ConnectionUtil.parseHgVersion(hgverStr);
            return holoVersion;
        }
        catch (Exception hgverStr) {
        }
        catch (Throwable hgverStr) {
            throwable = hgverStr;
            throw hgverStr;
        }
        stmt = conn.createStatement();
        throwable = null;
        try {
            String verStr = ConnectionUtil.parseSingleCell(stmt.executeQuery("select version()"));
            HoloVersion holoVersion = ConnectionUtil.parseHoloVersion(verStr);
            return holoVersion;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (stmt != null) {
                if (throwable != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    public static HoloVersion parseHgVersion(String verStr) throws Exception {
        String v;
        HoloVersion hv;
        Matcher matcher = hgVersionPattern.matcher(verStr);
        if (matcher.find() && !(hv = new HoloVersion(v = matcher.group(1))).isUndefined()) {
            return hv;
        }
        throw new Exception("Failed to parse hg_version() result");
    }

    public static HoloVersion parseHoloVersion(String verStr) {
        Matcher matcher = holoVersionPattern.matcher(verStr);
        if (matcher.find()) {
            String v = matcher.group(1);
            return new HoloVersion(v);
        }
        return null;
    }

    public static String getDatabase(Connection conn) throws SQLException {
        try (Statement stat = conn.createStatement();){
            String string = ConnectionUtil.parseSingleCell(stat.executeQuery("select current_database()"));
            return string;
        }
    }

    public static String getPartitionColumnName(Connection conn, TableName tableName) throws SQLException {
        StringBuilder sb = new StringBuilder(512);
        sb.append("SELECT n.nspname as Schema, c.relname as Name,\n");
        sb.append("    part.partstrat,\n");
        sb.append("    part.partnatts,\n");
        sb.append("    part.partattrs\n");
        sb.append("FROM pg_catalog.pg_class c\n");
        sb.append("JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\n");
        sb.append("JOIN pg_catalog.pg_partitioned_table part ON c.oid = part.partrelid\n");
        sb.append("where n.nspname=? and c.relname=? \n");
        sb.append("limit 1;\n");
        String sql = sb.toString();
        int partColumnPos = -1;
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, tableName.getSchemaName());
            stmt.setString(2, tableName.getTableName());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String strategyStr = rs.getString("partstrat");
                if (!"l".equals(strategyStr)) {
                    throw new SQLException("Only LIST partition is supported in holo.");
                }
                String partColumnStr = rs.getString("partattrs");
                partColumnPos = Integer.parseInt(partColumnStr);
            }
        }
        String partColumnName = null;
        sql = "SELECT attname FROM pg_attribute WHERE attrelid =?::regclass AND attnum = ?;";
        if (partColumnPos > 0) {
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, tableName.getFullName());
                stmt.setInt(2, partColumnPos);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    String string = rs.getString("attname");
                    return string;
                }
            }
        }
        return partColumnName;
    }

    public static Partition getPartition(Connection conn, String schemaName, String tableName, String partValue, boolean isStr) throws SQLException {
        StringBuilder sb = new StringBuilder(512);
        sb.append("with inh as ( \n");
        sb.append("    SELECT i.inhrelid, i.inhparent \n");
        sb.append("    FROM pg_catalog.pg_class c \n");
        sb.append("    LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \n");
        sb.append("    LEFT JOIN pg_catalog.pg_inherits i on c.oid=i.inhparent \n");
        sb.append("    where n.nspname=? and c.relname=? \n");
        sb.append(") \n");
        sb.append("select \n");
        sb.append("    n.nspname as schema_name, \n");
        sb.append("    c.relname as table_name, \n");
        sb.append("    inh.inhrelid, inh.inhparent, p.partstrat, \n");
        sb.append("    pg_get_expr(c.relpartbound, c.oid, true) as part_expr, \n");
        sb.append("    p.partdefid, \n");
        sb.append("    p.partnatts, \n");
        sb.append("    p.partattrs \n");
        sb.append("from inh \n");
        sb.append("join pg_catalog.pg_class c on inh.inhrelid = c.oid \n");
        sb.append("join pg_catalog.pg_namespace n on c.relnamespace = n.oid \n");
        sb.append("join pg_partitioned_table p on p.partrelid = inh.inhparent where pg_get_expr(c.relpartbound, c.oid, true)=? limit 1 \n");
        String sql = sb.toString();
        ResultSet rs = null;
        Partition partition = null;
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, "FOR VALUES IN (" + (isStr ? "'" : "") + partValue + (isStr ? "'" : "") + ")");
            rs = stmt.executeQuery();
            if (rs.next()) {
                String strategyStr = rs.getString("partstrat");
                if (!"l".equals(strategyStr)) {
                    throw new SQLException("Only LIST partition is supported in holo.");
                }
                partition = new Partition();
                partition.setParentSchemaName(schemaName);
                partition.setParentTableName(tableName);
                String schema = rs.getString("schema_name");
                String table = rs.getString("table_name");
                partition.setSchemaName(schema);
                partition.setTableName(table);
                partition.setPartitionValue(partValue);
            }
            Partition partition2 = partition;
            return partition2;
        }
    }

    public static Partition retryCreatePartitionChildTable(Connection conn, String schemaName, String tableName, String partValue, boolean isStr) throws SQLException {
        int retry = 0;
        while (true) {
            Statement stmt = null;
            String childSchemaName = schemaName;
            String childTableName = retry == 0 ? String.format("%s_%s", tableName, partValue) : String.format("%s_%s_%d", tableName, partValue, System.currentTimeMillis());
            try {
                String valueStr = null;
                valueStr = isStr ? String.format("'%s'", partValue) : partValue;
                String sql = String.format("create table %s.%s partition of %s.%s for values in (%s);", IdentifierUtil.quoteIdentifier(childSchemaName, true), IdentifierUtil.quoteIdentifier(childTableName, true), IdentifierUtil.quoteIdentifier(schemaName, true), IdentifierUtil.quoteIdentifier(tableName, true), valueStr);
                stmt = conn.createStatement();
                stmt.execute(sql);
                Partition partition = new Partition();
                partition.setTableName(childTableName);
                partition.setSchemaName(childSchemaName);
                partition.setParentTableName(tableName);
                partition.setParentSchemaName(schemaName);
                partition.setPartitionValue(valueStr);
                Partition partition2 = partition;
                return partition2;
            }
            catch (SQLException e) {
                String alreadyExistMsg = String.format("relation \"%s\" already exists", childTableName);
                if (e.getMessage().indexOf(alreadyExistMsg) != -1 && retry < 20) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++retry;
                    continue;
                }
                throw e;
            }
            finally {
                if (stmt == null) continue;
                stmt.close();
                continue;
            }
            break;
        }
    }

    public static TableSchema getTableSchema(Connection conn, TableName tableName) throws SQLException {
        Object columns = null;
        Object types = null;
        Object typeNames = null;
        DatabaseMetaData metaData = conn.getMetaData();
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        try (ResultSet rs = metaData.getPrimaryKeys(null, tableName.getSchemaName(), tableName.getTableName());){
            while (rs.next()) {
                primaryKeyList.add(rs.getString(4));
            }
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        String escape = metaData.getSearchStringEscape();
        try (ResultSet rs = metaData.getColumns(null, ConnectionUtil.escapePattern(tableName.getSchemaName(), escape), ConnectionUtil.escapePattern(tableName.getTableName(), escape), "%");){
            while (rs.next()) {
                Column column = new Column();
                column.setName(rs.getString(4));
                column.setType(rs.getInt(5));
                column.setTypeName(rs.getString(6));
                column.setPrecision(rs.getInt(7));
                column.setScale(rs.getInt(9));
                column.setAllowNull(rs.getInt(11) == 1);
                column.setComment(rs.getString(12));
                column.setDefaultValue(rs.getObject(13));
                column.setArrayType(column.getTypeName().startsWith("_"));
                column.setPrimaryKey(primaryKeyList.contains(column.getName()));
                columnList.add(column);
            }
        }
        String partitionColumnName = ConnectionUtil.getPartitionColumnName(conn, tableName);
        String sql = "select property_key,property_value from hologres.hg_table_properties where table_namespace=? and table_name=? and property_key in ('distribution_key','table_id','schema_version','orientation','clustering_key','segment_key','bitmap_columns','dictionary_encoding_columns','time_to_live_in_seconds','binlog.level')";
        Object distributionKeys = null;
        String tableId = null;
        String schemaVersion = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        PreparedStatement stat = conn.prepareStatement(sql);
        Object object = null;
        try {
            stat.setString(1, tableName.getSchemaName());
            stat.setString(2, tableName.getTableName());
            try (ResultSet resultSet = stat.executeQuery();){
                while (resultSet.next()) {
                    String propertyName = resultSet.getString(1);
                    String propertyValue = resultSet.getString(2);
                    properties.put(propertyName, propertyValue);
                }
            }
            tableId = (String)properties.get("table_id");
            schemaVersion = (String)properties.get("schema_version");
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (stat != null) {
                if (object != null) {
                    try {
                        stat.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    stat.close();
                }
            }
        }
        if (properties.size() == 0) {
            throw new SQLException("can not found table " + tableName.getFullName());
        }
        if (tableId == null) {
            throw new SQLException("table " + tableName.getFullName() + " has no table_id");
        }
        if (schemaVersion == null) {
            throw new SQLException("table " + tableName.getFullName() + " has no schemaVersion");
        }
        TableSchema.Builder builder = new TableSchema.Builder(tableId, schemaVersion);
        builder.setPartitionColumnName(partitionColumnName);
        builder.setColumns(columnList);
        builder.setTableName(tableName);
        builder.setNotExist(false);
        builder.setSensitive(true);
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            switch (key) {
                case "distribution_key": {
                    if ("".equals(value)) {
                        throw new SQLException("empty distribution_key is not supported.");
                    }
                    builder.setDistributionKeys(value.split(","));
                    break;
                }
                case "orientation": {
                    builder.setOrientation(value);
                    break;
                }
                case "clustering_key": {
                    builder.setClusteringKey(value.split(","));
                    break;
                }
                case "segment_key": {
                    builder.setSegmentKey(value.split(","));
                    break;
                }
                case "bitmap_columns": {
                    builder.setBitmapIndexKey(value.split(","));
                    break;
                }
                case "dictionary_encoding_columns": {
                    builder.setDictionaryEncoding(value.split(","));
                    break;
                }
                case "time_to_live_in_seconds": {
                    builder.setLifecycle(Long.parseLong(value));
                    break;
                }
                case "binlog.level": {
                    builder.setBinlogLevel(value);
                    break;
                }
            }
        }
        TableSchema tableSchema = builder.build();
        tableSchema.calculateProperties();
        return tableSchema;
    }

    private static String parseSingleCell(ResultSet rs) throws SQLException {
        String ret = null;
        if (rs.next()) {
            ret = rs.getString(1);
        }
        return ret;
    }

    private static String escapePattern(String pattern, String escape) {
        return pattern.replace(escape, escape + escape).replace("%", escape + "%").replace("_", escape + "_");
    }

    public static String getDirectConnectionJdbcUrl(String originalJdbcUrl, Properties info) throws SQLException {
        LOGGER.info("Try to connect {} for getting fe endpoint", (Object)originalJdbcUrl);
        String endpoint = "";
        String username = info.getProperty(PGProperty.USER.getName());
        String password = info.getProperty(PGProperty.PASSWORD.getName());
        try (PgConnection conn = DriverManager.getConnection(originalJdbcUrl, username, password).unwrap(PgConnection.class);){
            String sql = "select inet_server_addr(), inet_server_port()";
            try (Statement stat = conn.createStatement();
                 ResultSet rs = stat.executeQuery(sql);){
                while (rs.next()) {
                    endpoint = rs.getString(1) + ":" + rs.getString(2);
                }
            }
        }
        String directConnectionJdbcUrl = ConnectionUtil.replaceJdbcUrlEndpoint(originalJdbcUrl, endpoint);
        LOGGER.info("Get the direct connection jdbc url {}", (Object)directConnectionJdbcUrl);
        return directConnectionJdbcUrl;
    }

    public static String replaceJdbcUrlEndpoint(String originalUrl, String newEndpoint) {
        String replacement = "//" + newEndpoint + "/";
        return originalUrl.replaceFirst("//\\S+/", replacement);
    }

    public static String generateFixedUrl(String url) {
        StringBuilder sb = new StringBuilder(url);
        int index = sb.lastIndexOf(optionProperty);
        if (index > -1) {
            sb.insert(index + optionProperty.length(), fixedOption);
        } else {
            sb.append(url.contains("?") ? "&" : "?").append(optionProperty).append(fixedOption);
        }
        return sb.toString();
    }

    public static class CheckMetaResult {
        boolean updated;
        String msg;

        public CheckMetaResult(boolean updated, String msg) {
            this.updated = updated;
            this.msg = msg;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

