/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.Put;
import com.alibaba.hologres.client.exception.ExceptionCode;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.exception.HoloClientWithDetailsException;
import com.alibaba.hologres.client.impl.ConnectionHolder;
import com.alibaba.hologres.client.impl.PreparedStatementWithBatchInfo;
import com.alibaba.hologres.client.impl.UnnestUpsertStatementBuilder;
import com.alibaba.hologres.client.impl.UpsertStatementBuilder;
import com.alibaba.hologres.client.impl.action.PutAction;
import com.alibaba.hologres.client.impl.handler.ActionHandler;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.WriteFailStrategy;
import com.alibaba.hologres.client.model.WriteMode;
import com.alibaba.hologres.client.utils.Metrics;
import com.alibaba.hologres.com.codahale.metrics.MetricRegistry;
import com.alibaba.hologres.org.postgresql.jdbc.PgConnection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutActionHandler
extends ActionHandler<PutAction> {
    public static final Logger LOGGER = LoggerFactory.getLogger(PutActionHandler.class);
    private static final String NAME = "put";
    private final HoloConfig config;
    private final UpsertStatementBuilder builder;
    protected final ConnectionHolder connectionHolder;

    public PutActionHandler(ConnectionHolder connectionHolder, HoloConfig config) {
        super(config);
        this.config = config;
        this.builder = config.isUseLegacyPutHandler() ? new UpsertStatementBuilder(config) : new UnnestUpsertStatementBuilder(config);
        this.connectionHolder = connectionHolder;
    }

    private void markRecordPutSuccess(Record record) {
        if (record.getPutFutures() != null) {
            for (CompletableFuture<Void> future : record.getPutFutures()) {
                try {
                    future.complete(null);
                }
                catch (Exception e) {
                    LOGGER.error("markRecordPutSuccess", e);
                }
            }
        }
    }

    private void markRecordPutFail(Record record, HoloClientException e) {
        if (record.getPutFutures() != null) {
            for (CompletableFuture<Void> future : record.getPutFutures()) {
                try {
                    future.completeExceptionally(e);
                }
                catch (Exception e1) {
                    LOGGER.error("markRecordPutFail", e1);
                }
            }
        }
    }

    private boolean isDirtyDataException(HoloClientException e) {
        boolean ret = false;
        switch (e.getCode()) {
            case TABLE_NOT_FOUND: 
            case CONSTRAINT_VIOLATION: 
            case DATA_TYPE_ERROR: 
            case DATA_VALUE_ERROR: {
                ret = true;
                break;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(PutAction action) {
        HoloClientException exception;
        block23: {
            List<Record> recordList = action.getRecordList();
            WriteMode mode = action.getWriteMode();
            exception = null;
            try {
                this.doHandlePutAction(recordList, mode);
                for (Record record : recordList) {
                    this.markRecordPutSuccess(record);
                }
            }
            catch (HoloClientException e) {
                WriteFailStrategy strategy = this.config.getWriteFailStrategy();
                if (!this.isDirtyDataException(e)) {
                    exception = e;
                    strategy = WriteFailStrategy.NONE;
                }
                boolean useDefaultStrategy = true;
                switch (strategy) {
                    case TRY_ONE_BY_ONE: {
                        LOGGER.warn("write data fail, current WriteFailStrategy is TRY_ONE_BY_ONE", e);
                        if (e.getCode() == ExceptionCode.TABLE_NOT_FOUND) break;
                        ArrayList single = new ArrayList(1);
                        HoloClientWithDetailsException fails = new HoloClientWithDetailsException(e);
                        for (Record record : recordList) {
                            try {
                                single.add(record);
                                this.doHandlePutAction(single, mode);
                                this.markRecordPutSuccess(record);
                            }
                            catch (HoloClientException subE) {
                                if (!this.isDirtyDataException(subE)) {
                                    exception = subE;
                                } else {
                                    fails.add(record, subE);
                                }
                                this.markRecordPutFail(record, subE);
                            }
                            catch (Exception subE) {
                                exception = new HoloClientException(ExceptionCode.INTERNAL_ERROR, "", subE);
                                this.markRecordPutFail(record, exception);
                            }
                            finally {
                                single.clear();
                            }
                        }
                        if (exception == null && fails.size() > 0) {
                            exception = fails;
                        }
                        useDefaultStrategy = false;
                        break;
                    }
                }
                if (!useDefaultStrategy) break block23;
                for (Record record : recordList) {
                    this.markRecordPutFail(record, e);
                }
                if (exception != null) break block23;
                HoloClientWithDetailsException localPutException = new HoloClientWithDetailsException(e);
                localPutException.add(recordList, e);
                exception = localPutException;
            }
            catch (Exception e) {
                exception = new HoloClientException(ExceptionCode.INTERNAL_ERROR, "", e);
                for (Record record : recordList) {
                    this.markRecordPutFail(record, exception);
                }
            }
        }
        if (exception != null) {
            action.getFuture().completeExceptionally(exception);
        } else {
            action.getFuture().complete(null);
        }
    }

    protected void doHandlePutAction(List<Record> list, WriteMode mode) throws HoloClientException {
        this.connectionHolder.retryExecuteWithVersion(connWithVersion -> {
            PgConnection conn = connWithVersion.getConn();
            List<PreparedStatementWithBatchInfo> psArray = this.builder.buildStatements(conn, connWithVersion.getVersion(), ((Record)list.get(0)).getSchema(), ((Record)list.get(0)).getTableName(), list, mode);
            try {
                long startTime = System.nanoTime() / 1000000L;
                long bytes = 0L;
                long batchCount = 0L;
                for (PreparedStatementWithBatchInfo ps : psArray) {
                    if (ps != null) {
                        if (((Boolean)ps.r).booleanValue()) {
                            ((PreparedStatement)ps.l).executeBatch();
                        } else {
                            ((PreparedStatement)ps.l).execute();
                        }
                    }
                    if (ps.getType() != Put.MutationType.INSERT) continue;
                    bytes += ps.getByteSize();
                    batchCount += (long)ps.getBatchCount();
                }
                MetricRegistry registry = Metrics.registry();
                long endTime = System.nanoTime() / 1000000L;
                String tableName = ((Record)list.get(0)).getSchema().getTableNameObj().getFullName();
                registry.meter("write_qps").mark();
                registry.meter("write_bps").mark(bytes);
                if (batchCount > 0L) {
                    registry.histogram("write_sql_per_batch").update(batchCount);
                }
                registry.histogram("write_latency").update(endTime - startTime);
                registry.meter("write_rps").mark(list.size());
            }
            catch (Throwable throwable) {
                for (PreparedStatementWithBatchInfo ps : psArray) {
                    if (ps == null || ps.l == null) continue;
                    ((PreparedStatement)ps.l).close();
                }
                throw throwable;
            }
            for (PreparedStatementWithBatchInfo ps : psArray) {
                if (ps == null || ps.l == null) continue;
                ((PreparedStatement)ps.l).close();
            }
            return null;
        });
    }

    @Override
    public String getCostMsMetricName() {
        return "put_cost_ms";
    }
}

