/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.impl.ConnectionHolder;
import com.alibaba.hologres.client.impl.action.CopyAction;
import com.alibaba.hologres.client.impl.copy.CopyContext;
import com.alibaba.hologres.client.impl.copy.InternalPipedOutputStream;
import com.alibaba.hologres.client.impl.handler.ActionHandler;
import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.utils.IdentifierUtil;
import com.alibaba.hologres.org.postgresql.copy.CopyIn;
import com.alibaba.hologres.org.postgresql.copy.CopyManager;
import com.alibaba.hologres.org.postgresql.copy.CopyOut;
import com.alibaba.hologres.org.postgresql.jdbc.PgConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyActionHandler
extends ActionHandler<CopyAction> {
    public static final Logger LOGGER = LoggerFactory.getLogger(CopyActionHandler.class);
    private static final String NAME = "copy";
    private final HoloConfig config;
    private final ConnectionHolder connectionHolder;

    public CopyActionHandler(ConnectionHolder connectionHolder, HoloConfig config) {
        super(config);
        this.config = config;
        this.connectionHolder = connectionHolder;
    }

    public long doCopyOut(CopyContext copyContext, OutputStream to) throws SQLException, IOException {
        CopyOut cp = (CopyOut)copyContext.getCopyOperation();
        try {
            byte[] buf;
            while ((buf = cp.readFromCopy()) != null) {
                to.write(buf);
            }
            return cp.getHandledRowCount();
        }
        catch (Exception e) {
            try {
                copyContext.cancel();
            }
            catch (SQLException sqlEx) {
                LOGGER.error("copy out cancel failed", sqlEx);
            }
            if (e instanceof IOException) {
                try {
                    byte[] buf;
                    while ((buf = cp.readFromCopy()) != null) {
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public long doCopyIn(CopyContext copyContext, InputStream from, int bufferSize) throws SQLException, IOException {
        CopyIn cp = (CopyIn)copyContext.getCopyOperation();
        byte[] buf = new byte[bufferSize];
        boolean hasException = false;
        try {
            int len;
            while ((len = from.read(buf)) >= 0) {
                if (len <= 0) continue;
                cp.writeToCopy(buf, 0, len);
            }
            long l = cp.endCopy();
            return l;
        }
        catch (Exception e) {
            hasException = true;
            try {
                copyContext.cancel();
            }
            catch (SQLException sqlEx) {
                LOGGER.error("copy in cancel failed", sqlEx);
            }
            throw e;
        }
        finally {
            try {
                if (from instanceof PipedInputStream) {
                    from.close();
                }
            }
            catch (IOException ioEx) {
                if (hasException) {
                    LOGGER.error("close piped input stream failed", ioEx);
                }
                throw ioEx;
            }
        }
    }

    @Override
    public void handle(CopyAction action) {
        try {
            action.getFuture().complete((Long)this.connectionHolder.retryExecute(arg_0 -> this.lambda$handle$0(action, arg_0), 1));
        }
        catch (HoloClientException e) {
            action.getFuture().completeExceptionally(e);
        }
    }

    @Override
    public String getCostMsMetricName() {
        return "copy_cost_ms";
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Object lambda$handle$0(CopyAction action, PgConnection conn) throws SQLException {
        pgConn = conn.unwrap(PgConnection.class);
        manager = new CopyManager(pgConn);
        schema = action.getSchema();
        os = action.getOs();
        try {
            ret = -1L;
            switch (1.$SwitchMap$com$alibaba$hologres$client$impl$action$CopyAction$Mode[action.getMode().ordinal()]) {
                case 1: {
                    try {
                        sb = new StringBuilder();
                        sb.append("COPY (select ");
                        first = true;
                        for (Column column : schema.getColumnSchema()) {
                            if (!first) {
                                sb.append(",");
                            }
                            first = false;
                            sb.append(IdentifierUtil.quoteIdentifier(column.getName(), true));
                        }
                        sb.append(" from ").append(schema.getTableNameObj().getFullName());
                        if (action.getStartShardId() > -1 && action.getEndShardId() > -1) {
                            sb.append(" where hg_shard_id>=").append(action.getStartShardId()).append(" and hg_shard_id<").append(action.getEndShardId());
                        }
                        sb.append(") TO STDOUT DELIMITER ',' ESCAPE '\\' CSV QUOTE '\"' NULL AS 'N'");
                        sql = sb.toString();
                        CopyActionHandler.LOGGER.info("copy sql:{}", (Object)sql);
                        os = action.getOs();
                        copyOut = manager.copyOut(sql);
                        copyContext = new CopyContext(conn, copyOut);
                        action.getReadyToStart().complete(new CopyContext(conn, copyOut));
                        rowCount = this.doCopyOut(copyContext, os);
                        if (os instanceof InternalPipedOutputStream) {
                            os.close();
                        }
                        ret = rowCount;
                        break;
                    }
                    catch (Exception e) {
                        action.getReadyToStart().completeExceptionally(e);
                        throw e;
                    }
                }
                case 2: {
                    hasException = false;
                    if (action.getStartShardId() > -1 && action.getEndShardId() > -1) {
                        sql = new StringBuilder("set hg_experimental_target_shard_list='");
                        first = true;
                        for (i = action.getStartShardId(); i < action.getEndShardId(); ++i) {
                            if (!first) {
                                sql.append(",");
                            }
                            first = false;
                            sql.append(i);
                        }
                        sql.append("'");
                        try {
                            stat = pgConn.createStatement();
                            copyContext = null;
                            try {
                                stat.execute(sql.toString());
                            }
                            catch (Throwable var14_32) {
                                copyContext = var14_32;
                                throw var14_32;
                            }
                            finally {
                                if (stat != null) {
                                    if (copyContext != null) {
                                        try {
                                            stat.close();
                                        }
                                        catch (Throwable var14_31) {
                                            copyContext.addSuppressed(var14_31);
                                        }
                                    } else {
                                        stat.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException e) {
                            CopyActionHandler.LOGGER.error("", e);
                        }
                    }
                    sb = new StringBuilder();
                    sb.append("COPY ").append(schema.getTableNameObj().getFullName());
                    sb.append(" FROM STDIN DELIMITER ',' ESCAPE '\\' CSV QUOTE '\"' NULL AS 'N'");
                    sql = sb.toString();
                    CopyActionHandler.LOGGER.info("copy sql:{}", (Object)sql);
                    copyIn = manager.copyIn(sql);
                    copyContext = new CopyContext(conn, copyIn);
                    action.getReadyToStart().complete((CopyContext)copyContext);
                    ret = this.doCopyIn((CopyContext)copyContext, action.getIs(), action.getBufferSize() > -1 ? action.getBufferSize() : this.config.getCopyInBufferSize());
                    if (action.getStartShardId() <= -1 || action.getEndShardId() <= -1) break;
                    try {
                        stat = pgConn.createStatement();
                        var11_18 = null;
                        stat.execute("reset hg_experimental_target_shard_list");
                        if (stat == null) break;
                        if (var11_18 == null) ** GOTO lbl111
                        try {
                            stat.close();
                        }
                        catch (Throwable var12_24) {
                            var11_18.addSuppressed(var12_24);
                        }
                        break;
lbl111:
                        // 1 sources

                        stat.close();
                        ** break;
                        catch (Throwable var12_25) {
                            try {
                                var11_18 = var12_25;
                                throw var12_25;
                            }
                            catch (Throwable var18_35) {
                                if (stat != null) {
                                    if (var11_18 != null) {
                                        try {
                                            stat.close();
                                        }
                                        catch (Throwable var19_36) {
                                            var11_18.addSuppressed(var19_36);
                                        }
                                    } else {
                                        stat.close();
                                    }
                                }
                                throw var18_35;
lbl128:
                                // 1 sources

                                break;
                            }
                        }
                    }
                    catch (SQLException e) {
                        if (hasException) {
                            CopyActionHandler.LOGGER.error("reset hg_experimental_target_shard_list failed", e);
                            break;
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        try {
                            hasException = true;
                            action.getReadyToStart().completeExceptionally(e);
                            throw e;
                        }
                        catch (Throwable var20_37) {
                            if (action.getStartShardId() <= -1 || action.getEndShardId() <= -1) ** GOTO lbl168
                            try {
                                stat = pgConn.createStatement();
                                var22_40 = null;
                                try {
                                    stat.execute("reset hg_experimental_target_shard_list");
                                }
                                catch (Throwable var23_42) {
                                    var22_40 = var23_42;
                                    throw var23_42;
                                }
                                finally {
                                    if (stat != null) {
                                        if (var22_40 != null) {
                                            try {
                                                stat.close();
                                            }
                                            catch (Throwable var23_41) {
                                                var22_40.addSuppressed(var23_41);
                                            }
                                        } else {
                                            stat.close();
                                        }
                                    }
                                }
                            }
                            catch (SQLException e) {
                                if (!hasException) ** GOTO lbl167
                                CopyActionHandler.LOGGER.error("reset hg_experimental_target_shard_list failed", e);
                                ** GOTO lbl168
lbl167:
                                // 1 sources

                                throw e;
                            }
lbl168:
                            // 3 sources

                            throw var20_37;
                        }
                    }
                }
                default: {
                    throw new SQLException("copy but InputStream and OutputStream both null");
                }
            }
            return ret;
        }
        catch (Exception e) {
            if (os instanceof InternalPipedOutputStream) {
                try {
                    os.close();
                }
                catch (IOException var8_45) {
                    // empty catch block
                }
            }
            throw new SQLException(e);
        }
    }
}

