/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.binlog;

import java.sql.Timestamp;
import java.time.Instant;

public class BinlogOffset {
    private long sequence;
    private long timestamp;
    private String startTimeText;

    public BinlogOffset() {
        this(-1L, -1L);
    }

    public BinlogOffset(long sequence, long timestamp) {
        this.sequence = sequence;
        this.timestamp = timestamp;
        this.startTimeText = Timestamp.from(Instant.ofEpochMilli(timestamp / 1000L)).toString();
    }

    public long getSequence() {
        return this.sequence;
    }

    public BinlogOffset setSequence(long sequence) {
        this.sequence = sequence;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getStartTimeText() {
        return this.startTimeText;
    }

    public BinlogOffset setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public BinlogOffset setTimestamp(String timestamp) {
        this.startTimeText = timestamp;
        if (timestamp != null) {
            this.timestamp = Timestamp.valueOf(timestamp).getTime() * 1000L;
        }
        return this;
    }

    public boolean isValid() {
        return this.sequence > -1L || this.timestamp > -1L;
    }

    public boolean hasSequence() {
        return this.sequence > -1L;
    }

    public boolean hasTimestamp() {
        return this.timestamp > -1L;
    }

    public BinlogOffset next() {
        return new BinlogOffset(this.sequence >= 0L ? this.sequence + 1L : -1L, this.timestamp);
    }

    public String toString() {
        return "(" + this.sequence + ", " + this.timestamp + ")";
    }
}

