/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.exception;

import com.alibaba.hologres.client.exception.ExceptionCode;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.model.Record;
import java.util.ArrayList;
import java.util.List;

public class HoloClientWithDetailsException
extends HoloClientException {
    List<Record> failedList;
    List<HoloClientException> exceptionList;

    public HoloClientWithDetailsException(HoloClientException e) {
        super(e.getCode(), e.getMessage(), e.getCause());
    }

    public HoloClientWithDetailsException(ExceptionCode code, String msg, Record record) {
        super(code, msg);
        HoloClientException e = new HoloClientException(code, msg);
        this.add(record, e);
    }

    public void add(List<Record> failList, HoloClientException e) {
        for (Record record : failList) {
            this.add(record, e);
        }
    }

    public void add(Record record, HoloClientException e) {
        if (this.failedList == null) {
            this.failedList = new ArrayList<Record>();
            this.exceptionList = new ArrayList<HoloClientException>();
        }
        this.failedList.add(record);
        this.exceptionList.add(e);
    }

    public int size() {
        return this.failedList == null ? 0 : this.failedList.size();
    }

    public Record getFailRecord(int index) {
        return this.failedList.get(index);
    }

    public HoloClientException getException(int index) {
        return this.exceptionList.get(index);
    }

    public HoloClientException getException() {
        return this.exceptionList.get(0);
    }

    public HoloClientWithDetailsException merge(HoloClientWithDetailsException other) {
        this.failedList.addAll(other.failedList);
        this.exceptionList.addAll(other.exceptionList);
        return this;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        if (this.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("failed records " + this.size() + ", first:" + this.getFailRecord(0) + ",first err:" + this.getException(0).getMessage());
            return sb.toString();
        }
        return super.getMessage();
    }
}

