/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.copy;

import com.alibaba.hologres.client.copy.WithCopyResult;
import com.alibaba.hologres.org.postgresql.copy.CopyIn;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class CopyInOutputStream
extends OutputStream
implements WithCopyResult {
    private final CopyIn copyIn;
    private long result = -1L;

    public CopyInOutputStream(CopyIn copyIn) {
        this.copyIn = copyIn;
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException("please use void write(byte b[], int off, int len)");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try {
            this.copyIn.writeToCopy(b, off, len);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.copyIn.flushCopy();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getResult() {
        return this.result;
    }

    @Override
    public void close() throws IOException {
        try {
            this.result = this.copyIn.endCopy();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

