/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client;

import com.alibaba.hologres.client.impl.binlog.BinlogOffset;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;

public class Subscribe {
    private final String tableName;
    private final String slotName;
    private final Map<Integer, BinlogOffset> offsetMap;
    private final String binlogReadStartTime;

    protected Subscribe(String tableName, String slotName, Map<Integer, BinlogOffset> offsetMap, String binlogReadStartTime) {
        this.tableName = tableName;
        this.slotName = slotName;
        this.offsetMap = offsetMap;
        this.binlogReadStartTime = binlogReadStartTime;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public Map<Integer, BinlogOffset> getOffsetMap() {
        return this.offsetMap;
    }

    public String getBinlogReadStartTime() {
        return this.binlogReadStartTime;
    }

    public static OffsetBuilder newOffsetBuilder(String tableName, String slotName) {
        return new OffsetBuilder(tableName, slotName);
    }

    public static OffsetBuilder newOffsetBuilder(String tableName) {
        return new OffsetBuilder(tableName);
    }

    public static StartTimeBuilder newStartTimeBuilder(String tableName, String slotName) {
        return new StartTimeBuilder(tableName, slotName);
    }

    public static StartTimeBuilder newStartTimeBuilder(String tableName) {
        return new StartTimeBuilder(tableName);
    }

    public static class StartTimeBuilder
    extends Builder {
        private String binlogReadStartTime;

        public StartTimeBuilder(String tableName, String slotName) {
            super(tableName, slotName);
        }

        public StartTimeBuilder(String tableName) {
            super(tableName);
        }

        public StartTimeBuilder setBinlogReadStartTime(String binlogReadStartTime) {
            this.binlogReadStartTime = binlogReadStartTime;
            return this;
        }

        public Subscribe build() {
            return new Subscribe(this.tableName, this.slotName, null, this.binlogReadStartTime);
        }
    }

    public static class OffsetBuilder
    extends Builder {
        private Map<Integer, BinlogOffset> offsetMap;

        public OffsetBuilder(String tableName, String slotName) {
            super(tableName, slotName);
        }

        public OffsetBuilder(String tableName) {
            super(tableName);
        }

        public OffsetBuilder addShardStartOffset(int shardId, BinlogOffset offset) {
            if (this.offsetMap == null) {
                this.offsetMap = new HashMap<Integer, BinlogOffset>();
            }
            this.offsetMap.putIfAbsent(shardId, offset);
            return this;
        }

        public Subscribe build() {
            if (this.offsetMap == null) {
                throw new InvalidParameterException("must call addShardStartOffset before build");
            }
            return new Subscribe(this.tableName, this.slotName, this.offsetMap, null);
        }
    }

    public static abstract class Builder {
        protected final String tableName;
        protected final String slotName;

        public Builder(String tableName) {
            if (tableName == null) {
                throw new InvalidParameterException("tableName must be not null");
            }
            this.tableName = tableName;
            this.slotName = null;
        }

        public Builder(String tableName, String slotName) {
            if (tableName == null) {
                throw new InvalidParameterException("tableName must be not null");
            }
            this.tableName = tableName;
            this.slotName = slotName;
        }
    }
}

