/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client;

import com.alibaba.hologres.client.impl.collector.shard.DistributionKeyShardPolicy;
import com.alibaba.hologres.client.impl.collector.shard.ShardPolicy;
import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.ImportContext;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.org.postgresql.jdbc.ArrayUtil;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;

public class RecordOutputFormat
implements Closeable {
    private static final int DEFAULT_MAX_CELL_BUFFER_SIZE = 0x200000;
    private static final int QUOTE = 34;
    private static final int ESCAPE = 92;
    private static final int NULL = 78;
    private static final int DELIMITER = 44;
    private static final int NEWLINE = 10;
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final TableSchema schema;
    private static final String ESCAPE_STR = '\\' + String.valueOf('\\');
    private static final String ESCAPE_REPLACE_STR = ESCAPE_STR + ESCAPE_STR;
    private static final String QUOTE_STR = String.valueOf('\"');
    private static final String QUOTE_REPLACE_STR = ESCAPE_STR + QUOTE_STR;
    private final int maxCellBufferSize;
    private final TimestampUtils timestampUtils;
    private final ImportContext importContext;
    private ShardPolicy policy;
    boolean closed = false;
    ByteBuffer cellBuffer = ByteBuffer.allocate(1024);
    Record currentRecord = null;
    int currentColumnIndex;

    public RecordOutputFormat(ImportContext importContext, TableSchema schema) throws IOException {
        this(importContext, schema, 0x200000);
    }

    public RecordOutputFormat(ImportContext importContext, TableSchema schema, int maxCellBufferSize) throws IOException {
        this.importContext = importContext;
        this.schema = schema;
        this.maxCellBufferSize = maxCellBufferSize;
        this.timestampUtils = importContext.getTimestampUtils();
        this.policy = new DistributionKeyShardPolicy();
        this.policy.init(importContext.getShardCount());
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.importContext.closeOstreams();
    }

    public void putRecord(Record record) throws IOException {
        if (this.closed) {
            throw new IOException("RecordOutputFormat already closed");
        }
        int shardId = this.policy.locate(record);
        this.fillByteBuffer(record);
        this.cellBuffer.flip();
        this.importContext.getOutputStream(shardId).write(this.cellBuffer.array(), this.cellBuffer.position(), this.cellBuffer.remaining());
        this.cellBuffer.clear();
    }

    private void fillByteBuffer(Record record) throws IOException {
        for (int i = 0; i < record.getSchema().getColumnSchema().length; ++i) {
            if (i > 0) {
                this.write(44);
            }
            Column column = record.getSchema().getColumn(i);
            int type = column.getType();
            Object obj = record.getObject(i);
            if (obj == null) {
                this.write(78);
                continue;
            }
            boolean quote = false;
            byte[] temp = null;
            String text = null;
            try {
                switch (type) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        text = String.valueOf(obj);
                        quote = true;
                        text = text.replaceAll(ESCAPE_STR, ESCAPE_REPLACE_STR).replaceAll(QUOTE_STR, QUOTE_REPLACE_STR);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2013: 
                    case 2014: {
                        if (obj instanceof Time) {
                            text = this.timestampUtils.toString(null, (Time)obj);
                            break;
                        }
                        if (obj instanceof Timestamp) {
                            text = this.timestampUtils.toString(null, (Timestamp)obj);
                            break;
                        }
                        if (obj instanceof Date) {
                            text = this.timestampUtils.toString(null, (Date)obj);
                            break;
                        }
                        if (obj instanceof java.util.Date) {
                            text = this.timestampUtils.toString(null, new Timestamp(((java.util.Date)obj).getTime()));
                            break;
                        }
                        text = String.valueOf(obj);
                        break;
                    }
                    case 2003: {
                        text = obj.getClass().getComponentType() != null ? ArrayUtil.arrayToString(obj) : String.valueOf(obj);
                        text = text.replaceAll(ESCAPE_STR, ESCAPE_REPLACE_STR).replaceAll(QUOTE_STR, QUOTE_REPLACE_STR);
                        quote = true;
                        break;
                    }
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        text = String.valueOf(obj);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 1111: 
                    case 2004: {
                        if (obj instanceof byte[]) {
                            byte[] bytes = (byte[])obj;
                            StringBuffer sb = new StringBuffer(2 + bytes.length);
                            sb.append("\\x");
                            for (int j = 0; j < bytes.length; ++j) {
                                String hex = Integer.toHexString(bytes[j] & 0xFF);
                                if (hex.length() < 2) {
                                    sb.append(0);
                                }
                                sb.append(hex);
                            }
                            text = sb.toString();
                            break;
                        }
                        text = String.valueOf(obj);
                        break;
                    }
                    case -7: 
                    case 16: {
                        text = String.valueOf(obj);
                        break;
                    }
                    default: {
                        throw new IOException("unsupported type " + type + " type name:" + column.getTypeName());
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("fill byteBuffer " + column.getName() + " fail.index:" + this.currentRecord + " record:" + this.currentRecord + ", bytes:" + (temp != null ? Arrays.toString(temp) : "null") + ", text:" + text, e);
            }
            if (quote) {
                this.write(34);
                this.write(text.getBytes(UTF8));
                this.write(34);
                continue;
            }
            this.write(text.getBytes(UTF8));
        }
        this.write(10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write(int r) throws IOException {
        if (this.cellBuffer.remaining() == 0) {
            if (this.cellBuffer.position() >= 0x200000) throw new IOException("RecordInputStream cellBuffer exceed max cell size " + this.maxCellBufferSize + " for column " + this.schema.getColumn(this.currentColumnIndex).getName());
            int target = Math.min(this.cellBuffer.position() * 2, this.maxCellBufferSize);
            ByteBuffer temp = ByteBuffer.allocate(target);
            temp.put(this.cellBuffer);
            this.cellBuffer.clear();
            this.cellBuffer = temp;
            return;
        } else {
            this.cellBuffer.put((byte)(r & 0xFF));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write(byte[] bytes) throws IOException {
        if (this.cellBuffer.remaining() < bytes.length) {
            if (this.cellBuffer.position() + bytes.length >= this.maxCellBufferSize) throw new IOException("RecordInputStream cellBuffer exceed max cell size " + this.maxCellBufferSize + " for column " + this.schema.getColumn(this.currentColumnIndex).getName());
            int target = Math.max(this.cellBuffer.position() + bytes.length, Math.min(this.cellBuffer.position() * 2, this.maxCellBufferSize));
            ByteBuffer temp = ByteBuffer.allocate(target);
            temp.put(this.cellBuffer);
            this.cellBuffer.clear();
            this.cellBuffer = temp;
            return;
        } else {
            this.cellBuffer.put(bytes);
        }
    }
}

