/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.memory;

import com.alibaba.blink.memory.DataInputView;
import com.alibaba.blink.memory.DataOutputView;
import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.memory.MemorySegmentWritable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DataOutputViewStreamWrapper
extends DataOutputStream
implements DataOutputView {
    private byte[] tempBuffer;

    public DataOutputViewStreamWrapper(OutputStream out) {
        super(out);
    }

    @Override
    public void skipBytesToWrite(int numBytes) throws IOException {
        if (this.tempBuffer == null) {
            this.tempBuffer = new byte[4096];
        }
        while (numBytes > 0) {
            int toWrite = Math.min(numBytes, this.tempBuffer.length);
            this.write(this.tempBuffer, 0, toWrite);
            numBytes -= toWrite;
        }
    }

    @Override
    public void write(DataInputView source, int numBytes) throws IOException {
        if (this.tempBuffer == null) {
            this.tempBuffer = new byte[4096];
        }
        while (numBytes > 0) {
            int toCopy = Math.min(numBytes, this.tempBuffer.length);
            source.readFully(this.tempBuffer, 0, toCopy);
            this.write(this.tempBuffer, 0, toCopy);
            numBytes -= toCopy;
        }
    }

    @Override
    public void write(MemorySegment segment, int off, int len) throws IOException {
        if (this.out instanceof MemorySegmentWritable) {
            ((MemorySegmentWritable)((Object)this.out)).write(segment, off, len);
        } else {
            int toCopy;
            if (this.tempBuffer == null) {
                this.tempBuffer = new byte[4096];
            }
            for (int remain = len; remain > 0; remain -= toCopy) {
                toCopy = Math.min(remain, this.tempBuffer.length);
                segment.get(len - remain + off, this.tempBuffer, 0, toCopy);
                this.write(this.tempBuffer, 0, toCopy);
            }
        }
    }
}

