/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.hive.output;

import com.alibaba.hologres.client.Put;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.hive.HoloClientProvider;
import com.alibaba.hologres.hive.HoloRecordWritable;
import com.alibaba.hologres.hive.conf.HoloClientParam;
import com.alibaba.hologres.hive.exception.HiveHoloStorageException;
import com.alibaba.hologres.hive.utils.JDBCUtils;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoloRecordWriter
implements FileSinkOperator.RecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(HoloRecordWriter.class);
    HoloClientProvider clientProvider;
    TableSchema schema;

    public HoloRecordWriter(HoloClientParam param, TaskAttemptContext context) throws IOException {
        this.clientProvider = new HoloClientProvider(param);
        this.schema = this.clientProvider.getTableSchema();
    }

    public void write(Writable writable) throws IOException {
        if (!(writable instanceof HoloRecordWritable)) {
            throw new IOException("Expected HoloRecordWritable. Got " + writable.getClass().getName());
        }
        HoloRecordWritable record = (HoloRecordWritable)writable;
        try {
            Put put = new Put(this.schema);
            record.write(put);
            this.clientProvider.createOrGetClient().put(put);
        }
        catch (HoloClientException | HiveHoloStorageException e) {
            if (this.clientProvider != null) {
                this.clientProvider.closeClient();
            }
            JDBCUtils.logErrorAndExceptionInConsole(String.format("failed while write values %s, because:", Arrays.toString(record.getColumnValues())), e);
            throw new IOException(e);
        }
    }

    public void close(boolean b) {
        if (this.clientProvider != null) {
            this.clientProvider.closeClient();
        }
    }
}

