/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.hive.conf;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.model.WriteFailStrategy;
import com.alibaba.hologres.client.model.WriteMode;
import com.alibaba.hologres.hive.conf.HoloStorageConfig;
import com.alibaba.hologres.hive.utils.JDBCUtils;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;

public class HoloClientParam {
    private String tableName;
    private String url;
    private String username;
    private String password;
    private final boolean copyWriteMode;
    private final String copyWriteFormat;
    private boolean bulkLoad;
    private final boolean dirtyDataCheck;
    private boolean directConnect;
    private final int maxWriterNumber;
    private int maxCellBufferSize;
    private final int maxWriterNumberPerTask;
    private int hologresFrontendsNumber = 0;
    private final int writeBatchSize;
    private final long writeBatchByteSize;
    private final WriteMode writeMode;
    private final WriteFailStrategy writeFailStrategy;
    private final long writeMaxIntervalMs;
    private final int writeThreadSize;
    private final boolean dynamicPartition;
    private final boolean useLegacyPutHandler;
    private final int readBatchSize;
    private final int readThreadSize;
    private final int readBatchQueueSize;
    private final int scanFetchSize;
    private final int scanTimeoutSeconds;
    private final boolean copyScanMode;
    private final int retryCount;
    private final long retrySleepInitMs;
    private final long retrySleepStepMs;
    private final long connectionMaxIdleMs;
    private final boolean fixedConnectionMode;

    public HoloClientParam(Configuration conf, Properties props) {
        this(conf);
        this.url = props.getProperty(HoloStorageConfig.JDBC_URL.getPropertyName());
        if (this.url.startsWith("jdbc:postgresql:")) {
            this.url = "jdbc:hologres:" + this.url.substring("jdbc:postgresql:".length());
        }
        this.tableName = props.getProperty(HoloStorageConfig.TABLE.getPropertyName());
        this.username = props.getProperty(HoloStorageConfig.USERNAME.getPropertyName());
        this.password = props.getProperty(HoloStorageConfig.PASSWORD.getPropertyName());
    }

    public HoloClientParam(Configuration conf, Map<String, String> parameters) {
        this(conf);
        this.url = parameters.get(HoloStorageConfig.JDBC_URL.getPropertyName());
        if (this.url.startsWith("jdbc:postgresql:")) {
            this.url = "jdbc:hologres:" + this.url.substring("jdbc:postgresql:".length());
        }
        this.tableName = parameters.get(HoloStorageConfig.TABLE.getPropertyName());
    }

    public HoloClientParam(Configuration conf) {
        String wFailStrategy;
        String wMode;
        this.tableName = conf.get(HoloStorageConfig.TABLE.getPropertyName());
        this.url = JDBCUtils.formatUrlWithHologres(conf.get(HoloStorageConfig.JDBC_URL.getPropertyName()));
        this.username = conf.get(HoloStorageConfig.USERNAME.getPropertyName());
        this.password = conf.get(HoloStorageConfig.PASSWORD.getPropertyName());
        this.copyWriteMode = conf.getBoolean(HoloStorageConfig.COPY_WRITE_MODE.getPropertyName(), true);
        this.copyWriteFormat = conf.get(HoloStorageConfig.COPY_WRITE_FORMAT.getPropertyName(), "binary");
        this.bulkLoad = conf.getBoolean(HoloStorageConfig.BULK_LOAD.getPropertyName(), false);
        this.dirtyDataCheck = conf.getBoolean(HoloStorageConfig.DIRTY_DATA_CHECK.getPropertyName(), false);
        this.directConnect = conf.getBoolean(HoloStorageConfig.DIRECT_CONNECT.getPropertyName(), true);
        this.maxWriterNumber = conf.getInt(HoloStorageConfig.MAX_WRITER_NUMBER.getPropertyName(), 20);
        this.maxWriterNumberPerTask = conf.getInt(HoloStorageConfig.MAX_WRITER_NUMBER_PER_TASK.getPropertyName(), 3);
        this.maxCellBufferSize = conf.getInt(HoloStorageConfig.MAX_CELL_BUFFER_SIZE.getPropertyName(), 0x1400000);
        this.writeBatchSize = conf.getInt(HoloStorageConfig.WRITE_BATCH_SIZE.getPropertyName(), 512);
        this.writeBatchByteSize = conf.getLong(HoloStorageConfig.WRITE_BATCH_BYTE_SIZE.getPropertyName(), 0x200000L);
        this.writeMaxIntervalMs = conf.getLong(HoloStorageConfig.WRITE_MAX_INTERVAL_MS.getPropertyName(), 10000L);
        this.writeThreadSize = conf.getInt(HoloStorageConfig.WRITE_THREAD_SIZE.getPropertyName(), 1);
        this.dynamicPartition = conf.getBoolean(HoloStorageConfig.DYNAMIC_PARTITION.getPropertyName(), false);
        this.useLegacyPutHandler = conf.getBoolean(HoloStorageConfig.USE_LEGACY_PUT_HANDLER.getPropertyName(), false);
        switch (wMode = conf.get(HoloStorageConfig.WRITE_MODE.getPropertyName(), "INSERT_OR_REPLACE").toLowerCase()) {
            case "insert_or_replace": {
                this.writeMode = WriteMode.INSERT_OR_REPLACE;
                break;
            }
            case "insert_or_ignore": {
                this.writeMode = WriteMode.INSERT_OR_IGNORE;
                break;
            }
            case "insert_or_update": {
                this.writeMode = WriteMode.INSERT_OR_UPDATE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not recognize writeMode " + wMode);
            }
        }
        switch (wFailStrategy = conf.get(HoloStorageConfig.WRITE_FAIL_STRATEGY.getPropertyName(), "TRY_ONE_BY_ONE").toLowerCase()) {
            case "try_one_by_one": {
                this.writeFailStrategy = WriteFailStrategy.TRY_ONE_BY_ONE;
                break;
            }
            case "none": {
                this.writeFailStrategy = WriteFailStrategy.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not recognize writeFailStrategy " + wFailStrategy);
            }
        }
        this.readBatchSize = conf.getInt(HoloStorageConfig.READ_BATCH_SIZE.getPropertyName(), 128);
        this.readThreadSize = conf.getInt(HoloStorageConfig.READ_THREAD_SIZE.getPropertyName(), 1);
        this.readBatchQueueSize = conf.getInt(HoloStorageConfig.READ_BATCH_QUEUE_SIZE.getPropertyName(), 256);
        this.scanFetchSize = conf.getInt(HoloStorageConfig.SCAN_FETCH_SIZE.getPropertyName(), 2000);
        this.scanTimeoutSeconds = conf.getInt(HoloStorageConfig.SCAN_TIMEOUT_SECONDS.getPropertyName(), 60);
        this.copyScanMode = conf.getBoolean(HoloStorageConfig.COPY_SCAN_MODE.getPropertyName(), false) || conf.getBoolean(HoloStorageConfig.COPY_MODE.getPropertyName(), false);
        this.retryCount = conf.getInt(HoloStorageConfig.RETRY_COUNT.getPropertyName(), 3);
        this.retrySleepInitMs = conf.getLong(HoloStorageConfig.RETRY_SLEEP_INIT_MS.getPropertyName(), 1000L);
        this.retrySleepStepMs = conf.getLong(HoloStorageConfig.RETRY_SLEEP_STEP_MS.getPropertyName(), 10000L);
        this.connectionMaxIdleMs = conf.getLong(HoloStorageConfig.CONNECTION_MAX_IDLE_MS.getPropertyName(), 60000L);
        this.fixedConnectionMode = conf.getBoolean(HoloStorageConfig.FIXED_CONNECTION_MODE.getPropertyName(), false);
    }

    public HoloConfig generateHoloConfig() {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("Table name should be defined");
        }
        if (this.url == null || this.url.isEmpty()) {
            throw new IllegalArgumentException("Url should be defined");
        }
        if (this.username == null || this.username.isEmpty()) {
            throw new IllegalArgumentException("username should be defined");
        }
        if (this.password == null || this.password.isEmpty()) {
            throw new IllegalArgumentException("password should be defined");
        }
        HoloConfig holoConfig = new HoloConfig();
        holoConfig.setJdbcUrl(this.url);
        holoConfig.setUsername(this.username);
        holoConfig.setPassword(this.password);
        holoConfig.setWriteMode(this.writeMode);
        holoConfig.setWriteFailStrategy(this.writeFailStrategy);
        holoConfig.setWriteBatchSize(this.writeBatchSize);
        holoConfig.setWriteBatchByteSize(this.writeBatchByteSize);
        holoConfig.setWriteMaxIntervalMs(this.writeMaxIntervalMs);
        holoConfig.setWriteThreadSize(this.writeThreadSize);
        holoConfig.setDynamicPartition(this.dynamicPartition);
        holoConfig.setUseLegacyPutHandler(this.useLegacyPutHandler);
        holoConfig.setUseFixedFe(this.fixedConnectionMode);
        holoConfig.setRetryCount(this.retryCount);
        holoConfig.setRetrySleepInitMs(this.retrySleepInitMs);
        holoConfig.setRetrySleepStepMs(this.retrySleepStepMs);
        holoConfig.setConnectionMaxIdleMs(this.connectionMaxIdleMs);
        holoConfig.setReadBatchSize(this.readBatchSize);
        holoConfig.setReadThreadSize(this.readThreadSize);
        holoConfig.setReadBatchQueueSize(this.readBatchQueueSize);
        holoConfig.setScanFetchSize(this.scanFetchSize);
        holoConfig.setScanTimeoutSeconds(this.scanTimeoutSeconds);
        holoConfig.setAppName("hologres-connector-hive");
        return holoConfig;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    public String getCopyWriteFormat() {
        return this.copyWriteFormat;
    }

    public boolean isCopyWriteMode() {
        return this.copyWriteMode;
    }

    public boolean isBulkLoad() {
        return this.bulkLoad;
    }

    public void setBulkLoad(boolean bulkLoad) {
        this.bulkLoad = bulkLoad;
    }

    public boolean isDirtyDataCheck() {
        return this.dirtyDataCheck;
    }

    public boolean isDirectConnect() {
        return this.directConnect;
    }

    public void setDirectConnect(boolean directConnect) {
        this.directConnect = directConnect;
    }

    public int getMaxWriterNumber() {
        return this.maxWriterNumber;
    }

    public int getMaxCellBufferSize() {
        return this.maxCellBufferSize;
    }

    public int getMaxWriterNumberPerTask() {
        return this.maxWriterNumberPerTask;
    }

    public int getHologresFrontendsNumber() {
        return this.hologresFrontendsNumber;
    }

    public void setHologresFrontendsNumber(int hologresFrontendNumber) {
        this.hologresFrontendsNumber = hologresFrontendNumber;
    }

    public boolean isCopyScanMode() {
        return this.copyScanMode;
    }

    public int getScanFetchSize() {
        return this.scanFetchSize;
    }

    public int getScanTimeoutSeconds() {
        return this.scanTimeoutSeconds;
    }
}

