/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.hive;

import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.hive.HoloClientProvider;
import com.alibaba.hologres.hive.HoloRecordWritable;
import com.alibaba.hologres.hive.conf.HoloClientParam;
import com.alibaba.hologres.hive.utils.DataTypeUtils;
import com.alibaba.hologres.hive.utils.JDBCUtils;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyArray;
import org.apache.hadoop.hive.serde2.lazy.LazyBinary;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryBinary;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoloSerDe
extends AbstractSerDe {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoloSerDe.class);
    HoloRecordWritable dbRecordWritable;
    private StructObjectInspector objectInspector;
    private int hiveColumnCount;
    private String[] hiveColumnNames;
    private Column[] holoColumns;
    private List<Object> row;
    private TypeInfo[] hiveColumnTypes;

    public void initialize(Configuration conf, Properties props) throws SerDeException {
        HoloClientParam param = new HoloClientParam(conf, props);
        HoloClientProvider clientProvider = new HoloClientProvider(param);
        try {
            TableSchema schema = clientProvider.getTableSchema();
            this.holoColumns = schema.getColumnSchema();
            this.hiveColumnNames = this.parseProperty(props.getProperty("columns"), ",");
            this.hiveColumnCount = this.hiveColumnNames.length;
            if (this.holoColumns.length < this.hiveColumnCount) {
                throw new SerDeException(String.format("Table definition has %s columns, could not greater than Hologres table %s has %d columns.", this.hiveColumnCount, schema.getTableName(), this.holoColumns.length));
            }
            String[] hiveColumnTypeArray = this.parseProperty(props.getProperty("columns.types"), ":");
            if (hiveColumnTypeArray.length == 0) {
                throw new SerDeException("Received an empty Hive column type definition");
            }
            ArrayList hiveColumnTypesList = TypeInfoUtils.getTypeInfosFromTypeString((String)props.getProperty("columns.types"));
            this.hiveColumnTypes = new TypeInfo[hiveColumnTypesList.size()];
            ArrayList<Object> fieldInspectors = new ArrayList<Object>(this.hiveColumnCount);
            for (int i = 0; i < this.hiveColumnCount; ++i) {
                TypeInfo ti = (TypeInfo)hiveColumnTypesList.get(i);
                if (ti.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                    fieldInspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)ti)));
                } else if (ti.getCategory() == ObjectInspector.Category.LIST) {
                    fieldInspectors.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)((ListTypeInfo)ti).getListElementTypeInfo()))));
                } else {
                    throw new SerDeException(String.format("Non primitive type or array type %s not supported yet, column name %s", ti.getTypeName(), this.hiveColumnNames[i]));
                }
                this.hiveColumnTypes[i] = ti;
            }
            this.validateColumns(schema, this.hiveColumnNames, this.hiveColumnTypes);
            this.objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList(this.hiveColumnNames), fieldInspectors);
            this.row = new ArrayList<Object>(this.hiveColumnCount);
            this.dbRecordWritable = new HoloRecordWritable(this.hiveColumnCount, this.hiveColumnNames);
        }
        catch (Exception e) {
            JDBCUtils.logErrorAndExceptionInConsole("Caught exception while initializing the SqlSerDe", e);
            throw new RuntimeException(e);
        }
        finally {
            clientProvider.closeClient();
        }
    }

    private void validateColumns(TableSchema schema, String[] hiveColumnNames, TypeInfo[] hiveColumnTypes) {
        for (int i = 0; i < this.hiveColumnCount; ++i) {
            Column holoColumn;
            String columnName = hiveColumnNames[i];
            try {
                holoColumn = schema.getColumn(schema.getColumnIndex(columnName));
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException(String.format("Column %s does not exist in hologres!", columnName));
            }
            boolean matched = false;
            if (holoColumn.getType() == 2003) {
                String arrayElementTypeName = ((ListTypeInfo)hiveColumnTypes[i]).getListElementTypeInfo().getTypeName();
                switch (holoColumn.getTypeName()) {
                    case "_int4": {
                        matched = "int".equals(arrayElementTypeName);
                        break;
                    }
                    case "_int8": {
                        matched = "bigint".equals(arrayElementTypeName);
                        break;
                    }
                    case "_float4": {
                        matched = "float".equals(arrayElementTypeName);
                        break;
                    }
                    case "_float8": {
                        matched = "double".equals(arrayElementTypeName);
                        break;
                    }
                    case "_bool": {
                        matched = "boolean".equals(arrayElementTypeName);
                        break;
                    }
                    case "_varchar": 
                    case "_text": {
                        matched = "string".equals(arrayElementTypeName);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Does not support array element type %s , column name %s!", arrayElementTypeName, hiveColumnNames[i]));
                    }
                }
            } else {
                PrimitiveObjectInspector.PrimitiveCategory columnType = ((PrimitiveTypeInfo)hiveColumnTypes[i]).getPrimitiveCategory();
                block18 : switch (holoColumn.getType()) {
                    case -6: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.BYTE;
                        break;
                    }
                    case 5: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.SHORT;
                        break;
                    }
                    case 4: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.INT;
                        break;
                    }
                    case -5: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.LONG;
                        break;
                    }
                    case 6: 
                    case 7: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.FLOAT;
                        break;
                    }
                    case 8: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.DOUBLE;
                        break;
                    }
                    case 2: 
                    case 3: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL;
                        break;
                    }
                    case -7: 
                    case 16: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN;
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.STRING;
                        break;
                    }
                    case 91: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.DATE;
                        break;
                    }
                    case 93: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP;
                        break;
                    }
                    case -3: 
                    case -2: {
                        matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.BINARY;
                        break;
                    }
                    case 1111: {
                        switch (holoColumn.getTypeName()) {
                            case "json": 
                            case "jsonb": {
                                matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.STRING;
                                break block18;
                            }
                            case "roaringbitmap": {
                                matched = columnType == PrimitiveObjectInspector.PrimitiveCategory.BINARY;
                                break block18;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Does not support column %s with data type %s and hologres type %s for now!", columnName, columnType, holoColumn.getTypeName()));
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Does not support column %s with data type %s and hologres type %s for now!", columnName, columnType, holoColumn.getTypeName()));
                    }
                }
            }
            if (matched) continue;
            throw new IllegalArgumentException(String.format("Column %s with data type %s does not match the hologres data type!", columnName, hiveColumnTypes[i].getTypeName()));
        }
    }

    private String[] parseProperty(String propertyValue, String delimiter) {
        if (propertyValue == null || propertyValue.trim().isEmpty()) {
            return new String[0];
        }
        return propertyValue.split(delimiter);
    }

    public Object deserialize(Writable blob) throws SerDeException {
        LOGGER.debug("Deserializing from SerDe");
        if (!(blob instanceof MapWritable)) {
            throw new SerDeException("Expected MapWritable. Got " + blob.getClass().getName());
        }
        if (this.row == null || this.hiveColumnTypes == null) {
            throw new SerDeException("Holo SerDe has no columns to deserialize");
        }
        this.row.clear();
        MapWritable input = (MapWritable)blob;
        Text columnKey = new Text();
        block16: for (int i = 0; i < this.hiveColumnCount; ++i) {
            columnKey.set(this.hiveColumnNames[i]);
            Writable value = input.get((Object)columnKey);
            if (value == NullWritable.get()) {
                this.row.add(null);
                continue;
            }
            if (this.hiveColumnTypes[i].getCategory() == ObjectInspector.Category.LIST) {
                String arrayElementTypeName;
                switch (arrayElementTypeName = ((ListTypeInfo)this.hiveColumnTypes[i]).getListElementTypeInfo().getTypeName()) {
                    default: 
                }
                throw new IllegalArgumentException(String.format("Does not support read array now, array element type %s , column name %s!", arrayElementTypeName, this.hiveColumnNames[i]));
            }
            PrimitiveObjectInspector.PrimitiveCategory columnType = ((PrimitiveTypeInfo)this.hiveColumnTypes[i]).getPrimitiveCategory();
            switch (columnType) {
                case BYTE: {
                    this.row.add(Byte.valueOf(value.toString()));
                    continue block16;
                }
                case SHORT: {
                    this.row.add(Short.valueOf(value.toString()));
                    continue block16;
                }
                case INT: {
                    this.row.add(Integer.valueOf(value.toString()));
                    continue block16;
                }
                case LONG: {
                    this.row.add(Long.valueOf(value.toString()));
                    continue block16;
                }
                case FLOAT: {
                    this.row.add(Float.valueOf(value.toString()));
                    continue block16;
                }
                case DOUBLE: {
                    this.row.add(Double.valueOf(value.toString()));
                    continue block16;
                }
                case DECIMAL: {
                    this.row.add(new HiveDecimalWritable(value.toString()).getHiveDecimal());
                    continue block16;
                }
                case BOOLEAN: {
                    this.row.add(Boolean.valueOf(value.toString()));
                    continue block16;
                }
                case CHAR: 
                case VARCHAR: 
                case STRING: {
                    this.row.add(String.valueOf(value.toString()));
                    continue block16;
                }
                case DATE: {
                    this.row.add(Date.valueOf(value.toString()));
                    continue block16;
                }
                case TIMESTAMP: {
                    this.row.add(Timestamp.valueOf(value.toString()));
                    continue block16;
                }
                case BINARY: {
                    this.row.add(value.toString().getBytes(StandardCharsets.UTF_8));
                    continue block16;
                }
                default: {
                    throw new SerDeException(String.format("hologres connector not support type %s, column name %s", columnType.name(), this.hiveColumnNames[i]));
                }
            }
        }
        return this.row;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return MapWritable.class;
    }

    public HoloRecordWritable serialize(Object row, ObjectInspector objInspector) throws SerDeException {
        LOGGER.trace("Serializing from SerDe");
        if (row == null || this.hiveColumnTypes == null) {
            throw new SerDeException("Holo SerDe has no columns to serialize");
        }
        if (((Object[])row).length != this.hiveColumnCount) {
            throw new SerDeException(String.format("Required %d columns, received %d.", this.hiveColumnCount, ((Object[])row).length));
        }
        this.dbRecordWritable.clear();
        for (int i = 0; i < this.hiveColumnCount; ++i) {
            Object rowData = ((Object[])row)[i];
            if (null != rowData) {
                if (this.hiveColumnTypes[i].getCategory() == ObjectInspector.Category.LIST) {
                    String arrayElementTypeName = ((ListTypeInfo)this.hiveColumnTypes[i]).getListElementTypeInfo().getTypeName();
                    if (rowData instanceof LazyBinaryArray) {
                        rowData = ((LazyBinaryArray)rowData).getList();
                    } else if (rowData instanceof LazyArray) {
                        rowData = ((LazyArray)rowData).getList();
                    } else if (!(rowData instanceof ArrayList)) {
                        throw new IllegalArgumentException(String.format("Does not support array class %s, this array type is %s , column name is %s!", rowData.getClass(), arrayElementTypeName, this.hiveColumnNames[i]));
                    }
                    switch (arrayElementTypeName) {
                        case "int": {
                            rowData = DataTypeUtils.castIntWritableArrayListToArray(rowData);
                            break;
                        }
                        case "bigint": {
                            rowData = DataTypeUtils.castLongWritableArrayListToArray(rowData);
                            break;
                        }
                        case "float": {
                            rowData = DataTypeUtils.castFloatWritableArrayListToArray(rowData);
                            break;
                        }
                        case "double": {
                            rowData = DataTypeUtils.castDoubleWritableArrayListToArray(rowData);
                            break;
                        }
                        case "boolean": {
                            rowData = DataTypeUtils.castBooleanWritableArrayListToArray(rowData);
                            break;
                        }
                        case "string": {
                            rowData = DataTypeUtils.castHiveTextArrayListToArray(rowData);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("Does not support array element type %s , column name %s!", arrayElementTypeName, this.hiveColumnNames[i]));
                        }
                    }
                } else {
                    PrimitiveObjectInspector.PrimitiveCategory columnType = ((PrimitiveTypeInfo)this.hiveColumnTypes[i]).getPrimitiveCategory();
                    switch (columnType) {
                        case INT: {
                            rowData = Integer.valueOf(rowData.toString());
                            break;
                        }
                        case SHORT: {
                            rowData = Short.valueOf(rowData.toString());
                            break;
                        }
                        case BYTE: {
                            rowData = Byte.valueOf(rowData.toString());
                            break;
                        }
                        case LONG: {
                            rowData = Long.valueOf(rowData.toString());
                            break;
                        }
                        case FLOAT: {
                            rowData = Float.valueOf(rowData.toString());
                            break;
                        }
                        case DOUBLE: {
                            rowData = Double.valueOf(rowData.toString());
                            break;
                        }
                        case DECIMAL: {
                            rowData = new HiveDecimalWritable(rowData.toString()).getHiveDecimal().bigDecimalValue();
                            break;
                        }
                        case BOOLEAN: {
                            rowData = Boolean.valueOf(rowData.toString());
                            break;
                        }
                        case CHAR: 
                        case VARCHAR: 
                        case STRING: {
                            rowData = String.valueOf(rowData.toString());
                            break;
                        }
                        case DATE: {
                            rowData = Date.valueOf(rowData.toString());
                            break;
                        }
                        case TIMESTAMP: {
                            rowData = Timestamp.valueOf(rowData.toString());
                            break;
                        }
                        case BINARY: {
                            if (rowData instanceof BytesWritable) {
                                rowData = ((BytesWritable)rowData).getBytes();
                                break;
                            }
                            if (rowData instanceof LazyBinary) {
                                rowData = ((BytesWritable)((LazyBinary)rowData).getWritableObject()).getBytes();
                                break;
                            }
                            if (rowData instanceof LazyBinaryBinary) {
                                rowData = ((BytesWritable)((LazyBinaryBinary)rowData).getWritableObject()).getBytes();
                                break;
                            }
                            throw new SerDeException(String.format("hologres connector SerDe need binary field instance BytesWritable/LazyBinary/LazyBinaryBinary but is was %s", rowData.getClass()));
                        }
                        default: {
                            throw new SerDeException(String.format("hologres connector not support type %s, column name %s", columnType.name(), this.hiveColumnNames[i]));
                        }
                    }
                }
            }
            this.dbRecordWritable.set(i, rowData);
        }
        return this.dbRecordWritable;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

