/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.hive;

import com.alibaba.hologres.client.HoloClient;
import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.model.TableName;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.hive.conf.HoloClientParam;
import com.alibaba.hologres.hive.utils.JDBCUtils;

public class HoloClientProvider {
    private final HoloClientParam param;
    private HoloClient client;

    public HoloClientProvider(HoloClientParam param) {
        this.param = param;
    }

    public void closeClient() {
        if (this.client == null) {
            return;
        }
        try {
            this.client.flush();
        }
        catch (HoloClientException e) {
            JDBCUtils.logErrorAndExceptionInConsole("Failed to close client", e);
            throw new RuntimeException("Failed to close client", e);
        }
        finally {
            this.client.close();
        }
        this.client = null;
    }

    public HoloClient createOrGetClient() {
        if (this.client == null) {
            HoloConfig holoConfig = this.param.generateHoloConfig();
            try {
                this.client = new HoloClient(holoConfig);
            }
            catch (HoloClientException e) {
                JDBCUtils.logErrorAndExceptionInConsole("create holo client failed", e);
                throw new RuntimeException("create holo client failed", e);
            }
        }
        return this.client;
    }

    public TableSchema getTableSchema() {
        if (this.client == null) {
            this.createOrGetClient();
        }
        try {
            return this.client.getTableSchema(TableName.valueOf(this.param.getTableName()));
        }
        catch (HoloClientException e) {
            JDBCUtils.logErrorAndExceptionInConsole(String.format("get table %s schema failed", this.param.getTableName()), e);
            throw new RuntimeException(String.format("get table %s schema failed", this.param.getTableName()), e);
        }
    }
}

