/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.hive;

import com.alibaba.hologres.hive.HoloSerDe;
import com.alibaba.hologres.hive.conf.HoloStorageConfigManager;
import com.alibaba.hologres.hive.input.HoloInputFormat;
import com.alibaba.hologres.hive.output.HoloOutputFormat;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoloStorageHandler
implements HiveStorageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseHoloStorageHandler.class);
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return HoloInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HoloOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return HoloSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        try {
            LOGGER.debug("Adding properties to input job conf");
            Properties properties = tableDesc.getProperties();
            HoloStorageConfigManager.copyConfigurationToJob(properties, jobProperties);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        try {
            LOGGER.debug("Adding properties to job conf");
            Properties properties = tableDesc.getProperties();
            HoloStorageConfigManager.copyConfigurationToJob(properties, jobProperties);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        try {
            LOGGER.debug("Adding properties to output job conf");
            Properties properties = tableDesc.getProperties();
            HoloStorageConfigManager.copyConfigurationToJob(properties, jobProperties);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public HiveAuthorizationProvider getAuthorizationProvider() {
        return null;
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
    }

    public String toString() {
        return "Holo JDBC Handler";
    }
}

