/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.utils;

import com.alibaba.hologres.client.model.WriteFailStrategy;
import com.alibaba.hologres.client.model.WriteMode;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfLoader {
    public static final Logger LOG = LoggerFactory.getLogger(ConfLoader.class);

    public static <T> T load(String file, T config) throws Exception {
        return ConfLoader.load(file, null, config);
    }

    public static <T> T load(String file, String prefix, T config) throws Exception {
        return ConfLoader.load(file, prefix, config, true);
    }

    public static <T> T load(String file, String prefix, T config, boolean throwException) throws Exception {
        try (FileInputStream is = new FileInputStream(file);){
            Properties props = new Properties();
            props.load(is);
            T t = ConfLoader.load(props, prefix, config, throwException);
            return t;
        }
    }

    public static <T, I, O> T load(Map<I, O> props, T config) throws Exception {
        return ConfLoader.load(props, null, config);
    }

    public static <T, I, O> T load(Map<I, O> props, String prefix, T config) throws Exception {
        return ConfLoader.load(props, prefix, config, true);
    }

    public static <T, I, O> T load(Map<I, O> props, String prefix, T config, boolean throwException) throws Exception {
        Class<?> clazz = config.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (Map.Entry<I, O> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            String searchKey = key;
            if (prefix != null) {
                if (!key.startsWith(prefix)) continue;
                searchKey = key.substring(prefix.length());
            }
            boolean match = false;
            for (Field field : fields) {
                if (!field.getName().equalsIgnoreCase(searchKey)) continue;
                match = true;
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (type.equals(String.class)) {
                    field.set(config, value);
                } else if (type.equals(Integer.TYPE)) {
                    field.set(config, Integer.parseInt(value));
                } else if (type.equals(Long.TYPE)) {
                    field.set(config, Long.parseLong(value));
                } else if (type.equals(Boolean.TYPE)) {
                    field.set(config, Boolean.parseBoolean(value));
                } else if (WriteMode.class.equals(type)) {
                    field.set(config, (Object)WriteMode.valueOf(value));
                } else if (WriteFailStrategy.class.equals(type)) {
                    field.set(config, (Object)WriteFailStrategy.valueOf(value));
                } else {
                    throw new Exception("invalid type " + type + " for param " + key);
                }
                if ("password".equals(key)) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < value.length(); ++i) {
                        sb.append("*");
                    }
                    LOG.info("Config {}={}", (Object)key, (Object)sb.toString());
                    continue;
                }
                LOG.info("Config {}={}", (Object)key, (Object)value);
            }
            if (match) continue;
            if (throwException) {
                throw new Exception("param " + key + " not found in " + clazz.getName());
            }
            LOG.warn("param {} not found in {}", (Object)key, (Object)clazz.getName());
        }
        return config;
    }
}

