/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.model;

import com.alibaba.hologres.client.exception.ExceptionCode;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.impl.handler.ActionHandler;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;

public class RecordScanner
implements Closeable {
    private ResultSet rs;
    private final byte[] lock;
    private final TableSchema schema;
    private final BitSet selectedColumns;

    public RecordScanner(ResultSet rs, byte[] lock, TableSchema schema, BitSet selectedColumns) {
        this.rs = rs;
        this.lock = lock;
        this.schema = schema;
        this.selectedColumns = selectedColumns;
    }

    public boolean next() throws HoloClientException {
        if (this.rs != null) {
            try {
                boolean ret = this.rs.next();
                if (!ret) {
                    this.close();
                }
                return ret;
            }
            catch (SQLException e) {
                this.close();
                throw HoloClientException.fromSqlException(e);
            }
        }
        throw new HoloClientException(ExceptionCode.ALREADY_CLOSE, "RecordScanner is already close");
    }

    public Record getRecord() throws HoloClientException {
        try {
            Record record = new Record(this.schema);
            if (this.selectedColumns == null) {
                for (int i = 0; i < this.schema.getColumnSchema().length; ++i) {
                    ActionHandler.fillRecord(record, i, this.rs, i + 1, this.schema.getColumn(i));
                }
            } else {
                int index = 0;
                int i = this.selectedColumns.nextSetBit(0);
                while (i >= 0) {
                    ActionHandler.fillRecord(record, i, this.rs, ++index, this.schema.getColumn(i));
                    if (i != Integer.MAX_VALUE) {
                        i = this.selectedColumns.nextSetBit(i + 1);
                        continue;
                    }
                    break;
                }
            }
            return record;
        }
        catch (SQLException e) {
            this.close();
            throw HoloClientException.fromSqlException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        if (this.rs == null) return;
        try {
            this.rs.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.rs = null;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.lock.notifyAll();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    public boolean isDone() {
        return this.rs == null;
    }
}

