/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.model;

import java.util.Objects;

public class HoloVersion
implements Comparable<HoloVersion> {
    private int majorVersion;
    private int minorVersion;
    private int fixVersion;

    public HoloVersion(int majorVersion, int minorVersion, int fixVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.fixVersion = fixVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getFixVersion() {
        return this.fixVersion;
    }

    public boolean isUndefined() {
        return this.majorVersion == 0 && this.minorVersion == 0 && this.fixVersion == 0;
    }

    public HoloVersion(String versionStr) {
        String[] arr = versionStr.split("\\.");
        if (arr.length >= 1) {
            this.majorVersion = HoloVersion.str2int(arr[0]);
        }
        if (arr.length >= 2) {
            this.minorVersion = HoloVersion.str2int(arr[1]);
        }
        if (arr.length >= 3) {
            this.fixVersion = HoloVersion.str2int(arr[2]);
        }
    }

    private static int str2int(String s2) {
        try {
            return Integer.valueOf(s2);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public int compareTo(HoloVersion o) {
        if (this.majorVersion != o.majorVersion) {
            return this.majorVersion - o.majorVersion;
        }
        if (this.minorVersion != o.minorVersion) {
            return this.minorVersion - o.minorVersion;
        }
        return this.fixVersion - o.fixVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoloVersion that = (HoloVersion)o;
        return this.majorVersion == that.majorVersion && this.minorVersion == that.minorVersion && this.fixVersion == that.fixVersion;
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion, this.fixVersion);
    }

    public String toString() {
        return "HoloVersion{majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", fixVersion=" + this.fixVersion + '}';
    }
}

