/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.collector;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.exception.ExceptionCode;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.exception.HoloClientWithDetailsException;
import com.alibaba.hologres.client.impl.ExecutionPool;
import com.alibaba.hologres.client.impl.action.PutAction;
import com.alibaba.hologres.client.impl.collector.BatchState;
import com.alibaba.hologres.client.impl.collector.CollectorStatistics;
import com.alibaba.hologres.client.impl.collector.RecordCollector;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.RecordKey;
import com.alibaba.hologres.client.model.TableSchema;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableShardCollector {
    public static final Logger LOGGER = LoggerFactory.getLogger(TableShardCollector.class);
    private RecordCollector buffer;
    private TableSchema currentTableSchema;
    private PutAction activeAction;
    private long activeActionByteSize = 0L;
    private final ExecutionPool pool;
    private final CollectorStatistics stat;
    private final boolean enableDeduplication;

    public TableShardCollector(HoloConfig config, ExecutionPool pool, CollectorStatistics stat, int size) {
        this.buffer = new RecordCollector(config, pool, size);
        this.activeAction = null;
        this.pool = pool;
        this.stat = stat;
        this.enableDeduplication = config.isEnableDeduplication();
    }

    public synchronized void append(Record record) throws HoloClientException {
        HoloClientException exception = null;
        if (this.currentTableSchema == null) {
            this.currentTableSchema = record.getSchema();
        } else if (!this.currentTableSchema.equals(record.getSchema())) {
            try {
                this.flush(true, false, null);
            }
            catch (HoloClientException e) {
                exception = e;
            }
        }
        boolean keyExists = !this.enableDeduplication && this.buffer.isKeyExists(new RecordKey(record));
        boolean full = false;
        if (!keyExists) {
            full = this.buffer.append(record);
        }
        if (full || keyExists) {
            try {
                this.waitActionDone();
            }
            catch (HoloClientWithDetailsException e) {
                if (exception == null) {
                    exception = e;
                } else if (exception instanceof HoloClientWithDetailsException) {
                    ((HoloClientWithDetailsException)exception).merge(e);
                }
            }
            catch (HoloClientException e) {
                exception = e;
            }
            this.commit(this.buffer.getBatchState());
        } else {
            try {
                this.isActionDone();
            }
            catch (HoloClientWithDetailsException e) {
                if (exception == null) {
                    exception = e;
                } else if (exception instanceof HoloClientWithDetailsException) {
                    ((HoloClientWithDetailsException)exception).merge(e);
                }
            }
            catch (HoloClientException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (keyExists) {
            this.append(record);
        }
    }

    private void commit(BatchState state) throws HoloClientException {
        this.stat.add(state);
        this.activeAction = new PutAction(this.buffer.getRecords(), this.buffer.getByteSize(), this.buffer.getMode(), state);
        try {
            while (!this.pool.submit(this.activeAction)) {
            }
            this.activeActionByteSize = this.activeAction.getByteSize();
        }
        catch (Exception e) {
            this.activeAction.getFuture().completeExceptionally(e);
            if (this.activeAction.getRecordList() != null) {
                for (Record record : this.activeAction.getRecordList()) {
                    if (record.getPutFutures() == null) continue;
                    for (CompletableFuture<Void> future : record.getPutFutures()) {
                        if (future.isDone()) continue;
                        future.completeExceptionally(e);
                    }
                }
            }
            if (!(e instanceof HoloClientException)) {
                throw new HoloClientException(ExceptionCode.INTERNAL_ERROR, "", e);
            }
            throw e;
        }
        finally {
            this.buffer.clear();
            this.currentTableSchema = null;
        }
    }

    private void clearActiveAction() {
        this.activeAction = null;
        this.activeActionByteSize = 0L;
    }

    private void waitActionDone() throws HoloClientException {
        if (this.activeAction != null) {
            try {
                this.activeAction.getFuture().get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof HoloClientException) {
                    throw (HoloClientException)cause;
                }
                throw new HoloClientException(ExceptionCode.INTERNAL_ERROR, "unknow exception", cause);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.clearActiveAction();
            }
        }
    }

    private boolean isActionDone() throws HoloClientException {
        if (this.activeAction != null) {
            try {
                if (this.activeAction.getFuture().isDone()) {
                    try {
                        this.activeAction.getFuture().get();
                    }
                    finally {
                        this.clearActiveAction();
                    }
                    return true;
                }
                return false;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                this.clearActiveAction();
                if (cause instanceof HoloClientException) {
                    throw (HoloClientException)cause;
                }
                throw new HoloClientException(ExceptionCode.INTERNAL_ERROR, "unknow exception", cause);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    public synchronized boolean flush(boolean force, boolean async, AtomicInteger uncommittedActionCount) throws HoloClientException {
        HoloClientWithDetailsException failedRecords = null;
        boolean readableDone = false;
        try {
            if (async) {
                readableDone = this.isActionDone();
            } else {
                readableDone = true;
                this.waitActionDone();
            }
        }
        catch (HoloClientWithDetailsException e) {
            readableDone = true;
            failedRecords = e;
        }
        boolean done = false;
        if (readableDone) {
            if (this.buffer.size > 0) {
                BatchState state;
                BatchState batchState = state = force ? BatchState.Force : this.buffer.getBatchState();
                if (state != BatchState.NotEnough) {
                    this.commit(state);
                }
            } else {
                done = true;
            }
        } else if (uncommittedActionCount != null && this.buffer.size > 0) {
            uncommittedActionCount.incrementAndGet();
        }
        if (failedRecords != null) {
            throw failedRecords;
        }
        return done;
    }

    public long getByteSize() {
        return this.activeActionByteSize + this.buffer.getByteSize();
    }
}

