/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.Put;
import com.alibaba.hologres.client.impl.PreparedStatementWithBatchInfo;
import com.alibaba.hologres.client.impl.UpsertStatementBuilder;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValuesBuilder;
import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.HoloVersion;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableName;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.client.model.WriteMode;
import com.alibaba.hologres.client.type.PGroaringbitmap;
import com.alibaba.hologres.client.utils.IdentifierUtil;
import com.alibaba.hologres.client.utils.Tuple;
import com.alibaba.hologres.client.utils.Tuple3;
import com.alibaba.hologres.org.postgresql.jdbc.PgConnection;
import com.alibaba.hologres.org.postgresql.util.PSQLState;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnnestUpsertStatementBuilder
extends UpsertStatementBuilder {
    public static final Logger LOGGER = LoggerFactory.getLogger(UnnestUpsertStatementBuilder.class);
    boolean enableDefaultValue;
    String defaultTimeStampText;
    SqlCache<Tuple<BitSet, BitSet>, InsertSql> insertCache = new SqlCache();
    boolean first = true;
    Set<Tuple<NotSupportReasonCode, Tuple<TableSchema, Column>>> reasonSet = new HashSet<Tuple<NotSupportReasonCode, Tuple<TableSchema, Column>>>();
    private static final int WARN_SKIP_COUNT = 10000;
    long warnCount = 10000L;
    private static final HoloVersion SUPPORT_VERSION = new HoloVersion(1, 1, 38);

    public UnnestUpsertStatementBuilder(HoloConfig config) {
        super(config);
        this.enableDefaultValue = config.isEnableDefaultForNotNullColumn();
        this.defaultTimeStampText = config.getDefaultTimestampText();
    }

    private boolean isSupportUnnest(TableSchema schema, Tuple<BitSet, BitSet> columnSet) {
        if (((BitSet)columnSet.r).cardinality() > 0) {
            LOGGER.warn("Not support unnest\uff0cbecause Put for table {} contain insertOnlyColumn {} ", (Object)schema.getTableNameObj().getFullName(), columnSet.r);
            return false;
        }
        IntStream columnStream = ((BitSet)columnSet.l).stream();
        int index = -1;
        for (Column column : schema.getColumnSchema()) {
            if (((BitSet)columnSet.l).get(++index)) {
                if (this.isTypeSupportForUnnest(column.getType(), column.getTypeName())) continue;
                LOGGER.warn("Not support unnest\uff0cbecause Put for table {} contain unsupported column {}({}) ", schema.getTableNameObj().getFullName(), column.getName(), column.getTypeName());
                return false;
            }
            if (column.getDefaultValue() == null) continue;
            LOGGER.warn("Not support unnest\uff0cbecause Put for table {} not insert column {} has default value {}", schema.getTableNameObj().getFullName(), column.getName(), column.getDefaultValue());
            return false;
        }
        return true;
    }

    private InsertSql buildInsertSql(Tuple3<TableSchema, TableName, WriteMode> tuple, Tuple<BitSet, BitSet> input) {
        TableSchema schema = (TableSchema)tuple.l;
        TableName tableName = (TableName)tuple.m;
        WriteMode mode = (WriteMode)((Object)tuple.r);
        BitSet set = (BitSet)input.l;
        BitSet onlyInsertSet = (BitSet)input.r;
        boolean isUnnest = false;
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(tableName.getFullName());
        sb.append("(");
        this.first = true;
        set.stream().forEach(index -> {
            if (!this.first) {
                sb.append(",");
            }
            this.first = false;
            sb.append(IdentifierUtil.quoteIdentifier(schema.getColumn(index).getName(), true));
        });
        sb.append(")");
        if (this.isSupportUnnest(schema, input)) {
            isUnnest = true;
            sb.append(" select ");
            this.first = true;
            set.stream().forEach(index -> {
                if (!this.first) {
                    sb.append(",");
                }
                this.first = false;
                Column column = schema.getColumn(index);
                sb.append("unnest(?::").append(UnnestUpsertStatementBuilder.getRealTypeName(column.getType(), column.getTypeName())).append("[])");
            });
        } else {
            sb.append(" values (");
            this.first = true;
            set.stream().forEach(index -> {
                if (!this.first) {
                    sb.append(",");
                }
                this.first = false;
                sb.append("?");
                Column column = schema.getColumn(index);
                if (-7 == column.getType() && "bit".equals(column.getTypeName())) {
                    sb.append("::bit(").append(column.getPrecision()).append(")");
                } else if (1111 == column.getType() && "varbit".equals(column.getTypeName())) {
                    sb.append("::bit varying(").append(column.getPrecision()).append(")");
                }
            });
            sb.append(")");
        }
        if (schema.getKeyIndex().length > 0) {
            sb.append(" on conflict (");
            this.first = true;
            for (int index2 : schema.getKeyIndex()) {
                if (!this.first) {
                    sb.append(",");
                }
                this.first = false;
                sb.append(IdentifierUtil.quoteIdentifier(schema.getColumnSchema()[index2].getName(), true));
            }
            sb.append(") do ");
            if (WriteMode.INSERT_OR_IGNORE == mode) {
                sb.append("nothing");
            } else {
                sb.append("update set ");
                this.first = true;
                set.stream().forEach(index -> {
                    if (!onlyInsertSet.get(index)) {
                        if (!this.first) {
                            sb.append(",");
                        }
                        this.first = false;
                        String columnName = IdentifierUtil.quoteIdentifier(schema.getColumnSchema()[index].getName(), true);
                        sb.append(columnName).append("=excluded.").append(columnName);
                    }
                });
            }
        }
        String sql = sb.toString();
        LOGGER.debug("new sql:{}", (Object)sql);
        InsertSql insertSql = new InsertSql();
        insertSql.isUnnest = isUnnest;
        insertSql.sql = sql;
        return insertSql;
    }

    private static String[] handleDefaultValue(String defaultValue) {
        String[] ret = defaultValue.split("::");
        if (ret.length == 1) {
            String[] temp = new String[]{ret[0], null};
            ret = temp;
        }
        if (ret[0].startsWith("'") && ret[0].endsWith("'") && ret[0].length() > 1) {
            ret[0] = ret[0].substring(1, ret[0].length() - 1);
        }
        return ret;
    }

    private void logWarnSeldom(String s2, Object ... obj) {
        if (++this.warnCount > 10000L) {
            LOGGER.warn(s2, obj);
            this.warnCount = 0L;
        }
    }

    private void fillDefaultValue(Record record, Column column, int i) {
        if (record.getObject(i) == null && !column.getAllowNull().booleanValue()) {
            if (column.isSerial()) {
                return;
            }
            if (column.getDefaultValue() != null) {
                String[] defaultValuePair = UnnestUpsertStatementBuilder.handleDefaultValue(String.valueOf(column.getDefaultValue()));
                String defaultValue = defaultValuePair[0];
                switch (column.getType()) {
                    case -5: 
                    case 4: 
                    case 5: {
                        record.setObject(i, Long.parseLong(defaultValue));
                        break;
                    }
                    case 6: 
                    case 8: {
                        record.setObject(i, Double.parseDouble(defaultValue));
                        break;
                    }
                    case 2: 
                    case 3: {
                        record.setObject(i, new BigDecimal(defaultValue));
                        break;
                    }
                    case -7: 
                    case 16: {
                        record.setObject(i, Boolean.valueOf(defaultValue));
                        break;
                    }
                    case 1: 
                    case 12: {
                        record.setObject(i, defaultValue);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2013: {
                        if ("now()".equalsIgnoreCase(defaultValue) || "current_timestamp".equalsIgnoreCase(defaultValue)) {
                            record.setObject(i, new Date());
                            break;
                        }
                        record.setObject(i, defaultValue);
                        break;
                    }
                    default: {
                        this.logWarnSeldom("unsupported default type,{}({})", column.getType(), column.getTypeName());
                        break;
                    }
                }
            } else if (this.enableDefaultValue) {
                switch (column.getType()) {
                    case -5: 
                    case 4: 
                    case 5: {
                        record.setObject(i, 0L);
                        break;
                    }
                    case 6: 
                    case 8: {
                        record.setObject(i, 0.0);
                        break;
                    }
                    case 2: 
                    case 3: {
                        record.setObject(i, BigDecimal.ZERO);
                        break;
                    }
                    case -7: 
                    case 16: {
                        record.setObject(i, false);
                        break;
                    }
                    case 1: 
                    case 12: {
                        record.setObject(i, "");
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2013: {
                        if (this.defaultTimeStampText == null) {
                            record.setObject(i, new Date(0L));
                            break;
                        }
                        record.setObject(i, this.defaultTimeStampText);
                        break;
                    }
                    default: {
                        this.logWarnSeldom("unsupported default type,{}({})", column.getType(), column.getTypeName());
                    }
                }
            }
        }
    }

    private void fillNotSetValue(Record record, Column column, int i) {
        if (!record.isSet(i)) {
            if (column.isSerial()) {
                return;
            }
            record.setObject(i, null);
        }
    }

    private void handleArrayColumn(Connection conn, Record record, Column column, int index) throws SQLException {
        Object obj = record.getObject(index);
        if (null != obj && obj instanceof List) {
            List list = (List)obj;
            Array array = conn.createArrayOf(column.getTypeName().substring(1), list.toArray());
            record.setObject(index, array);
        } else if (obj != null && obj instanceof Object[]) {
            Array array = conn.createArrayOf(column.getTypeName().substring(1), (Object[])obj);
            record.setObject(index, array);
        }
    }

    @Override
    public void prepareRecord(Connection conn, Record record, WriteMode mode) throws SQLException {
        try {
            for (int i = 0; i < record.getSize(); ++i) {
                Column column = record.getSchema().getColumn(i);
                if (record.getType() == Put.MutationType.INSERT && mode != WriteMode.INSERT_OR_UPDATE) {
                    this.fillDefaultValue(record, column, i);
                    this.fillNotSetValue(record, column, i);
                }
                if (column.getType() != 2003) continue;
                this.handleArrayColumn(conn, record, column, i);
            }
        }
        catch (Exception e) {
            throw new SQLException(PSQLState.INVALID_PARAMETER_VALUE.getState(), e);
        }
    }

    private void fillPreparedStatement(PreparedStatement ps, int index, Object obj, Column column) throws SQLException {
        switch (column.getType()) {
            case 1111: {
                if (obj instanceof byte[] && "roaringbitmap".equalsIgnoreCase(column.getTypeName())) {
                    PGroaringbitmap binaryObject = new PGroaringbitmap();
                    byte[] bytes = (byte[])obj;
                    binaryObject.setByteValue(bytes, 0);
                    ps.setObject(index, (Object)binaryObject, column.getType());
                    break;
                }
                if ("varbit".equals(column.getTypeName())) {
                    ps.setString(index, obj == null ? null : String.valueOf(obj));
                    break;
                }
                ps.setObject(index, obj, column.getType());
                break;
            }
            case -7: {
                if ("bit".equals(column.getTypeName())) {
                    if (obj instanceof Boolean) {
                        ps.setString(index, (Boolean)obj != false ? "1" : "0");
                        break;
                    }
                    ps.setString(index, obj == null ? null : String.valueOf(obj));
                    break;
                }
                ps.setObject(index, obj, column.getType());
                break;
            }
            default: {
                ps.setObject(index, obj, column.getType());
            }
        }
    }

    private static String getRealTypeName(int type, String typeName) {
        String ret = null;
        switch (type) {
            case 4: {
                if ("serial".equals(typeName)) {
                    ret = "int";
                    break;
                }
                ret = typeName;
                break;
            }
            case -5: {
                if ("bigserial".equals(typeName)) {
                    ret = "bigint";
                    break;
                }
                ret = typeName;
                break;
            }
            default: {
                ret = typeName;
            }
        }
        return ret;
    }

    private boolean isTypeSupportForUnnest(int type, String typeName) {
        switch (type) {
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 93: 
            case 2013: 
            case 2014: {
                return true;
            }
            case -7: {
                return "bool".equals(typeName);
            }
            case -5: {
                return !"oid".equals(typeName);
            }
            case 1111: {
                return "json".equals(typeName) || "jsonb".equals(typeName);
            }
        }
        return false;
    }

    private void prepareColumnValues(Connection conn, int rows, BitSet insertColumnBitSet, TableSchema schema, JdbcColumnValues[] arrayList) throws SQLException {
        int arrayIndex = -1;
        IntStream columnStream = insertColumnBitSet.stream();
        PrimitiveIterator.OfInt it = columnStream.iterator();
        while (it.hasNext()) {
            int index = it.next();
            Column column = schema.getColumn(index);
            arrayList[++arrayIndex] = JdbcColumnValuesBuilder.build(conn.unwrap(PgConnection.class), rows, column.getType(), column.getTypeName(), this.config);
        }
    }

    private boolean isVersionSupport(HoloVersion version) {
        return version.compareTo(SUPPORT_VERSION) >= 0;
    }

    @Override
    protected void buildInsertStatement(Connection conn, HoloVersion version, TableSchema schema, TableName tableName, Tuple<BitSet, BitSet> columnSet, List<Record> recordList, List<PreparedStatementWithBatchInfo> list, WriteMode mode) throws SQLException {
        if (!this.isVersionSupport(version)) {
            super.buildInsertStatement(conn, version, schema, tableName, columnSet, recordList, list, mode);
            return;
        }
        InsertSql insertSql = this.insertCache.computeIfAbsent(new Tuple3<TableSchema, TableName, WriteMode>(schema, tableName, mode), columnSet, this::buildInsertSql);
        PreparedStatement currentPs = null;
        try {
            currentPs = conn.prepareStatement(insertSql.sql);
            if (insertSql.isUnnest) {
                long totalBytes = recordList.stream().collect(Collectors.summingLong(r -> r.getByteSize()));
                int rows = recordList.size();
                int stepRows = 0;
                if (this.config.getMaxBytesPerSql() > 0L) {
                    long avg = Math.max(totalBytes / (long)recordList.size(), 1L);
                    stepRows = (int)Math.min(this.config.getMaxBytesPerSql() / avg, (long)this.config.getMaxRowsPerSql());
                }
                if ((stepRows = Math.min(recordList.size(), Math.max(stepRows, 0))) != 0) {
                    rows = recordList.size() % stepRows + stepRows;
                }
                boolean isInit = false;
                boolean isFirstBatch = true;
                JdbcColumnValues[] arrayList = new JdbcColumnValues[((BitSet)columnSet.l).cardinality()];
                this.prepareColumnValues(conn, rows, (BitSet)columnSet.l, schema, arrayList);
                int row = 0;
                int batchCount = 0;
                for (Record record : recordList) {
                    int index;
                    if (!isInit) {
                        if (isFirstBatch) {
                            isFirstBatch = false;
                        } else {
                            rows = stepRows;
                        }
                        this.prepareColumnValues(conn, rows, (BitSet)columnSet.l, schema, arrayList);
                        ++batchCount;
                        isInit = true;
                    }
                    int arrayIndex = -1;
                    IntStream columnStream = ((BitSet)columnSet.l).stream();
                    PrimitiveIterator.OfInt it = columnStream.iterator();
                    while (it.hasNext()) {
                        index = it.next();
                        arrayList[++arrayIndex].set(row, record.getObject(index));
                    }
                    if (++row != rows) continue;
                    arrayIndex = -1;
                    columnStream = ((BitSet)columnSet.l).stream();
                    it = columnStream.iterator();
                    while (it.hasNext()) {
                        index = it.next();
                        Column column = schema.getColumn(index);
                        Array array = conn.createArrayOf(UnnestUpsertStatementBuilder.getRealTypeName(column.getType(), column.getTypeName()), arrayList[++arrayIndex].getArray());
                        currentPs.setArray(arrayIndex + 1, array);
                    }
                    isInit = false;
                    if (rows < recordList.size()) {
                        currentPs.addBatch();
                    }
                    row = 0;
                }
                PreparedStatementWithBatchInfo preparedStatementWithBatchInfo = new PreparedStatementWithBatchInfo(currentPs, rows < recordList.size(), Put.MutationType.INSERT);
                preparedStatementWithBatchInfo.setByteSize(totalBytes);
                preparedStatementWithBatchInfo.setBatchCount(batchCount);
                list.add(preparedStatementWithBatchInfo);
            } else {
                super.buildInsertStatement(conn, version, schema, tableName, columnSet, recordList, list, mode);
            }
        }
        catch (SQLException e) {
            if (null != currentPs) {
                try {
                    currentPs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw e;
        }
        finally {
            if (this.insertCache.getSize() > 500) {
                this.insertCache.clear();
            }
        }
    }

    static enum NotSupportReasonCode {
        UNNEST_NOT_SUPPORT_PARTITION_TABLE,
        UNNEST_NOT_SUPPORT_INSERT_ONLY,
        UNNEST_NOT_SUPPORT_TYPE;

    }

    class InsertSql {
        public String sql;
        public boolean isUnnest;

        InsertSql() {
        }
    }

    static class SqlCache<T, R> {
        Map<Tuple3<TableSchema, TableName, WriteMode>, Map<T, R>> cacheMap = new HashMap<Tuple3<TableSchema, TableName, WriteMode>, Map<T, R>>();
        int size = 0;

        SqlCache() {
        }

        public R computeIfAbsent(Tuple3<TableSchema, TableName, WriteMode> tuple, T t, BiFunction<Tuple3<TableSchema, TableName, WriteMode>, T, R> b) {
            Map subMap = this.cacheMap.computeIfAbsent(tuple, s2 -> new HashMap());
            return (R)subMap.computeIfAbsent(t, bs -> {
                ++this.size;
                return b.apply(tuple, bs);
            });
        }

        public int getSize() {
            return this.size;
        }

        public void clear() {
            this.cacheMap.clear();
        }
    }
}

