/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.exception.ExceptionCode;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.function.FunctionWithSQLException;
import com.alibaba.hologres.client.impl.util.ConnectionUtil;
import com.alibaba.hologres.client.model.HoloVersion;
import com.alibaba.hologres.client.model.SSLMode;
import com.alibaba.hologres.org.postgresql.PGProperty;
import com.alibaba.hologres.org.postgresql.jdbc.PgConnection;
import java.io.Closeable;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHolder
implements Closeable {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConnectionHolder.class);
    final String originalJdbcUrl;
    Properties info = new Properties();
    final ConnectionWithVersion connWithVersion;
    final boolean isFixed;
    final int tryCount;
    final long retrySleepStepMs;
    final long retrySleepInitMs;
    final int refreshMetaTimeout;
    final boolean refreshMetaAfterConnectionCreated;
    final boolean isEnableDirectConnection;
    final boolean isEnableAffectedRows;
    final boolean isEnableGenerateBinlog;
    long lastActiveTs;
    private static List<String> preSqlList;
    private static byte[] lock;
    private Object owner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPreSql(String sql) {
        byte[] byArray = lock;
        synchronized (lock) {
            ArrayList<String> temp = new ArrayList<String>();
            temp.addAll(preSqlList);
            temp.add(sql);
            preSqlList = temp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public ConnectionHolder(HoloConfig config, Object owner, boolean shadingMode, boolean isFixed) {
        this(config, owner, shadingMode, isFixed, null);
    }

    public ConnectionHolder(HoloConfig config, Object owner, boolean shadingMode, boolean isFixed, Properties userInfo) {
        String url = config.getJdbcUrl();
        if (shadingMode && url.startsWith("jdbc:postgresql:")) {
            url = "jdbc:hologres:" + url.substring("jdbc:postgresql:".length());
        }
        this.isFixed = isFixed;
        if (isFixed) {
            url = ConnectionUtil.generateFixedUrl(url);
            PGProperty.ASSUME_MIN_SERVER_VERSION.set(this.info, "9.4");
        }
        if (userInfo != null) {
            this.info.putAll((Map<?, ?>)userInfo);
        }
        this.originalJdbcUrl = url;
        PGProperty.USER.set(this.info, config.getUsername());
        PGProperty.PASSWORD.set(this.info, config.getPassword());
        PGProperty.APPLICATION_NAME.set(this.info, "2.3.0_" + config.getAppName());
        PGProperty.SOCKET_TIMEOUT.set(this.info, 360);
        if (config.getSslMode() != SSLMode.DISABLE) {
            PGProperty.SSL.set(this.info, true);
            PGProperty.SSL_MODE.set(this.info, config.getSslMode().getPgPropertyValue());
            if (config.getSslMode() == SSLMode.VERIFY_CA || config.getSslMode() == SSLMode.VERIFY_FULL) {
                if (config.getSslRootCertLocation() == null) {
                    throw new InvalidParameterException("When SSL_MODE is set to VERIFY_CA or VERIFY_FULL, the location of the ssl root certificate must be configured.");
                }
                PGProperty.SSL_ROOT_CERT.set(this.info, config.getSslRootCertLocation());
            }
        }
        this.tryCount = config.getRetryCount();
        this.retrySleepInitMs = config.getRetrySleepInitMs();
        this.retrySleepStepMs = config.getRetrySleepStepMs();
        this.refreshMetaTimeout = config.getRefreshMetaTimeout();
        this.refreshMetaAfterConnectionCreated = config.isRefreshMetaAfterConnectionCreated();
        this.isEnableDirectConnection = config.isEnableDirectConnection();
        this.isEnableAffectedRows = config.isEnableAffectedRows();
        this.isEnableGenerateBinlog = config.isEnableGenerateBinlog();
        this.lastActiveTs = System.currentTimeMillis();
        this.owner = owner;
        this.connWithVersion = new ConnectionWithVersion();
        this.connWithVersion.jdbcUrl = this.originalJdbcUrl;
    }

    private PgConnection buildConnection() throws SQLException {
        PgConnection conn;
        long start;
        block26: {
            start = System.nanoTime();
            if (this.isEnableDirectConnection && !this.isFixed) {
                this.connWithVersion.jdbcUrl = ConnectionUtil.getDirectConnectionJdbcUrl(this.originalJdbcUrl, this.info);
            }
            LOGGER.info("Try to connect {}, owner:{}", (Object)this.connWithVersion.jdbcUrl, this.owner);
            conn = null;
            try {
                conn = DriverManager.getConnection(this.connWithVersion.jdbcUrl, this.info).unwrap(PgConnection.class);
                conn.setAutoCommit(true);
                if (!this.isFixed) {
                    if (this.refreshMetaAfterConnectionCreated && this.refreshMetaTimeout > 0) {
                        ConnectionUtil.refreshMeta(conn, this.refreshMetaTimeout);
                    }
                    ArrayList<String> pre = new ArrayList<String>(preSqlList);
                    if (!this.isEnableAffectedRows) {
                        pre.add("set hg_experimental_enable_fixed_dispatcher_affected_rows = off");
                    }
                    if (!this.isEnableGenerateBinlog) {
                        pre.add("set hg_experimental_generate_binlog = off");
                    }
                    for (String sql : pre) {
                        try {
                            Statement stat = conn.createStatement();
                            Throwable throwable = null;
                            try {
                                stat.execute(sql);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (stat == null) continue;
                                if (throwable != null) {
                                    try {
                                        stat.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                stat.close();
                            }
                        }
                        catch (SQLException e) {
                            LOGGER.warn("execute preSql fail:{},emsg:{}", (Object)sql, (Object)e.getMessage());
                        }
                    }
                    this.connWithVersion.version = ConnectionUtil.getHoloVersion(conn);
                    break block26;
                }
                this.connWithVersion.version = new HoloVersion(1, 3, 1);
            }
            catch (Exception e) {
                if (e.getMessage().contains("invalid command-line argument for server process: type=fixed") || e.getMessage().contains("unrecognized configuration parameter \"type\"")) {
                    throw new SQLException("FixedFe mode is only supported after hologres version 1.3");
                }
                if (null != conn) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        long end = System.nanoTime();
        if (this.isFixed) {
            LOGGER.info("Connected to {}, owner:{}, cost:{} ms, isFixed:true", this.connWithVersion.jdbcUrl, this.owner, (end - start) / 1000000L);
        } else {
            LOGGER.info("Connected to {}, owner:{}, cost:{} ms, version:{}", this.connWithVersion.jdbcUrl, this.owner, (end - start) / 1000000L, this.connWithVersion.version);
        }
        return conn;
    }

    private boolean testConnection(Connection conn, HoloClientException lastException) {
        if (lastException != null) {
            switch (lastException.getCode()) {
                case CONNECTION_ERROR: 
                case META_NOT_MATCH: {
                    return false;
                }
            }
        }
        try (Statement stat = conn.createStatement();
             ResultSet rs = stat.executeQuery("select 1");){
            rs.next();
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public synchronized <T> T retryExecuteWithVersion(FunctionWithSQLException<ConnectionWithVersion, T> action) throws HoloClientException {
        return this.doRetryExecute(action, this.tryCount, this::getConnWithVersion);
    }

    public synchronized <T> T retryExecuteWithVersion(FunctionWithSQLException<ConnectionWithVersion, T> action, int tryCount) throws HoloClientException {
        return this.doRetryExecute(action, tryCount, this::getConnWithVersion);
    }

    public synchronized <T> T retryExecute(FunctionWithSQLException<PgConnection, T> action) throws HoloClientException {
        return this.doRetryExecute(action, this.tryCount, this::getPgConnection);
    }

    public synchronized Object retryExecute(FunctionWithSQLException<PgConnection, Object> action, int tryCount) throws HoloClientException {
        return this.doRetryExecute(action, tryCount, this::getPgConnection);
    }

    private ConnectionWithVersion getConnWithVersion() {
        return this.connWithVersion;
    }

    private PgConnection getPgConnection() {
        return this.connWithVersion.conn;
    }

    public synchronized <C, T> T doRetryExecute(FunctionWithSQLException<C, T> action, int tryCount, Supplier<C> supplier) throws HoloClientException {
        if (tryCount < 1) {
            tryCount = this.tryCount;
        }
        HoloClientException e = null;
        for (int i = 0; i < tryCount; ++i) {
            try {
                if (this.connWithVersion.conn == null || this.connWithVersion.conn.isClosed()) {
                    this.connWithVersion.conn = this.buildConnection();
                }
                this.lastActiveTs = System.currentTimeMillis();
                T t = action.apply(supplier.get());
                return t;
            }
            catch (SQLException exception) {
                e = HoloClientException.fromSqlException(exception);
                try {
                    if (null != this.connWithVersion.conn && !this.testConnection(this.connWithVersion.conn, e)) {
                        PgConnection tempConn = this.connWithVersion.conn;
                        this.connWithVersion.conn = null;
                        this.connWithVersion.version = null;
                        tempConn.close();
                    }
                }
                catch (Exception tempConn) {
                    // empty catch block
                }
                if (i == tryCount - 1 || !this.needRetry(e)) {
                    throw e;
                }
                long sleepTime = this.retrySleepStepMs * (long)i + this.retrySleepInitMs;
                LOGGER.warn("execute sql fail, try again[" + (i + 1) + "/" + tryCount + "], sleepMs = " + sleepTime + " ms", exception);
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            catch (Exception exception) {
                throw new HoloClientException(ExceptionCode.INTERNAL_ERROR, "execute fail", exception);
            }
            finally {
                this.lastActiveTs = System.currentTimeMillis();
            }
        }
        throw e;
    }

    private boolean needRetry(HoloClientException e) {
        if (this.connWithVersion.conn != null && this.testConnection(this.connWithVersion.conn, e)) {
            boolean ret = false;
            switch (e.getCode()) {
                case CONNECTION_ERROR: 
                case META_NOT_MATCH: 
                case READ_ONLY: 
                case TOO_MANY_CONNECTIONS: 
                case BUSY: {
                    ret = true;
                    break;
                }
            }
            return ret;
        }
        return e.getCode() != ExceptionCode.AUTH_FAIL;
    }

    public long getLastActiveTs() {
        return this.lastActiveTs;
    }

    public HoloVersion getVersion() throws HoloClientException {
        if (this.connWithVersion.version == null) {
            this.connWithVersion.version = this.retryExecute(conn -> ConnectionUtil.getHoloVersion(conn));
        }
        return this.connWithVersion.version;
    }

    @Override
    public void close() {
        this.connWithVersion.version = null;
        if (this.connWithVersion.conn != null) {
            try {
                LOGGER.info("Close connection to {}, owner:{}", (Object)this.connWithVersion.jdbcUrl, this.owner);
                this.connWithVersion.conn.close();
                LOGGER.info("Closed connection to {}, owner:{}", (Object)this.connWithVersion.jdbcUrl, this.owner);
                this.connWithVersion.conn = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static {
        lock = new byte[0];
        preSqlList = new ArrayList<String>();
        preSqlList.add("set hg_experimental_enable_fixed_dispatcher = on");
        preSqlList.add("set hg_experimental_enable_fixed_dispatcher_for_multi_values = on");
        preSqlList.add("set hg_experimental_enable_fixed_dispatcher_for_update = on");
        preSqlList.add("set hg_experimental_enable_fixed_dispatcher_for_delete = on");
        preSqlList.add("set hg_experimental_enable_fixed_dispatcher_for_scan = on");
    }

    public class ConnectionWithVersion {
        private PgConnection conn = null;
        private HoloVersion version = null;
        private String jdbcUrl = null;

        public PgConnection getConn() {
            return this.conn;
        }

        public HoloVersion getVersion() {
            return this.version;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }
    }
}

