/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.copy;

import com.alibaba.hologres.client.copy.RecordOutputStream;
import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.org.apache.commons.csv.CSVFormat;
import com.alibaba.hologres.org.apache.commons.csv.CSVPrinter;
import com.alibaba.hologres.org.apache.commons.csv.QuoteMode;
import com.alibaba.hologres.org.postgresql.core.BaseConnection;
import com.alibaba.hologres.org.postgresql.jdbc.ArrayUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;

public class RecordTextOutputStream
extends RecordOutputStream {
    private final StringWriter stringWriter;
    private final CSVPrinter printer;

    public RecordTextOutputStream(OutputStream os, TableSchema schema, BaseConnection baseConnection, int maxCellBufferSize) throws IOException {
        super(os, schema, baseConnection, maxCellBufferSize);
        this.stringWriter = new StringWriter(maxCellBufferSize);
        this.printer = new CSVPrinter(this.stringWriter, CSVFormat.POSTGRESQL_CSV.withEscape('\\').withQuoteMode(QuoteMode.MINIMAL));
    }

    @Override
    protected void fillByteBuffer(Record record) throws IOException {
        this.stringWriter.getBuffer().setLength(0);
        for (int i = 0; i < record.getSchema().getColumnSchema().length; ++i) {
            if (!record.isSet(i)) continue;
            Column column = record.getSchema().getColumn(i);
            int type = column.getType();
            Object obj = record.getObject(i);
            if (obj == null) {
                this.printer.print(Character.valueOf('N'));
                continue;
            }
            try {
                switch (type) {
                    case 2003: {
                        String text = obj.getClass().getComponentType() != null ? ArrayUtil.arrayToString(obj) : String.valueOf(obj);
                        this.printer.print(text);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 1111: 
                    case 2004: {
                        if (obj instanceof byte[]) {
                            byte[] bytes = (byte[])obj;
                            StringBuffer sb = new StringBuffer(2 + bytes.length);
                            sb.append("\\x");
                            for (int j = 0; j < bytes.length; ++j) {
                                String hex = Integer.toHexString(bytes[j] & 0xFF);
                                if (hex.length() < 2) {
                                    sb.append(0);
                                }
                                sb.append(hex);
                            }
                            this.printer.print(sb.toString());
                            break;
                        }
                        this.printer.print(String.valueOf(obj));
                        break;
                    }
                    default: {
                        this.printer.print(record.getObject(i));
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw new IOException("fill byteBuffer " + column.getName() + " fail.index:" + i + " record:" + this.currentRecord + ", text:" + obj, e);
            }
        }
        this.printer.println();
        this.printer.flush();
        this.write(this.stringWriter.toString().getBytes(Charset.forName("utf-8")));
    }
}

