/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.copy;

import com.alibaba.hologres.client.copy.WithCopyResult;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.org.postgresql.core.BaseConnection;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class RecordOutputStream
implements Closeable {
    private static final int DEFAULT_MAX_CELL_BUFFER_SIZE = 0x200000;
    protected static final Charset UTF8 = Charset.forName("utf-8");
    protected final TableSchema schema;
    private final int maxCellBufferSize;
    protected final BaseConnection conn;
    protected final TimestampUtils timestampUtils;
    private final OutputStream os;
    boolean closed = false;
    ByteBuffer cellBuffer = ByteBuffer.allocate(10);
    Record currentRecord = null;
    int currentColumnIndex;

    public RecordOutputStream(OutputStream os, TableSchema schema, BaseConnection conn, int maxCellBufferSize) {
        this.schema = schema;
        this.os = os;
        this.maxCellBufferSize = maxCellBufferSize;
        this.conn = conn;
        this.timestampUtils = conn.getTimestampUtils();
    }

    public long getResult() {
        if (this.os instanceof WithCopyResult) {
            return ((WithCopyResult)((Object)this.os)).getResult();
        }
        return -1L;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.os.close();
        }
    }

    public void putRecord(Record record) throws IOException {
        if (this.closed) {
            throw new IOException("RecordOutputFormat already closed");
        }
        this.fillByteBuffer(record);
        this.cellBuffer.flip();
        this.os.write(this.cellBuffer.array(), this.cellBuffer.position(), this.cellBuffer.remaining());
        this.cellBuffer.clear();
    }

    protected abstract void fillByteBuffer(Record var1) throws IOException;

    private void mayIncBuffer(int size) throws IOException {
        if (this.cellBuffer.remaining() < size) {
            if (this.cellBuffer.position() + size < this.maxCellBufferSize) {
                int target = Math.min(Math.max(this.cellBuffer.position() + size, this.cellBuffer.position() * 2), this.maxCellBufferSize);
                ByteBuffer temp = ByteBuffer.allocate(target);
                this.cellBuffer.flip();
                temp.put(this.cellBuffer);
                this.cellBuffer.clear();
                this.cellBuffer = temp;
            } else {
                throw new IOException("RecordInputStream cellBuffer exceed max cell size " + this.maxCellBufferSize + " for column " + this.schema.getColumn(this.currentColumnIndex).getName());
            }
        }
    }

    protected void write(int r) throws IOException {
        this.mayIncBuffer(1);
        this.cellBuffer.put((byte)(r & 0xFF));
    }

    protected void writeShort(short r) throws IOException {
        this.mayIncBuffer(2);
        this.cellBuffer.putShort(r);
    }

    protected void writeInt(int r) throws IOException {
        this.mayIncBuffer(4);
        this.cellBuffer.putInt(r);
    }

    protected void writeFloat(float r) throws IOException {
        this.mayIncBuffer(4);
        this.cellBuffer.putFloat(r);
    }

    protected void writeDouble(double r) throws IOException {
        this.mayIncBuffer(8);
        this.cellBuffer.putDouble(r);
    }

    protected void writeLong(long r) throws IOException {
        this.mayIncBuffer(8);
        this.cellBuffer.putLong(r);
    }

    protected void write(byte[] bytes) throws IOException {
        this.mayIncBuffer(bytes.length);
        this.cellBuffer.put(bytes);
    }
}

