/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.copy;

import com.alibaba.hologres.client.copy.RecordOutputStream;
import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.org.postgresql.core.BaseConnection;
import com.alibaba.hologres.org.postgresql.jdbc.ArrayUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class RecordBinaryOutputStream
extends RecordOutputStream {
    boolean fillHeader = false;
    private static final short NUMERIC_POS = 0;
    private static final short NUMERIC_NEG = 16384;
    private static final short DEC_DIGITS = 4;
    public static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().optionalStart().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalStart().appendOffset("+HH", "Z").optionalEnd().toFormatter();
    private static final long PG_EPOCH_SECS = 946684800L;

    public RecordBinaryOutputStream(OutputStream os, TableSchema schema, BaseConnection conn, int maxCellBufferSize) {
        super(os, schema, conn, maxCellBufferSize);
    }

    private void fillHeader() throws IOException {
        this.write("PGCOPY\n".getBytes(UTF8));
        this.write(255);
        this.write("\r\n".getBytes(UTF8));
        this.write(0);
        this.writeInt(0);
        this.writeInt(0);
    }

    @Override
    protected void fillByteBuffer(Record record) throws IOException {
        if (!this.fillHeader) {
            this.fillHeader = true;
            this.fillHeader();
        }
        this.writeShort((short)record.getBitSet().cardinality());
        int index = 0;
        for (Column column : record.getSchema().getColumnSchema()) {
            try {
                if (record.isSet(index)) {
                    this.fillByteBuffer(record.getObject(index), column);
                }
            }
            catch (Exception e) {
                throw new IOException("fail to convert column " + column.getName() + " type " + column.getTypeName() + " value " + record.getObject(index) + " to binary", e);
            }
            ++index;
        }
    }

    private void fillByteBuffer(Object obj, Column column) throws IOException {
        if (obj == null) {
            this.writeInt(-1);
            return;
        }
        int type = column.getType();
        String typeName = column.getTypeName();
        String columnName = column.getName();
        switch (type) {
            case 5: {
                if (obj instanceof Number) {
                    this.writeInt(2);
                    this.writeShort(((Number)obj).shortValue());
                    break;
                }
                throw new IOException("unsupported class for int2 : " + obj.getClass().getName());
            }
            case 4: {
                if (obj instanceof Number) {
                    this.writeInt(4);
                    this.writeInt(((Number)obj).intValue());
                    break;
                }
                throw new IOException("unsupported class for int4 : " + obj.getClass().getName());
            }
            case -5: {
                if (obj instanceof Number) {
                    this.writeInt(8);
                    this.writeLong(((Number)obj).longValue());
                    break;
                }
                throw new IOException("unsupported class for int8 : " + obj.getClass().getName());
            }
            case 1: 
            case 12: {
                byte[] bytes = obj.toString().getBytes(UTF8);
                this.writeInt(bytes.length);
                this.write(bytes);
                break;
            }
            case -7: {
                if ("bool".equals(typeName)) {
                    if (obj instanceof Boolean) {
                        this.writeInt(1);
                        this.write((Boolean)obj != false ? 1 : 0);
                        break;
                    }
                    if (obj instanceof Number) {
                        this.writeInt(1);
                        this.write(((Number)obj).intValue() > 0 ? 1 : 0);
                        break;
                    }
                    throw new IOException("unsupported class for bool : " + obj.getClass().getName());
                }
                throw new IOException("unsupported type:" + typeName);
            }
            case 7: {
                if ("float4".equals(typeName)) {
                    if (obj instanceof Float) {
                        this.writeInt(4);
                        this.writeFloat(((Float)obj).floatValue());
                        break;
                    }
                    if (obj instanceof Number) {
                        this.writeInt(4);
                        this.writeFloat(((Number)obj).floatValue());
                        break;
                    }
                    throw new IOException("unsupported class for bool : " + obj.getClass().getName());
                }
                throw new IOException("unsupported type:" + typeName);
            }
            case 8: {
                if ("float8".equals(typeName)) {
                    if (obj instanceof Double) {
                        this.writeInt(8);
                        this.writeDouble((Double)obj);
                        break;
                    }
                    if (obj instanceof Number) {
                        this.writeInt(8);
                        this.writeDouble(((Number)obj).doubleValue());
                        break;
                    }
                    throw new IOException("unsupported class for bool : " + obj.getClass().getName());
                }
                throw new IOException("unsupported type:" + typeName);
            }
            case 91: {
                byte[] val = new byte[4];
                try {
                    if (obj instanceof Date) {
                        this.timestampUtils.toBinDate(null, val, (Date)obj);
                    } else if (obj instanceof java.util.Date) {
                        Date tmpd = new Date(((java.util.Date)obj).getTime());
                        this.timestampUtils.toBinDate(null, val, tmpd);
                    } else if (obj instanceof String) {
                        this.timestampUtils.toBinDate(null, val, this.timestampUtils.toDate(null, (String)obj));
                    } else {
                        throw new IOException("unsupported class for date : " + obj.getClass().getName());
                    }
                    this.writeInt(4);
                    this.write(val);
                    break;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            case 93: {
                if (obj instanceof Timestamp) {
                    Timestamp ts = (Timestamp)obj;
                    long seconds = RecordBinaryOutputStream.javaEpochToPg(ts.getTime() / 1000L, TimeUnit.SECONDS);
                    long micros = TimeUnit.SECONDS.toMicros(seconds) + TimeUnit.NANOSECONDS.toMicros(ts.getNanos() + 500);
                    if ("timestamp".equals(typeName)) {
                        micros += (long)TimeZone.getDefault().getRawOffset() * 1000L;
                    }
                    this.writeInt(8);
                    this.writeLong(micros);
                    break;
                }
                if (obj instanceof String) {
                    OffsetDateTime dateTime = OffsetDateTime.parse((String)obj, DATE_TIME_FORMATTER);
                    long seconds = RecordBinaryOutputStream.javaEpochToPg(dateTime.toEpochSecond(), TimeUnit.SECONDS);
                    long micros = TimeUnit.SECONDS.toMicros(seconds) + TimeUnit.NANOSECONDS.toMicros(dateTime.getNano() + 500);
                    this.writeInt(8);
                    this.writeLong(micros);
                    break;
                }
                if (obj instanceof Number) {
                    long ms = ((Number)obj).longValue();
                    long seconds = RecordBinaryOutputStream.javaEpochToPg(ms / 1000L, TimeUnit.SECONDS);
                    long micros = TimeUnit.SECONDS.toMicros(seconds) + TimeUnit.NANOSECONDS.toMicros(ms % 1000L * 1000000L + 500L);
                    this.writeInt(8);
                    this.writeLong(micros);
                    break;
                }
                if (obj instanceof java.util.Date) {
                    long ms = ((java.util.Date)obj).getTime();
                    long seconds = RecordBinaryOutputStream.javaEpochToPg(ms / 1000L, TimeUnit.SECONDS);
                    long micros = TimeUnit.SECONDS.toMicros(seconds) + TimeUnit.NANOSECONDS.toMicros(ms % 1000L * 1000000L + 500L);
                    this.writeInt(8);
                    this.writeLong(micros);
                    break;
                }
                throw new RuntimeException("unsupported type for timestamp " + obj.getClass().getName());
            }
            case -2: {
                if (!(obj instanceof byte[])) break;
                byte[] binary = (byte[])obj;
                this.writeInt(binary.length);
                this.write(binary);
                break;
            }
            case 2: {
                BigDecimal decimal;
                if (obj instanceof String) {
                    decimal = new BigDecimal((String)obj);
                } else if (obj instanceof BigDecimal) {
                    decimal = (BigDecimal)obj;
                } else if (obj instanceof Integer) {
                    decimal = new BigDecimal((Integer)obj);
                } else if (obj instanceof Long) {
                    decimal = new BigDecimal((Long)obj);
                } else {
                    throw new RuntimeException("unsupported type for numeric " + obj.getClass().getName());
                }
                decimal = decimal.setScale(column.getScale(), RoundingMode.HALF_UP);
                String num = decimal.toPlainString();
                short[] info = new short[3];
                short[] digits = RecordBinaryOutputStream.encodeFromString(num, info);
                this.writeInt((4 + digits.length) * 2);
                this.writeShort((short)digits.length);
                this.writeShort(info[0]);
                this.writeShort(info[1]);
                this.writeShort(info[2]);
                for (short digit : digits) {
                    this.writeShort(digit);
                }
                break;
            }
            case 1111: {
                if ("jsonb".equals(typeName)) {
                    byte[] jsonBytes = String.valueOf(obj).getBytes(UTF8);
                    this.writeInt(jsonBytes.length + 1);
                    this.write(1);
                    this.write(jsonBytes);
                    break;
                }
                if ("json".equals(typeName)) {
                    byte[] jsonBytes = String.valueOf(obj).getBytes(UTF8);
                    this.writeInt(jsonBytes.length);
                    this.write(jsonBytes);
                    break;
                }
                if ("roaringbitmap".equals(typeName)) {
                    if (obj instanceof byte[]) {
                        byte[] rbBytes = (byte[])obj;
                        this.writeInt(rbBytes.length);
                        this.write(rbBytes);
                        break;
                    }
                    throw new RuntimeException("unsupported type for roaringbitmap " + obj.getClass().getName());
                }
                throw new IOException("unsupported type:" + typeName + "(" + type + ")");
            }
            case 2003: {
                if (this.conn == null) {
                    throw new IOException("unsupported type:" + typeName + "(" + type + "). Please call RecordBinaryOutputSteam constructor with BaseConnection Param");
                }
                try {
                    byte[] arrayBytes = ArrayUtil.arrayToBinary(this.conn, obj, column.getTypeName());
                    this.writeInt(arrayBytes.length);
                    this.write(arrayBytes);
                    break;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            default: {
                throw new IOException("unsupported type:" + typeName + "(" + type + ")");
            }
        }
    }

    private static short[] encodeFromString(String num, short[] info) {
        int ch;
        char[] numChars = num.toCharArray();
        byte[] numDigs = new byte[numChars.length - 1 + 8];
        int digs = 4;
        boolean haveDP = false;
        for (ch = 0; ch < numChars.length && numChars[ch] == '0'; ++ch) {
        }
        int sign = 0;
        int displayWeight = -1;
        int displayScale = 0;
        if (ch < numChars.length && numChars[ch] == '-') {
            sign = 16384;
            ++ch;
        }
        while (ch < numChars.length) {
            if (numChars[ch] == '.') {
                haveDP = true;
                ++ch;
                continue;
            }
            numDigs[digs++] = (byte)(numChars[ch++] - 48);
            if (!haveDP) {
                displayWeight = (short)(displayWeight + 1);
                continue;
            }
            displayScale = (short)(displayScale + 1);
        }
        short weight = displayWeight >= 0 ? (short)((displayWeight + 1 + 4 - 1) / 4 - 1) : (short)(-((-displayWeight - 1) / 4 + 1));
        int offset = (weight + 1) * 4 - (displayWeight + 1);
        int digitCount = ((digs -= 4) + offset + 4 - 1) / 4;
        int i = 4 - offset;
        short[] digits = new short[digitCount];
        int d = 0;
        while (digitCount-- > 0) {
            digits[d++] = (short)(((numDigs[i] * 10 + numDigs[i + 1]) * 10 + numDigs[i + 2]) * 10 + numDigs[i + 3]);
            i += 4;
        }
        info[0] = weight;
        info[1] = sign;
        info[2] = displayScale;
        return digits;
    }

    static long javaEpochToPg(long value, TimeUnit timeUnit) {
        return value - timeUnit.convert(946684800L, TimeUnit.SECONDS);
    }
}

